package software.amazon.awscdk.services.ecs.patterns;

/**
 * The properties for the ScheduledEc2Task using an image.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-26T08:39:03.225Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.ScheduledEc2TaskImageOptions")
@software.amazon.jsii.Jsii.Proxy(ScheduledEc2TaskImageOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScheduledEc2TaskImageOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.patterns.ScheduledTaskImageProps {

    /**
     * The minimum number of CPU units to reserve for the container.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Number getCpu() {
        return null;
    }

    /**
     * The hard limit (in MiB) of memory to present to the container.
     * <p>
     * If your container attempts to exceed the allocated memory, the container
     * is terminated.
     * <p>
     * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
     * <p>
     * Default: - No memory limit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Number getMemoryLimitMiB() {
        return null;
    }

    /**
     * The soft limit (in MiB) of memory to reserve for the container.
     * <p>
     * When system memory is under contention, Docker attempts to keep the
     * container memory within the limit. If the container requires more memory,
     * it can consume up to the value specified by the Memory property or all of
     * the available memory on the container instance—whichever comes first.
     * <p>
     * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
     * <p>
     * Default: - No memory reserved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Number getMemoryReservationMiB() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ScheduledEc2TaskImageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduledEc2TaskImageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Number cpu;
        private java.lang.Number memoryLimitMiB;
        private java.lang.Number memoryReservationMiB;
        private software.amazon.awscdk.services.ecs.ContainerImage image;
        private java.util.List<java.lang.String> command;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private software.amazon.awscdk.services.ecs.LogDriver logDriver;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;

        /**
         * Sets the value of {@link ScheduledEc2TaskImageOptions#getCpu}
         * @param cpu The minimum number of CPU units to reserve for the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.Number cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledEc2TaskImageOptions#getMemoryLimitMiB}
         * @param memoryLimitMiB The hard limit (in MiB) of memory to present to the container.
         *                       If your container attempts to exceed the allocated memory, the container
         *                       is terminated.
         *                       <p>
         *                       At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(java.lang.Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledEc2TaskImageOptions#getMemoryReservationMiB}
         * @param memoryReservationMiB The soft limit (in MiB) of memory to reserve for the container.
         *                             When system memory is under contention, Docker attempts to keep the
         *                             container memory within the limit. If the container requires more memory,
         *                             it can consume up to the value specified by the Memory property or all of
         *                             the available memory on the container instance—whichever comes first.
         *                             <p>
         *                             At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryReservationMiB(java.lang.Number memoryReservationMiB) {
            this.memoryReservationMiB = memoryReservationMiB;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledEc2TaskImageOptions#getImage}
         * @param image The image used to start a container. This parameter is required.
         *              Image or taskDefinition must be specified, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledEc2TaskImageOptions#getCommand}
         * @param command The command that is passed to the container.
         *                If you provide a shell command as a single string, you have to quote command-line arguments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledEc2TaskImageOptions#getEnvironment}
         * @param environment The environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledEc2TaskImageOptions#getLogDriver}
         * @param logDriver The log driver to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDriver(software.amazon.awscdk.services.ecs.LogDriver logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledEc2TaskImageOptions#getSecrets}
         * @param secrets The secret to expose to the container as an environment variable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secrets(java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets) {
            this.secrets = secrets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduledEc2TaskImageOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ScheduledEc2TaskImageOptions build() {
            return new Jsii$Proxy(cpu, memoryLimitMiB, memoryReservationMiB, image, command, environment, logDriver, secrets);
        }
    }

    /**
     * An implementation for {@link ScheduledEc2TaskImageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledEc2TaskImageOptions {
        private final java.lang.Number cpu;
        private final java.lang.Number memoryLimitMiB;
        private final java.lang.Number memoryReservationMiB;
        private final software.amazon.awscdk.services.ecs.ContainerImage image;
        private final java.util.List<java.lang.String> command;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final software.amazon.awscdk.services.ecs.LogDriver logDriver;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cpu = this.jsiiGet("cpu", java.lang.Number.class);
            this.memoryLimitMiB = this.jsiiGet("memoryLimitMiB", java.lang.Number.class);
            this.memoryReservationMiB = this.jsiiGet("memoryReservationMiB", java.lang.Number.class);
            this.image = this.jsiiGet("image", software.amazon.awscdk.services.ecs.ContainerImage.class);
            this.command = this.jsiiGet("command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = this.jsiiGet("environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.logDriver = this.jsiiGet("logDriver", software.amazon.awscdk.services.ecs.LogDriver.class);
            this.secrets = this.jsiiGet("secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number cpu, final java.lang.Number memoryLimitMiB, final java.lang.Number memoryReservationMiB, final software.amazon.awscdk.services.ecs.ContainerImage image, final java.util.List<java.lang.String> command, final java.util.Map<java.lang.String, java.lang.String> environment, final software.amazon.awscdk.services.ecs.LogDriver logDriver, final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cpu = cpu;
            this.memoryLimitMiB = memoryLimitMiB;
            this.memoryReservationMiB = memoryReservationMiB;
            this.image = java.util.Objects.requireNonNull(image, "image is required");
            this.command = command;
            this.environment = environment;
            this.logDriver = logDriver;
            this.secrets = secrets;
        }

        @Override
        public java.lang.Number getCpu() {
            return this.cpu;
        }

        @Override
        public java.lang.Number getMemoryLimitMiB() {
            return this.memoryLimitMiB;
        }

        @Override
        public java.lang.Number getMemoryReservationMiB() {
            return this.memoryReservationMiB;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.image;
        }

        @Override
        public java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public software.amazon.awscdk.services.ecs.LogDriver getLogDriver() {
            return this.logDriver;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecrets() {
            return this.secrets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getMemoryLimitMiB() != null) {
                data.set("memoryLimitMiB", om.valueToTree(this.getMemoryLimitMiB()));
            }
            if (this.getMemoryReservationMiB() != null) {
                data.set("memoryReservationMiB", om.valueToTree(this.getMemoryReservationMiB()));
            }
            data.set("image", om.valueToTree(this.getImage()));
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getLogDriver() != null) {
                data.set("logDriver", om.valueToTree(this.getLogDriver()));
            }
            if (this.getSecrets() != null) {
                data.set("secrets", om.valueToTree(this.getSecrets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs-patterns.ScheduledEc2TaskImageOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduledEc2TaskImageOptions.Jsii$Proxy that = (ScheduledEc2TaskImageOptions.Jsii$Proxy) o;

            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.memoryLimitMiB != null ? !this.memoryLimitMiB.equals(that.memoryLimitMiB) : that.memoryLimitMiB != null) return false;
            if (this.memoryReservationMiB != null ? !this.memoryReservationMiB.equals(that.memoryReservationMiB) : that.memoryReservationMiB != null) return false;
            if (!image.equals(that.image)) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.logDriver != null ? !this.logDriver.equals(that.logDriver) : that.logDriver != null) return false;
            return this.secrets != null ? this.secrets.equals(that.secrets) : that.secrets == null;
        }

        @Override
        public int hashCode() {
            int result = this.cpu != null ? this.cpu.hashCode() : 0;
            result = 31 * result + (this.memoryLimitMiB != null ? this.memoryLimitMiB.hashCode() : 0);
            result = 31 * result + (this.memoryReservationMiB != null ? this.memoryReservationMiB.hashCode() : 0);
            result = 31 * result + (this.image.hashCode());
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.logDriver != null ? this.logDriver.hashCode() : 0);
            result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
            return result;
        }
    }
}
