package software.amazon.awscdk.services.ecs.patterns;

/**
 * The properties for the ScheduledFargateTask task.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-26T08:39:03.227Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.ScheduledFargateTaskProps")
@software.amazon.jsii.Jsii.Proxy(ScheduledFargateTaskProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScheduledFargateTaskProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.patterns.ScheduledTaskBaseProps {

    /**
     * The properties to define if using an existing TaskDefinition in this construct.
     * <p>
     * ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions getScheduledFargateTaskDefinitionOptions() {
        return null;
    }

    /**
     * The properties to define if the construct is to create a TaskDefinition.
     * <p>
     * ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions getScheduledFargateTaskImageOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ScheduledFargateTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduledFargateTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions scheduledFargateTaskDefinitionOptions;
        private software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions scheduledFargateTaskImageOptions;
        private software.amazon.awscdk.services.applicationautoscaling.Schedule schedule;
        private software.amazon.awscdk.services.ecs.ICluster cluster;
        private java.lang.Number desiredTaskCount;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getScheduledFargateTaskDefinitionOptions}
         * @param scheduledFargateTaskDefinitionOptions The properties to define if using an existing TaskDefinition in this construct.
         *                                              ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledFargateTaskDefinitionOptions(software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions scheduledFargateTaskDefinitionOptions) {
            this.scheduledFargateTaskDefinitionOptions = scheduledFargateTaskDefinitionOptions;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getScheduledFargateTaskImageOptions}
         * @param scheduledFargateTaskImageOptions The properties to define if the construct is to create a TaskDefinition.
         *                                         ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledFargateTaskImageOptions(software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions scheduledFargateTaskImageOptions) {
            this.scheduledFargateTaskImageOptions = scheduledFargateTaskImageOptions;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getSchedule}
         * @param schedule The schedule or rate (frequency) that determines when CloudWatch Events runs the rule. This parameter is required.
         *                 For more information, see
         *                 <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expression Syntax for Rules</a>
         *                 in the Amazon CloudWatch User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.applicationautoscaling.Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getCluster}
         * @param cluster The name of the cluster that hosts the service.
         *                If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getDesiredTaskCount}
         * @param desiredTaskCount The desired number of instantiations of the task definition to keep running on the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredTaskCount(java.lang.Number desiredTaskCount) {
            this.desiredTaskCount = desiredTaskCount;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getVpc}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         *            If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduledFargateTaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ScheduledFargateTaskProps build() {
            return new Jsii$Proxy(scheduledFargateTaskDefinitionOptions, scheduledFargateTaskImageOptions, schedule, cluster, desiredTaskCount, vpc);
        }
    }

    /**
     * An implementation for {@link ScheduledFargateTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledFargateTaskProps {
        private final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions scheduledFargateTaskDefinitionOptions;
        private final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions scheduledFargateTaskImageOptions;
        private final software.amazon.awscdk.services.applicationautoscaling.Schedule schedule;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final java.lang.Number desiredTaskCount;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scheduledFargateTaskDefinitionOptions = this.jsiiGet("scheduledFargateTaskDefinitionOptions", software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions.class);
            this.scheduledFargateTaskImageOptions = this.jsiiGet("scheduledFargateTaskImageOptions", software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions.class);
            this.schedule = this.jsiiGet("schedule", software.amazon.awscdk.services.applicationautoscaling.Schedule.class);
            this.cluster = this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
            this.desiredTaskCount = this.jsiiGet("desiredTaskCount", java.lang.Number.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions scheduledFargateTaskDefinitionOptions, final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions scheduledFargateTaskImageOptions, final software.amazon.awscdk.services.applicationautoscaling.Schedule schedule, final software.amazon.awscdk.services.ecs.ICluster cluster, final java.lang.Number desiredTaskCount, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scheduledFargateTaskDefinitionOptions = scheduledFargateTaskDefinitionOptions;
            this.scheduledFargateTaskImageOptions = scheduledFargateTaskImageOptions;
            this.schedule = java.util.Objects.requireNonNull(schedule, "schedule is required");
            this.cluster = cluster;
            this.desiredTaskCount = desiredTaskCount;
            this.vpc = vpc;
        }

        @Override
        public software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions getScheduledFargateTaskDefinitionOptions() {
            return this.scheduledFargateTaskDefinitionOptions;
        }

        @Override
        public software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions getScheduledFargateTaskImageOptions() {
            return this.scheduledFargateTaskImageOptions;
        }

        @Override
        public software.amazon.awscdk.services.applicationautoscaling.Schedule getSchedule() {
            return this.schedule;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public java.lang.Number getDesiredTaskCount() {
            return this.desiredTaskCount;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getScheduledFargateTaskDefinitionOptions() != null) {
                data.set("scheduledFargateTaskDefinitionOptions", om.valueToTree(this.getScheduledFargateTaskDefinitionOptions()));
            }
            if (this.getScheduledFargateTaskImageOptions() != null) {
                data.set("scheduledFargateTaskImageOptions", om.valueToTree(this.getScheduledFargateTaskImageOptions()));
            }
            data.set("schedule", om.valueToTree(this.getSchedule()));
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }
            if (this.getDesiredTaskCount() != null) {
                data.set("desiredTaskCount", om.valueToTree(this.getDesiredTaskCount()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs-patterns.ScheduledFargateTaskProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduledFargateTaskProps.Jsii$Proxy that = (ScheduledFargateTaskProps.Jsii$Proxy) o;

            if (this.scheduledFargateTaskDefinitionOptions != null ? !this.scheduledFargateTaskDefinitionOptions.equals(that.scheduledFargateTaskDefinitionOptions) : that.scheduledFargateTaskDefinitionOptions != null) return false;
            if (this.scheduledFargateTaskImageOptions != null ? !this.scheduledFargateTaskImageOptions.equals(that.scheduledFargateTaskImageOptions) : that.scheduledFargateTaskImageOptions != null) return false;
            if (!schedule.equals(that.schedule)) return false;
            if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) return false;
            if (this.desiredTaskCount != null ? !this.desiredTaskCount.equals(that.desiredTaskCount) : that.desiredTaskCount != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public int hashCode() {
            int result = this.scheduledFargateTaskDefinitionOptions != null ? this.scheduledFargateTaskDefinitionOptions.hashCode() : 0;
            result = 31 * result + (this.scheduledFargateTaskImageOptions != null ? this.scheduledFargateTaskImageOptions.hashCode() : 0);
            result = 31 * result + (this.schedule.hashCode());
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            result = 31 * result + (this.desiredTaskCount != null ? this.desiredTaskCount.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
