package software.amazon.awscdk.services.ecs.patterns;

/**
 * The base class for ScheduledEc2Task and ScheduledFargateTask tasks.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-26T08:39:03.228Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.ScheduledTaskBase")
public abstract class ScheduledTaskBase extends software.amazon.awscdk.core.Construct {

    protected ScheduledTaskBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScheduledTaskBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the ScheduledTaskBase class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ScheduledTaskBase(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.patterns.ScheduledTaskBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Create an ECS task using the task definition provided and add it to the scheduled event rule.
     * <p>
     * @param taskDefinition the TaskDefinition to add to the event rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.targets.EcsTask addTaskDefinitionToEventTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
        return this.jsiiCall("addTaskDefinitionToEventTarget", software.amazon.awscdk.services.events.targets.EcsTask.class, new Object[] { java.util.Objects.requireNonNull(taskDefinition, "taskDefinition is required") });
    }

    /**
     * Create an AWS Log Driver with the provided streamPrefix.
     * <p>
     * @param prefix the Cloudwatch logging prefix. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AwsLogDriver createAWSLogDriver(final @org.jetbrains.annotations.NotNull java.lang.String prefix) {
        return this.jsiiCall("createAWSLogDriver", software.amazon.awscdk.services.ecs.AwsLogDriver.class, new Object[] { java.util.Objects.requireNonNull(prefix, "prefix is required") });
    }

    /**
     * Returns the default cluster.
     * <p>
     * @param scope This parameter is required.
     * @param vpc
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Cluster getDefaultCluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc vpc) {
        return this.jsiiCall("getDefaultCluster", software.amazon.awscdk.services.ecs.Cluster.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), vpc });
    }

    /**
     * Returns the default cluster.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Cluster getDefaultCluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
        return this.jsiiCall("getDefaultCluster", software.amazon.awscdk.services.ecs.Cluster.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * The name of the cluster that hosts the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
    }

    /**
     * The desired number of instantiations of the task definition to keep running on the service.
     * <p>
     * The minimum value is 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getDesiredTaskCount() {
        return this.jsiiGet("desiredTaskCount", java.lang.Number.class);
    }

    /**
     * The CloudWatch Events rule for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule getEventRule() {
        return this.jsiiGet("eventRule", software.amazon.awscdk.services.events.Rule.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.ecs.patterns.ScheduledTaskBase {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The construct node in the tree.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }
    }
}
