/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.FargatePlatformVersion;
import software.amazon.awscdk.services.ecs.FargateTaskDefinition;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.patterns.;
import software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageProps;
import software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancerProps;
import software.amazon.awscdk.services.ecs.patterns.NetworkMultipleTargetGroupsFargateServiceProps;
import software.amazon.awscdk.services.ecs.patterns.NetworkMultipleTargetGroupsServiceBaseProps;
import software.amazon.awscdk.services.ecs.patterns.NetworkTargetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs-patterns.NetworkMultipleTargetGroupsFargateServiceProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface NetworkMultipleTargetGroupsFargateServiceProps
extends JsiiSerializable,
NetworkMultipleTargetGroupsServiceBaseProps {
    @Nullable
    default public Boolean getAssignPublicIp() {
        return null;
    }

    @Nullable
    default public Number getCpu() {
        return null;
    }

    @Nullable
    default public Number getMemoryLimitMiB() {
        return null;
    }

    @Nullable
    default public FargatePlatformVersion getPlatformVersion() {
        return null;
    }

    @Nullable
    default public FargateTaskDefinition getTaskDefinition() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean assignPublicIp;
        private Number cpu;
        private Number memoryLimitMiB;
        private FargatePlatformVersion platformVersion;
        private FargateTaskDefinition taskDefinition;
        private CloudMapOptions cloudMapOptions;
        private ICluster cluster;
        private Number desiredCount;
        private Boolean enableEcsManagedTags;
        private Duration healthCheckGracePeriod;
        private List<NetworkLoadBalancerProps> loadBalancers;
        private PropagatedTagSource propagateTags;
        private String serviceName;
        private List<NetworkTargetProps> targetGroups;
        private NetworkLoadBalancedTaskImageProps taskImageOptions;
        private IVpc vpc;

        public Builder assignPublicIp(Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        public Builder cpu(Number cpu) {
            this.cpu = cpu;
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        public Builder platformVersion(FargatePlatformVersion platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public Builder taskDefinition(FargateTaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public Builder cloudMapOptions(CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        public Builder healthCheckGracePeriod(Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public Builder loadBalancers(List<NetworkLoadBalancerProps> loadBalancers) {
            this.loadBalancers = loadBalancers;
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder targetGroups(List<NetworkTargetProps> targetGroups) {
            this.targetGroups = targetGroups;
            return this;
        }

        public Builder taskImageOptions(NetworkLoadBalancedTaskImageProps taskImageOptions) {
            this.taskImageOptions = taskImageOptions;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public NetworkMultipleTargetGroupsFargateServiceProps build() {
            return new Jsii.Proxy(this.assignPublicIp, this.cpu, this.memoryLimitMiB, this.platformVersion, this.taskDefinition, this.cloudMapOptions, this.cluster, this.desiredCount, this.enableEcsManagedTags, this.healthCheckGracePeriod, this.loadBalancers, this.propagateTags, this.serviceName, this.targetGroups, this.taskImageOptions, this.vpc, null);
        }
    }
}

