/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.AwsLogDriver;
import software.amazon.awscdk.services.ecs.BaseService;
import software.amazon.awscdk.services.ecs.Cluster;
import software.amazon.awscdk.services.ecs.ContainerDefinition;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.patterns.;
import software.amazon.awscdk.services.ecs.patterns.NetworkMultipleTargetGroupsServiceBaseProps;
import software.amazon.awscdk.services.ecs.patterns.NetworkTargetProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs-patterns.NetworkMultipleTargetGroupsServiceBase")
public abstract class NetworkMultipleTargetGroupsServiceBase
extends Construct {
    protected NetworkMultipleTargetGroupsServiceBase(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkMultipleTargetGroupsServiceBase(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected NetworkMultipleTargetGroupsServiceBase(@NotNull Construct scope, @NotNull String id, @Nullable NetworkMultipleTargetGroupsServiceBaseProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    protected NetworkMultipleTargetGroupsServiceBase(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    protected void addPortMappingForTargets(@NotNull ContainerDefinition container, @NotNull List<NetworkTargetProps> targets) {
        this.jsiiCall("addPortMappingForTargets", NativeType.VOID, new Object[]{Objects.requireNonNull(container, "container is required"), Objects.requireNonNull(targets, "targets is required")});
    }

    @NotNull
    protected AwsLogDriver createAWSLogDriver(@NotNull String prefix) {
        return (AwsLogDriver)this.jsiiCall("createAWSLogDriver", AwsLogDriver.class, new Object[]{Objects.requireNonNull(prefix, "prefix is required")});
    }

    @NotNull
    protected NetworkListener findListener(@Nullable String name) {
        return (NetworkListener)this.jsiiCall("findListener", NetworkListener.class, new Object[]{name});
    }

    @NotNull
    protected NetworkListener findListener() {
        return (NetworkListener)this.jsiiCall("findListener", NetworkListener.class, new Object[0]);
    }

    @NotNull
    protected Cluster getDefaultCluster(@NotNull Construct scope, @Nullable IVpc vpc) {
        return (Cluster)this.jsiiCall("getDefaultCluster", Cluster.class, new Object[]{Objects.requireNonNull(scope, "scope is required"), vpc});
    }

    @NotNull
    protected Cluster getDefaultCluster(@NotNull Construct scope) {
        return (Cluster)this.jsiiCall("getDefaultCluster", Cluster.class, new Object[]{Objects.requireNonNull(scope, "scope is required")});
    }

    @NotNull
    protected NetworkTargetGroup registerECSTargets(@NotNull BaseService service, @NotNull ContainerDefinition container, @NotNull List<NetworkTargetProps> targets) {
        return (NetworkTargetGroup)this.jsiiCall("registerECSTargets", NetworkTargetGroup.class, new Object[]{Objects.requireNonNull(service, "service is required"), Objects.requireNonNull(container, "container is required"), Objects.requireNonNull(targets, "targets is required")});
    }

    @NotNull
    public ICluster getCluster() {
        return (ICluster)this.jsiiGet("cluster", ICluster.class);
    }

    @NotNull
    public Number getDesiredCount() {
        return (Number)this.jsiiGet("desiredCount", Number.class);
    }

    @NotNull
    public NetworkListener getListener() {
        return (NetworkListener)this.jsiiGet("listener", NetworkListener.class);
    }

    @NotNull
    public NetworkLoadBalancer getLoadBalancer() {
        return (NetworkLoadBalancer)this.jsiiGet("loadBalancer", NetworkLoadBalancer.class);
    }

    @NotNull
    protected List<NetworkListener> getListeners() {
        return Collections.unmodifiableList((List)this.jsiiGet("listeners", NativeType.listOf((NativeType)NativeType.forClass(NetworkListener.class))));
    }

    protected void setListeners(@NotNull List<NetworkListener> value) {
        this.jsiiSet("listeners", Objects.requireNonNull(value, "listeners is required"));
    }

    @NotNull
    protected List<NetworkTargetGroup> getTargetGroups() {
        return Collections.unmodifiableList((List)this.jsiiGet("targetGroups", NativeType.listOf((NativeType)NativeType.forClass(NetworkTargetGroup.class))));
    }

    protected void setTargetGroups(@NotNull List<NetworkTargetGroup> value) {
        this.jsiiSet("targetGroups", Objects.requireNonNull(value, "targetGroups is required"));
    }

    @Nullable
    protected LogDriver getLogDriver() {
        return (LogDriver)this.jsiiGet("logDriver", LogDriver.class);
    }

    protected void setLogDriver(@Nullable LogDriver value) {
        this.jsiiSet("logDriver", value);
    }
}

