/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.applicationautoscaling.ScalingInterval;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.BaseService;
import software.amazon.awscdk.services.ecs.Cluster;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.Secret;
import software.amazon.awscdk.services.ecs.patterns.;
import software.amazon.awscdk.services.ecs.patterns.QueueProcessingServiceBaseProps;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs-patterns.QueueProcessingServiceBase")
public abstract class QueueProcessingServiceBase
extends Construct {
    protected QueueProcessingServiceBase(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected QueueProcessingServiceBase(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected QueueProcessingServiceBase(@NotNull Construct scope, @NotNull String id, @NotNull QueueProcessingServiceBaseProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    protected void configureAutoscalingForService(@NotNull BaseService service) {
        this.jsiiCall("configureAutoscalingForService", NativeType.VOID, new Object[]{Objects.requireNonNull(service, "service is required")});
    }

    @NotNull
    protected Cluster getDefaultCluster(@NotNull Construct scope, @Nullable IVpc vpc) {
        return (Cluster)this.jsiiCall("getDefaultCluster", Cluster.class, new Object[]{Objects.requireNonNull(scope, "scope is required"), vpc});
    }

    @NotNull
    protected Cluster getDefaultCluster(@NotNull Construct scope) {
        return (Cluster)this.jsiiCall("getDefaultCluster", Cluster.class, new Object[]{Objects.requireNonNull(scope, "scope is required")});
    }

    protected void grantPermissionsToService(@NotNull BaseService service) {
        this.jsiiCall("grantPermissionsToService", NativeType.VOID, new Object[]{Objects.requireNonNull(service, "service is required")});
    }

    @NotNull
    public ICluster getCluster() {
        return (ICluster)this.jsiiGet("cluster", ICluster.class);
    }

    @NotNull
    public Number getDesiredCount() {
        return (Number)this.jsiiGet("desiredCount", Number.class);
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("environment", NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Number getMaxCapacity() {
        return (Number)this.jsiiGet("maxCapacity", Number.class);
    }

    @NotNull
    public List<ScalingInterval> getScalingSteps() {
        return Collections.unmodifiableList((List)this.jsiiGet("scalingSteps", NativeType.listOf((NativeType)NativeType.forClass(ScalingInterval.class))));
    }

    @NotNull
    public IQueue getSqsQueue() {
        return (IQueue)this.jsiiGet("sqsQueue", IQueue.class);
    }

    @Nullable
    public IQueue getDeadLetterQueue() {
        return (IQueue)this.jsiiGet("deadLetterQueue", IQueue.class);
    }

    @Nullable
    public LogDriver getLogDriver() {
        return (LogDriver)this.jsiiGet("logDriver", LogDriver.class);
    }

    @Nullable
    public Map<String, Secret> getSecrets() {
        return Optional.ofNullable((Map)this.jsiiGet("secrets", NativeType.mapOf((NativeType)NativeType.forClass(Secret.class)))).map(Collections::unmodifiableMap).orElse(null);
    }
}

