/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.applicationautoscaling.ScalingInterval;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.ContainerImage;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.Secret;
import software.amazon.awscdk.services.ecs.patterns.$Module;
import software.amazon.awscdk.services.ecs.patterns.QueueProcessingServiceBaseProps;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecs-patterns.QueueProcessingServiceBaseProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface QueueProcessingServiceBaseProps
extends JsiiSerializable {
    @NotNull
    public ContainerImage getImage();

    @Nullable
    default public ICluster getCluster() {
        return null;
    }

    @Nullable
    default public List<String> getCommand() {
        return null;
    }

    @Nullable
    default public Number getDesiredTaskCount() {
        return null;
    }

    @Nullable
    default public Boolean getEnableEcsManagedTags() {
        return null;
    }

    @Nullable
    default public Boolean getEnableLogging() {
        return null;
    }

    @Nullable
    default public Map<String, String> getEnvironment() {
        return null;
    }

    @Nullable
    default public String getFamily() {
        return null;
    }

    @Nullable
    default public LogDriver getLogDriver() {
        return null;
    }

    @Nullable
    default public Number getMaxReceiveCount() {
        return null;
    }

    @Nullable
    default public Number getMaxScalingCapacity() {
        return null;
    }

    @Nullable
    default public PropagatedTagSource getPropagateTags() {
        return null;
    }

    @Nullable
    default public IQueue getQueue() {
        return null;
    }

    @Nullable
    default public Duration getRetentionPeriod() {
        return null;
    }

    @Nullable
    default public List<ScalingInterval> getScalingSteps() {
        return null;
    }

    @Nullable
    default public Map<String, Secret> getSecrets() {
        return null;
    }

    @Nullable
    default public String getServiceName() {
        return null;
    }

    @Nullable
    default public IVpc getVpc() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ContainerImage image;
        private ICluster cluster;
        private List<String> command;
        private Number desiredTaskCount;
        private Boolean enableEcsManagedTags;
        private Boolean enableLogging;
        private Map<String, String> environment;
        private String family;
        private LogDriver logDriver;
        private Number maxReceiveCount;
        private Number maxScalingCapacity;
        private PropagatedTagSource propagateTags;
        private IQueue queue;
        private Duration retentionPeriod;
        private List<ScalingInterval> scalingSteps;
        private Map<String, Secret> secrets;
        private String serviceName;
        private IVpc vpc;

        public Builder image(ContainerImage image) {
            this.image = image;
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder command(List<String> command) {
            this.command = command;
            return this;
        }

        public Builder desiredTaskCount(Number desiredTaskCount) {
            this.desiredTaskCount = desiredTaskCount;
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        public Builder enableLogging(Boolean enableLogging) {
            this.enableLogging = enableLogging;
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder family(String family) {
            this.family = family;
            return this;
        }

        public Builder logDriver(LogDriver logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        public Builder maxReceiveCount(Number maxReceiveCount) {
            this.maxReceiveCount = maxReceiveCount;
            return this;
        }

        public Builder maxScalingCapacity(Number maxScalingCapacity) {
            this.maxScalingCapacity = maxScalingCapacity;
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public Builder queue(IQueue queue) {
            this.queue = queue;
            return this;
        }

        public Builder retentionPeriod(Duration retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public Builder scalingSteps(List<ScalingInterval> scalingSteps) {
            this.scalingSteps = scalingSteps;
            return this;
        }

        public Builder secrets(Map<String, Secret> secrets) {
            this.secrets = secrets;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public QueueProcessingServiceBaseProps build() {
            return new Jsii.Proxy(this.image, this.cluster, this.command, this.desiredTaskCount, this.enableEcsManagedTags, this.enableLogging, this.environment, this.family, this.logDriver, this.maxReceiveCount, this.maxScalingCapacity, this.propagateTags, this.queue, this.retentionPeriod, this.scalingSteps, this.secrets, this.serviceName, this.vpc, null);
        }
    }
}

