package software.amazon.awscdk.services.elasticloadbalancing;

/**
 * A CloudFormation `AWS::ElasticLoadBalancing::LoadBalancer`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-28T21:12:28.523Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer")
public class CfnLoadBalancer extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnLoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ElasticLoadBalancing::LoadBalancer`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLoadBalancer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A factory method that creates a new instance of this class from an object containing the CloudFormation properties of this resource.
     * <p>
     * Used in the &#64;aws-cdk/cloudformation-include module.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param resourceAttributes This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer fromCloudFormation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.Object resourceAttributes, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FromCloudFormationOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.class, "fromCloudFormation", software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), resourceAttributes, java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCanonicalHostedZoneName() {
        return this.jsiiGet("attrCanonicalHostedZoneName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCanonicalHostedZoneNameId() {
        return this.jsiiGet("attrCanonicalHostedZoneNameId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDnsName() {
        return this.jsiiGet("attrDnsName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSourceSecurityGroupGroupName() {
        return this.jsiiGet("attrSourceSecurityGroupGroupName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSourceSecurityGroupOwnerAlias() {
        return this.jsiiGet("attrSourceSecurityGroupOwnerAlias", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-elasticloadbalancing-loadbalancer-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-listeners
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getListeners() {
        return this.jsiiGet("listeners", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-listeners
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setListeners(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("listeners", java.util.Objects.requireNonNull(value, "listeners is required"));
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-listeners
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setListeners(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        this.jsiiSet("listeners", java.util.Objects.requireNonNull(value, "listeners is required"));
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-accessloggingpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccessLoggingPolicy() {
        return this.jsiiGet("accessLoggingPolicy", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-accessloggingpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessLoggingPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("accessLoggingPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-accessloggingpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessLoggingPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty value) {
        this.jsiiSet("accessLoggingPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-appcookiestickinesspolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAppCookieStickinessPolicy() {
        return this.jsiiGet("appCookieStickinessPolicy", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-appcookiestickinesspolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppCookieStickinessPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("appCookieStickinessPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-appcookiestickinesspolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppCookieStickinessPolicy(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("appCookieStickinessPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AvailabilityZones`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-availabilityzones
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AvailabilityZones`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-availabilityzones
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZones(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("availabilityZones", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectiondrainingpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConnectionDrainingPolicy() {
        return this.jsiiGet("connectionDrainingPolicy", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectiondrainingpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionDrainingPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("connectionDrainingPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectiondrainingpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionDrainingPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.ConnectionDrainingPolicyProperty value) {
        this.jsiiSet("connectionDrainingPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConnectionSettings() {
        return this.jsiiGet("connectionSettings", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("connectionSettings", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.ConnectionSettingsProperty value) {
        this.jsiiSet("connectionSettings", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-crosszone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCrossZone() {
        return this.jsiiGet("crossZone", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-crosszone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCrossZone(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("crossZone", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-crosszone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCrossZone(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("crossZone", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-healthcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheck() {
        return this.jsiiGet("healthCheck", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-healthcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheck(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("healthCheck", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-healthcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheck(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.HealthCheckProperty value) {
        this.jsiiSet("healthCheck", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Instances`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-instances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstances() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("instances", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Instances`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-instances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstances(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("instances", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-lbcookiestickinesspolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLbCookieStickinessPolicy() {
        return this.jsiiGet("lbCookieStickinessPolicy", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-lbcookiestickinesspolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLbCookieStickinessPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("lbCookieStickinessPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-lbcookiestickinesspolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLbCookieStickinessPolicy(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("lbCookieStickinessPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LoadBalancerName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-elbname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerName() {
        return this.jsiiGet("loadBalancerName", java.lang.String.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LoadBalancerName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-elbname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancerName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("loadBalancerName", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Policies`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-policies
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPolicies() {
        return this.jsiiGet("policies", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Policies`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-policies
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("policies", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Policies`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-policies
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("policies", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Scheme`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-scheme
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScheme() {
        return this.jsiiGet("scheme", java.lang.String.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Scheme`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-scheme
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheme(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("scheme", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.SecurityGroups`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.SecurityGroups`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("securityGroups", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Subnets`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnets() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Subnets`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnets(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("subnets", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessLoggingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessLoggingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.S3BucketName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-s3bucketname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3BucketName();

        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.EmitInterval`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-emitinterval
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEmitInterval() {
            return null;
        }

        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.S3BucketPrefix`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-s3bucketprefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessLoggingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessLoggingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessLoggingPolicyProperty> {
            private java.lang.Object enabled;
            private java.lang.String s3BucketName;
            private java.lang.Number emitInterval;
            private java.lang.String s3BucketPrefix;

            /**
             * Sets the value of {@link AccessLoggingPolicyProperty#getEnabled}
             * @param enabled `CfnLoadBalancer.AccessLoggingPolicyProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AccessLoggingPolicyProperty#getEnabled}
             * @param enabled `CfnLoadBalancer.AccessLoggingPolicyProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AccessLoggingPolicyProperty#getS3BucketName}
             * @param s3BucketName `CfnLoadBalancer.AccessLoggingPolicyProperty.S3BucketName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link AccessLoggingPolicyProperty#getEmitInterval}
             * @param emitInterval `CfnLoadBalancer.AccessLoggingPolicyProperty.EmitInterval`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emitInterval(java.lang.Number emitInterval) {
                this.emitInterval = emitInterval;
                return this;
            }

            /**
             * Sets the value of {@link AccessLoggingPolicyProperty#getS3BucketPrefix}
             * @param s3BucketPrefix `CfnLoadBalancer.AccessLoggingPolicyProperty.S3BucketPrefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketPrefix(java.lang.String s3BucketPrefix) {
                this.s3BucketPrefix = s3BucketPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLoggingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessLoggingPolicyProperty build() {
                return new Jsii$Proxy(enabled, s3BucketName, emitInterval, s3BucketPrefix);
            }
        }

        /**
         * An implementation for {@link AccessLoggingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessLoggingPolicyProperty {
            private final java.lang.Object enabled;
            private final java.lang.String s3BucketName;
            private final java.lang.Number emitInterval;
            private final java.lang.String s3BucketPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.s3BucketName = this.jsiiGet("s3BucketName", java.lang.String.class);
                this.emitInterval = this.jsiiGet("emitInterval", java.lang.Number.class);
                this.s3BucketPrefix = this.jsiiGet("s3BucketPrefix", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object enabled, final java.lang.String s3BucketName, final java.lang.Number emitInterval, final java.lang.String s3BucketPrefix) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.s3BucketName = java.util.Objects.requireNonNull(s3BucketName, "s3BucketName is required");
                this.emitInterval = emitInterval;
                this.s3BucketPrefix = s3BucketPrefix;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public java.lang.Number getEmitInterval() {
                return this.emitInterval;
            }

            @Override
            public java.lang.String getS3BucketPrefix() {
                return this.s3BucketPrefix;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                if (this.getEmitInterval() != null) {
                    data.set("emitInterval", om.valueToTree(this.getEmitInterval()));
                }
                if (this.getS3BucketPrefix() != null) {
                    data.set("s3BucketPrefix", om.valueToTree(this.getS3BucketPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessLoggingPolicyProperty.Jsii$Proxy that = (AccessLoggingPolicyProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (!s3BucketName.equals(that.s3BucketName)) return false;
                if (this.emitInterval != null ? !this.emitInterval.equals(that.emitInterval) : that.emitInterval != null) return false;
                return this.s3BucketPrefix != null ? this.s3BucketPrefix.equals(that.s3BucketPrefix) : that.s3BucketPrefix == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.s3BucketName.hashCode());
                result = 31 * result + (this.emitInterval != null ? this.emitInterval.hashCode() : 0);
                result = 31 * result + (this.s3BucketPrefix != null ? this.s3BucketPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-AppCookieStickinessPolicy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.AppCookieStickinessPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AppCookieStickinessPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AppCookieStickinessPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.AppCookieStickinessPolicyProperty.CookieName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-AppCookieStickinessPolicy.html#cfn-elb-appcookiestickinesspolicy-cookiename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCookieName();

        /**
         * `CfnLoadBalancer.AppCookieStickinessPolicyProperty.PolicyName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-AppCookieStickinessPolicy.html#cfn-elb-appcookiestickinesspolicy-policyname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPolicyName();

        /**
         * @return a {@link Builder} of {@link AppCookieStickinessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AppCookieStickinessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AppCookieStickinessPolicyProperty> {
            private java.lang.String cookieName;
            private java.lang.String policyName;

            /**
             * Sets the value of {@link AppCookieStickinessPolicyProperty#getCookieName}
             * @param cookieName `CfnLoadBalancer.AppCookieStickinessPolicyProperty.CookieName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookieName(java.lang.String cookieName) {
                this.cookieName = cookieName;
                return this;
            }

            /**
             * Sets the value of {@link AppCookieStickinessPolicyProperty#getPolicyName}
             * @param policyName `CfnLoadBalancer.AppCookieStickinessPolicyProperty.PolicyName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyName(java.lang.String policyName) {
                this.policyName = policyName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AppCookieStickinessPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AppCookieStickinessPolicyProperty build() {
                return new Jsii$Proxy(cookieName, policyName);
            }
        }

        /**
         * An implementation for {@link AppCookieStickinessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppCookieStickinessPolicyProperty {
            private final java.lang.String cookieName;
            private final java.lang.String policyName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cookieName = this.jsiiGet("cookieName", java.lang.String.class);
                this.policyName = this.jsiiGet("policyName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String cookieName, final java.lang.String policyName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cookieName = java.util.Objects.requireNonNull(cookieName, "cookieName is required");
                this.policyName = java.util.Objects.requireNonNull(policyName, "policyName is required");
            }

            @Override
            public java.lang.String getCookieName() {
                return this.cookieName;
            }

            @Override
            public java.lang.String getPolicyName() {
                return this.policyName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cookieName", om.valueToTree(this.getCookieName()));
                data.set("policyName", om.valueToTree(this.getPolicyName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.AppCookieStickinessPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AppCookieStickinessPolicyProperty.Jsii$Proxy that = (AppCookieStickinessPolicyProperty.Jsii$Proxy) o;

                if (!cookieName.equals(that.cookieName)) return false;
                return this.policyName.equals(that.policyName);
            }

            @Override
            public int hashCode() {
                int result = this.cookieName.hashCode();
                result = 31 * result + (this.policyName.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectiondrainingpolicy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.ConnectionDrainingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionDrainingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectionDrainingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectiondrainingpolicy.html#cfn-elb-connectiondrainingpolicy-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Timeout`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectiondrainingpolicy.html#cfn-elb-connectiondrainingpolicy-timeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectionDrainingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionDrainingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectionDrainingPolicyProperty> {
            private java.lang.Object enabled;
            private java.lang.Number timeout;

            /**
             * Sets the value of {@link ConnectionDrainingPolicyProperty#getEnabled}
             * @param enabled `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionDrainingPolicyProperty#getEnabled}
             * @param enabled `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionDrainingPolicyProperty#getTimeout}
             * @param timeout `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Timeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(java.lang.Number timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionDrainingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectionDrainingPolicyProperty build() {
                return new Jsii$Proxy(enabled, timeout);
            }
        }

        /**
         * An implementation for {@link ConnectionDrainingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionDrainingPolicyProperty {
            private final java.lang.Object enabled;
            private final java.lang.Number timeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.timeout = this.jsiiGet("timeout", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object enabled, final java.lang.Number timeout) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.timeout = timeout;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.lang.Number getTimeout() {
                return this.timeout;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.ConnectionDrainingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionDrainingPolicyProperty.Jsii$Proxy that = (ConnectionDrainingPolicyProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectionsettings.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.ConnectionSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectionSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.ConnectionSettingsProperty.IdleTimeout`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectionsettings.html#cfn-elb-connectionsettings-idletimeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getIdleTimeout();

        /**
         * @return a {@link Builder} of {@link ConnectionSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectionSettingsProperty> {
            private java.lang.Number idleTimeout;

            /**
             * Sets the value of {@link ConnectionSettingsProperty#getIdleTimeout}
             * @param idleTimeout `CfnLoadBalancer.ConnectionSettingsProperty.IdleTimeout`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idleTimeout(java.lang.Number idleTimeout) {
                this.idleTimeout = idleTimeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectionSettingsProperty build() {
                return new Jsii$Proxy(idleTimeout);
            }
        }

        /**
         * An implementation for {@link ConnectionSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionSettingsProperty {
            private final java.lang.Number idleTimeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idleTimeout = this.jsiiGet("idleTimeout", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number idleTimeout) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idleTimeout = java.util.Objects.requireNonNull(idleTimeout, "idleTimeout is required");
            }

            @Override
            public java.lang.Number getIdleTimeout() {
                return this.idleTimeout;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("idleTimeout", om.valueToTree(this.getIdleTimeout()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.ConnectionSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionSettingsProperty.Jsii$Proxy that = (ConnectionSettingsProperty.Jsii$Proxy) o;

                return this.idleTimeout.equals(that.idleTimeout);
            }

            @Override
            public int hashCode() {
                int result = this.idleTimeout.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.HealthCheckProperty")
    @software.amazon.jsii.Jsii.Proxy(HealthCheckProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HealthCheckProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.HealthCheckProperty.HealthyThreshold`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-healthythreshold
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHealthyThreshold();

        /**
         * `CfnLoadBalancer.HealthCheckProperty.Interval`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-interval
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterval();

        /**
         * `CfnLoadBalancer.HealthCheckProperty.Target`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-target
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTarget();

        /**
         * `CfnLoadBalancer.HealthCheckProperty.Timeout`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-timeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimeout();

        /**
         * `CfnLoadBalancer.HealthCheckProperty.UnhealthyThreshold`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-unhealthythreshold
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnhealthyThreshold();

        /**
         * @return a {@link Builder} of {@link HealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HealthCheckProperty> {
            private java.lang.String healthyThreshold;
            private java.lang.String interval;
            private java.lang.String target;
            private java.lang.String timeout;
            private java.lang.String unhealthyThreshold;

            /**
             * Sets the value of {@link HealthCheckProperty#getHealthyThreshold}
             * @param healthyThreshold `CfnLoadBalancer.HealthCheckProperty.HealthyThreshold`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthyThreshold(java.lang.String healthyThreshold) {
                this.healthyThreshold = healthyThreshold;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getInterval}
             * @param interval `CfnLoadBalancer.HealthCheckProperty.Interval`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.String interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getTarget}
             * @param target `CfnLoadBalancer.HealthCheckProperty.Target`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getTimeout}
             * @param timeout `CfnLoadBalancer.HealthCheckProperty.Timeout`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(java.lang.String timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getUnhealthyThreshold}
             * @param unhealthyThreshold `CfnLoadBalancer.HealthCheckProperty.UnhealthyThreshold`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unhealthyThreshold(java.lang.String unhealthyThreshold) {
                this.unhealthyThreshold = unhealthyThreshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HealthCheckProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HealthCheckProperty build() {
                return new Jsii$Proxy(healthyThreshold, interval, target, timeout, unhealthyThreshold);
            }
        }

        /**
         * An implementation for {@link HealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckProperty {
            private final java.lang.String healthyThreshold;
            private final java.lang.String interval;
            private final java.lang.String target;
            private final java.lang.String timeout;
            private final java.lang.String unhealthyThreshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.healthyThreshold = this.jsiiGet("healthyThreshold", java.lang.String.class);
                this.interval = this.jsiiGet("interval", java.lang.String.class);
                this.target = this.jsiiGet("target", java.lang.String.class);
                this.timeout = this.jsiiGet("timeout", java.lang.String.class);
                this.unhealthyThreshold = this.jsiiGet("unhealthyThreshold", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String healthyThreshold, final java.lang.String interval, final java.lang.String target, final java.lang.String timeout, final java.lang.String unhealthyThreshold) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.healthyThreshold = java.util.Objects.requireNonNull(healthyThreshold, "healthyThreshold is required");
                this.interval = java.util.Objects.requireNonNull(interval, "interval is required");
                this.target = java.util.Objects.requireNonNull(target, "target is required");
                this.timeout = java.util.Objects.requireNonNull(timeout, "timeout is required");
                this.unhealthyThreshold = java.util.Objects.requireNonNull(unhealthyThreshold, "unhealthyThreshold is required");
            }

            @Override
            public java.lang.String getHealthyThreshold() {
                return this.healthyThreshold;
            }

            @Override
            public java.lang.String getInterval() {
                return this.interval;
            }

            @Override
            public java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public java.lang.String getTimeout() {
                return this.timeout;
            }

            @Override
            public java.lang.String getUnhealthyThreshold() {
                return this.unhealthyThreshold;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("healthyThreshold", om.valueToTree(this.getHealthyThreshold()));
                data.set("interval", om.valueToTree(this.getInterval()));
                data.set("target", om.valueToTree(this.getTarget()));
                data.set("timeout", om.valueToTree(this.getTimeout()));
                data.set("unhealthyThreshold", om.valueToTree(this.getUnhealthyThreshold()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.HealthCheckProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HealthCheckProperty.Jsii$Proxy that = (HealthCheckProperty.Jsii$Proxy) o;

                if (!healthyThreshold.equals(that.healthyThreshold)) return false;
                if (!interval.equals(that.interval)) return false;
                if (!target.equals(that.target)) return false;
                if (!timeout.equals(that.timeout)) return false;
                return this.unhealthyThreshold.equals(that.unhealthyThreshold);
            }

            @Override
            public int hashCode() {
                int result = this.healthyThreshold.hashCode();
                result = 31 * result + (this.interval.hashCode());
                result = 31 * result + (this.target.hashCode());
                result = 31 * result + (this.timeout.hashCode());
                result = 31 * result + (this.unhealthyThreshold.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-LBCookieStickinessPolicy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.LBCookieStickinessPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(LBCookieStickinessPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LBCookieStickinessPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.LBCookieStickinessPolicyProperty.CookieExpirationPeriod`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-LBCookieStickinessPolicy.html#cfn-elb-lbcookiestickinesspolicy-cookieexpirationperiod
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCookieExpirationPeriod() {
            return null;
        }

        /**
         * `CfnLoadBalancer.LBCookieStickinessPolicyProperty.PolicyName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-LBCookieStickinessPolicy.html#cfn-elb-lbcookiestickinesspolicy-policyname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPolicyName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LBCookieStickinessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LBCookieStickinessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LBCookieStickinessPolicyProperty> {
            private java.lang.String cookieExpirationPeriod;
            private java.lang.String policyName;

            /**
             * Sets the value of {@link LBCookieStickinessPolicyProperty#getCookieExpirationPeriod}
             * @param cookieExpirationPeriod `CfnLoadBalancer.LBCookieStickinessPolicyProperty.CookieExpirationPeriod`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookieExpirationPeriod(java.lang.String cookieExpirationPeriod) {
                this.cookieExpirationPeriod = cookieExpirationPeriod;
                return this;
            }

            /**
             * Sets the value of {@link LBCookieStickinessPolicyProperty#getPolicyName}
             * @param policyName `CfnLoadBalancer.LBCookieStickinessPolicyProperty.PolicyName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyName(java.lang.String policyName) {
                this.policyName = policyName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LBCookieStickinessPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LBCookieStickinessPolicyProperty build() {
                return new Jsii$Proxy(cookieExpirationPeriod, policyName);
            }
        }

        /**
         * An implementation for {@link LBCookieStickinessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LBCookieStickinessPolicyProperty {
            private final java.lang.String cookieExpirationPeriod;
            private final java.lang.String policyName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cookieExpirationPeriod = this.jsiiGet("cookieExpirationPeriod", java.lang.String.class);
                this.policyName = this.jsiiGet("policyName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String cookieExpirationPeriod, final java.lang.String policyName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cookieExpirationPeriod = cookieExpirationPeriod;
                this.policyName = policyName;
            }

            @Override
            public java.lang.String getCookieExpirationPeriod() {
                return this.cookieExpirationPeriod;
            }

            @Override
            public java.lang.String getPolicyName() {
                return this.policyName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCookieExpirationPeriod() != null) {
                    data.set("cookieExpirationPeriod", om.valueToTree(this.getCookieExpirationPeriod()));
                }
                if (this.getPolicyName() != null) {
                    data.set("policyName", om.valueToTree(this.getPolicyName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.LBCookieStickinessPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LBCookieStickinessPolicyProperty.Jsii$Proxy that = (LBCookieStickinessPolicyProperty.Jsii$Proxy) o;

                if (this.cookieExpirationPeriod != null ? !this.cookieExpirationPeriod.equals(that.cookieExpirationPeriod) : that.cookieExpirationPeriod != null) return false;
                return this.policyName != null ? this.policyName.equals(that.policyName) : that.policyName == null;
            }

            @Override
            public int hashCode() {
                int result = this.cookieExpirationPeriod != null ? this.cookieExpirationPeriod.hashCode() : 0;
                result = 31 * result + (this.policyName != null ? this.policyName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.ListenersProperty")
    @software.amazon.jsii.Jsii.Proxy(ListenersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ListenersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.ListenersProperty.InstancePort`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-instanceport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstancePort();

        /**
         * `CfnLoadBalancer.ListenersProperty.LoadBalancerPort`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-loadbalancerport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerPort();

        /**
         * `CfnLoadBalancer.ListenersProperty.Protocol`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-protocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * `CfnLoadBalancer.ListenersProperty.InstanceProtocol`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-instanceprotocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceProtocol() {
            return null;
        }

        /**
         * `CfnLoadBalancer.ListenersProperty.PolicyNames`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-policynames
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPolicyNames() {
            return null;
        }

        /**
         * `CfnLoadBalancer.ListenersProperty.SSLCertificateId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-sslcertificateid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslCertificateId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ListenersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ListenersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ListenersProperty> {
            private java.lang.String instancePort;
            private java.lang.String loadBalancerPort;
            private java.lang.String protocol;
            private java.lang.String instanceProtocol;
            private java.util.List<java.lang.String> policyNames;
            private java.lang.String sslCertificateId;

            /**
             * Sets the value of {@link ListenersProperty#getInstancePort}
             * @param instancePort `CfnLoadBalancer.ListenersProperty.InstancePort`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instancePort(java.lang.String instancePort) {
                this.instancePort = instancePort;
                return this;
            }

            /**
             * Sets the value of {@link ListenersProperty#getLoadBalancerPort}
             * @param loadBalancerPort `CfnLoadBalancer.ListenersProperty.LoadBalancerPort`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerPort(java.lang.String loadBalancerPort) {
                this.loadBalancerPort = loadBalancerPort;
                return this;
            }

            /**
             * Sets the value of {@link ListenersProperty#getProtocol}
             * @param protocol `CfnLoadBalancer.ListenersProperty.Protocol`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link ListenersProperty#getInstanceProtocol}
             * @param instanceProtocol `CfnLoadBalancer.ListenersProperty.InstanceProtocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceProtocol(java.lang.String instanceProtocol) {
                this.instanceProtocol = instanceProtocol;
                return this;
            }

            /**
             * Sets the value of {@link ListenersProperty#getPolicyNames}
             * @param policyNames `CfnLoadBalancer.ListenersProperty.PolicyNames`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyNames(java.util.List<java.lang.String> policyNames) {
                this.policyNames = policyNames;
                return this;
            }

            /**
             * Sets the value of {@link ListenersProperty#getSslCertificateId}
             * @param sslCertificateId `CfnLoadBalancer.ListenersProperty.SSLCertificateId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslCertificateId(java.lang.String sslCertificateId) {
                this.sslCertificateId = sslCertificateId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ListenersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ListenersProperty build() {
                return new Jsii$Proxy(instancePort, loadBalancerPort, protocol, instanceProtocol, policyNames, sslCertificateId);
            }
        }

        /**
         * An implementation for {@link ListenersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenersProperty {
            private final java.lang.String instancePort;
            private final java.lang.String loadBalancerPort;
            private final java.lang.String protocol;
            private final java.lang.String instanceProtocol;
            private final java.util.List<java.lang.String> policyNames;
            private final java.lang.String sslCertificateId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instancePort = this.jsiiGet("instancePort", java.lang.String.class);
                this.loadBalancerPort = this.jsiiGet("loadBalancerPort", java.lang.String.class);
                this.protocol = this.jsiiGet("protocol", java.lang.String.class);
                this.instanceProtocol = this.jsiiGet("instanceProtocol", java.lang.String.class);
                this.policyNames = this.jsiiGet("policyNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sslCertificateId = this.jsiiGet("sslCertificateId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String instancePort, final java.lang.String loadBalancerPort, final java.lang.String protocol, final java.lang.String instanceProtocol, final java.util.List<java.lang.String> policyNames, final java.lang.String sslCertificateId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instancePort = java.util.Objects.requireNonNull(instancePort, "instancePort is required");
                this.loadBalancerPort = java.util.Objects.requireNonNull(loadBalancerPort, "loadBalancerPort is required");
                this.protocol = java.util.Objects.requireNonNull(protocol, "protocol is required");
                this.instanceProtocol = instanceProtocol;
                this.policyNames = policyNames;
                this.sslCertificateId = sslCertificateId;
            }

            @Override
            public java.lang.String getInstancePort() {
                return this.instancePort;
            }

            @Override
            public java.lang.String getLoadBalancerPort() {
                return this.loadBalancerPort;
            }

            @Override
            public java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public java.lang.String getInstanceProtocol() {
                return this.instanceProtocol;
            }

            @Override
            public java.util.List<java.lang.String> getPolicyNames() {
                return this.policyNames;
            }

            @Override
            public java.lang.String getSslCertificateId() {
                return this.sslCertificateId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instancePort", om.valueToTree(this.getInstancePort()));
                data.set("loadBalancerPort", om.valueToTree(this.getLoadBalancerPort()));
                data.set("protocol", om.valueToTree(this.getProtocol()));
                if (this.getInstanceProtocol() != null) {
                    data.set("instanceProtocol", om.valueToTree(this.getInstanceProtocol()));
                }
                if (this.getPolicyNames() != null) {
                    data.set("policyNames", om.valueToTree(this.getPolicyNames()));
                }
                if (this.getSslCertificateId() != null) {
                    data.set("sslCertificateId", om.valueToTree(this.getSslCertificateId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.ListenersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ListenersProperty.Jsii$Proxy that = (ListenersProperty.Jsii$Proxy) o;

                if (!instancePort.equals(that.instancePort)) return false;
                if (!loadBalancerPort.equals(that.loadBalancerPort)) return false;
                if (!protocol.equals(that.protocol)) return false;
                if (this.instanceProtocol != null ? !this.instanceProtocol.equals(that.instanceProtocol) : that.instanceProtocol != null) return false;
                if (this.policyNames != null ? !this.policyNames.equals(that.policyNames) : that.policyNames != null) return false;
                return this.sslCertificateId != null ? this.sslCertificateId.equals(that.sslCertificateId) : that.sslCertificateId == null;
            }

            @Override
            public int hashCode() {
                int result = this.instancePort.hashCode();
                result = 31 * result + (this.loadBalancerPort.hashCode());
                result = 31 * result + (this.protocol.hashCode());
                result = 31 * result + (this.instanceProtocol != null ? this.instanceProtocol.hashCode() : 0);
                result = 31 * result + (this.policyNames != null ? this.policyNames.hashCode() : 0);
                result = 31 * result + (this.sslCertificateId != null ? this.sslCertificateId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.PoliciesProperty")
    @software.amazon.jsii.Jsii.Proxy(PoliciesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PoliciesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.PoliciesProperty.Attributes`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-attributes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAttributes();

        /**
         * `CfnLoadBalancer.PoliciesProperty.PolicyName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-policyname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPolicyName();

        /**
         * `CfnLoadBalancer.PoliciesProperty.PolicyType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-policytype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPolicyType();

        /**
         * `CfnLoadBalancer.PoliciesProperty.InstancePorts`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-instanceports
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstancePorts() {
            return null;
        }

        /**
         * `CfnLoadBalancer.PoliciesProperty.LoadBalancerPorts`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-loadbalancerports
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLoadBalancerPorts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PoliciesProperty> {
            private java.lang.Object attributes;
            private java.lang.String policyName;
            private java.lang.String policyType;
            private java.util.List<java.lang.String> instancePorts;
            private java.util.List<java.lang.String> loadBalancerPorts;

            /**
             * Sets the value of {@link PoliciesProperty#getAttributes}
             * @param attributes `CfnLoadBalancer.PoliciesProperty.Attributes`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.util.List<java.lang.Object> attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link PoliciesProperty#getAttributes}
             * @param attributes `CfnLoadBalancer.PoliciesProperty.Attributes`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(software.amazon.awscdk.core.IResolvable attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link PoliciesProperty#getPolicyName}
             * @param policyName `CfnLoadBalancer.PoliciesProperty.PolicyName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyName(java.lang.String policyName) {
                this.policyName = policyName;
                return this;
            }

            /**
             * Sets the value of {@link PoliciesProperty#getPolicyType}
             * @param policyType `CfnLoadBalancer.PoliciesProperty.PolicyType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyType(java.lang.String policyType) {
                this.policyType = policyType;
                return this;
            }

            /**
             * Sets the value of {@link PoliciesProperty#getInstancePorts}
             * @param instancePorts `CfnLoadBalancer.PoliciesProperty.InstancePorts`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instancePorts(java.util.List<java.lang.String> instancePorts) {
                this.instancePorts = instancePorts;
                return this;
            }

            /**
             * Sets the value of {@link PoliciesProperty#getLoadBalancerPorts}
             * @param loadBalancerPorts `CfnLoadBalancer.PoliciesProperty.LoadBalancerPorts`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerPorts(java.util.List<java.lang.String> loadBalancerPorts) {
                this.loadBalancerPorts = loadBalancerPorts;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PoliciesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PoliciesProperty build() {
                return new Jsii$Proxy(attributes, policyName, policyType, instancePorts, loadBalancerPorts);
            }
        }

        /**
         * An implementation for {@link PoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PoliciesProperty {
            private final java.lang.Object attributes;
            private final java.lang.String policyName;
            private final java.lang.String policyType;
            private final java.util.List<java.lang.String> instancePorts;
            private final java.util.List<java.lang.String> loadBalancerPorts;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributes = this.jsiiGet("attributes", java.lang.Object.class);
                this.policyName = this.jsiiGet("policyName", java.lang.String.class);
                this.policyType = this.jsiiGet("policyType", java.lang.String.class);
                this.instancePorts = this.jsiiGet("instancePorts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.loadBalancerPorts = this.jsiiGet("loadBalancerPorts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object attributes, final java.lang.String policyName, final java.lang.String policyType, final java.util.List<java.lang.String> instancePorts, final java.util.List<java.lang.String> loadBalancerPorts) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributes = java.util.Objects.requireNonNull(attributes, "attributes is required");
                this.policyName = java.util.Objects.requireNonNull(policyName, "policyName is required");
                this.policyType = java.util.Objects.requireNonNull(policyType, "policyType is required");
                this.instancePorts = instancePorts;
                this.loadBalancerPorts = loadBalancerPorts;
            }

            @Override
            public java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            public java.lang.String getPolicyName() {
                return this.policyName;
            }

            @Override
            public java.lang.String getPolicyType() {
                return this.policyType;
            }

            @Override
            public java.util.List<java.lang.String> getInstancePorts() {
                return this.instancePorts;
            }

            @Override
            public java.util.List<java.lang.String> getLoadBalancerPorts() {
                return this.loadBalancerPorts;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributes", om.valueToTree(this.getAttributes()));
                data.set("policyName", om.valueToTree(this.getPolicyName()));
                data.set("policyType", om.valueToTree(this.getPolicyType()));
                if (this.getInstancePorts() != null) {
                    data.set("instancePorts", om.valueToTree(this.getInstancePorts()));
                }
                if (this.getLoadBalancerPorts() != null) {
                    data.set("loadBalancerPorts", om.valueToTree(this.getLoadBalancerPorts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.PoliciesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PoliciesProperty.Jsii$Proxy that = (PoliciesProperty.Jsii$Proxy) o;

                if (!attributes.equals(that.attributes)) return false;
                if (!policyName.equals(that.policyName)) return false;
                if (!policyType.equals(that.policyType)) return false;
                if (this.instancePorts != null ? !this.instancePorts.equals(that.instancePorts) : that.instancePorts != null) return false;
                return this.loadBalancerPorts != null ? this.loadBalancerPorts.equals(that.loadBalancerPorts) : that.loadBalancerPorts == null;
            }

            @Override
            public int hashCode() {
                int result = this.attributes.hashCode();
                result = 31 * result + (this.policyName.hashCode());
                result = 31 * result + (this.policyType.hashCode());
                result = 31 * result + (this.instancePorts != null ? this.instancePorts.hashCode() : 0);
                result = 31 * result + (this.loadBalancerPorts != null ? this.loadBalancerPorts.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancerProps.Builder();
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-listeners
         * @param listeners `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listeners(final software.amazon.awscdk.core.IResolvable listeners) {
            this.props.listeners(listeners);
            return this;
        }
        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-listeners
         * @param listeners `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listeners(final java.util.List<java.lang.Object> listeners) {
            this.props.listeners(listeners);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-accessloggingpolicy
         * @param accessLoggingPolicy `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLoggingPolicy(final software.amazon.awscdk.core.IResolvable accessLoggingPolicy) {
            this.props.accessLoggingPolicy(accessLoggingPolicy);
            return this;
        }
        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-accessloggingpolicy
         * @param accessLoggingPolicy `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLoggingPolicy(final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty accessLoggingPolicy) {
            this.props.accessLoggingPolicy(accessLoggingPolicy);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-appcookiestickinesspolicy
         * @param appCookieStickinessPolicy `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appCookieStickinessPolicy(final software.amazon.awscdk.core.IResolvable appCookieStickinessPolicy) {
            this.props.appCookieStickinessPolicy(appCookieStickinessPolicy);
            return this;
        }
        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-appcookiestickinesspolicy
         * @param appCookieStickinessPolicy `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appCookieStickinessPolicy(final java.util.List<java.lang.Object> appCookieStickinessPolicy) {
            this.props.appCookieStickinessPolicy(appCookieStickinessPolicy);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.AvailabilityZones`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-availabilityzones
         * @param availabilityZones `AWS::ElasticLoadBalancing::LoadBalancer.AvailabilityZones`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(final java.util.List<java.lang.String> availabilityZones) {
            this.props.availabilityZones(availabilityZones);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectiondrainingpolicy
         * @param connectionDrainingPolicy `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionDrainingPolicy(final software.amazon.awscdk.core.IResolvable connectionDrainingPolicy) {
            this.props.connectionDrainingPolicy(connectionDrainingPolicy);
            return this;
        }
        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectiondrainingpolicy
         * @param connectionDrainingPolicy `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionDrainingPolicy(final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.ConnectionDrainingPolicyProperty connectionDrainingPolicy) {
            this.props.connectionDrainingPolicy(connectionDrainingPolicy);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectionsettings
         * @param connectionSettings `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionSettings(final software.amazon.awscdk.core.IResolvable connectionSettings) {
            this.props.connectionSettings(connectionSettings);
            return this;
        }
        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectionsettings
         * @param connectionSettings `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionSettings(final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.ConnectionSettingsProperty connectionSettings) {
            this.props.connectionSettings(connectionSettings);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-crosszone
         * @param crossZone `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossZone(final java.lang.Boolean crossZone) {
            this.props.crossZone(crossZone);
            return this;
        }
        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-crosszone
         * @param crossZone `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossZone(final software.amazon.awscdk.core.IResolvable crossZone) {
            this.props.crossZone(crossZone);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-healthcheck
         * @param healthCheck `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(final software.amazon.awscdk.core.IResolvable healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }
        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-healthcheck
         * @param healthCheck `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.HealthCheckProperty healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.Instances`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-instances
         * @param instances `AWS::ElasticLoadBalancing::LoadBalancer.Instances`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instances(final java.util.List<java.lang.String> instances) {
            this.props.instances(instances);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-lbcookiestickinesspolicy
         * @param lbCookieStickinessPolicy `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lbCookieStickinessPolicy(final software.amazon.awscdk.core.IResolvable lbCookieStickinessPolicy) {
            this.props.lbCookieStickinessPolicy(lbCookieStickinessPolicy);
            return this;
        }
        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-lbcookiestickinesspolicy
         * @param lbCookieStickinessPolicy `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lbCookieStickinessPolicy(final java.util.List<java.lang.Object> lbCookieStickinessPolicy) {
            this.props.lbCookieStickinessPolicy(lbCookieStickinessPolicy);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.LoadBalancerName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-elbname
         * @param loadBalancerName `AWS::ElasticLoadBalancing::LoadBalancer.LoadBalancerName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(final java.lang.String loadBalancerName) {
            this.props.loadBalancerName(loadBalancerName);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.Policies`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-policies
         * @param policies `AWS::ElasticLoadBalancing::LoadBalancer.Policies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final software.amazon.awscdk.core.IResolvable policies) {
            this.props.policies(policies);
            return this;
        }
        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.Policies`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-policies
         * @param policies `AWS::ElasticLoadBalancing::LoadBalancer.Policies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final java.util.List<java.lang.Object> policies) {
            this.props.policies(policies);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.Scheme`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-scheme
         * @param scheme `AWS::ElasticLoadBalancing::LoadBalancer.Scheme`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheme(final java.lang.String scheme) {
            this.props.scheme(scheme);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.SecurityGroups`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-securitygroups
         * @param securityGroups `AWS::ElasticLoadBalancing::LoadBalancer.SecurityGroups`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<java.lang.String> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.Subnets`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-subnets
         * @param subnets `AWS::ElasticLoadBalancing::LoadBalancer.Subnets`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(final java.util.List<java.lang.String> subnets) {
            this.props.subnets(subnets);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancing::LoadBalancer.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-elasticloadbalancing-loadbalancer-tags
         * @param tags `AWS::ElasticLoadBalancing::LoadBalancer.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer build() {
            return new software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
