package software.amazon.awscdk.services.elasticloadbalancing;

/**
 * A load balancer with a single listener.
 * <p>
 * Routes to a fleet of of instances in a VPC.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-28T21:12:28.527Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.LoadBalancer")
public class LoadBalancer extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ec2.IConnectable {

    protected LoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LoadBalancer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a backend to the load balancer.
     * <p>
     * @return A ListenerPort object that controls connections to the listener port
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.ListenerPort addListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener listener) {
        return this.jsiiCall("addListener", software.amazon.awscdk.services.elasticloadbalancing.ListenerPort.class, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget target) {
        this.jsiiCall("addTarget", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Control all connections from and to this load balancer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     * An object controlling specifically the connections for each listener added to this load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ListenerPort> getListenerPorts() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("listenerPorts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancing.ListenerPort.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerCanonicalHostedZoneName() {
        return this.jsiiGet("loadBalancerCanonicalHostedZoneName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerCanonicalHostedZoneNameId() {
        return this.jsiiGet("loadBalancerCanonicalHostedZoneNameId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerDnsName() {
        return this.jsiiGet("loadBalancerDnsName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerName() {
        return this.jsiiGet("loadBalancerName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerSourceSecurityGroupGroupName() {
        return this.jsiiGet("loadBalancerSourceSecurityGroupGroupName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerSourceSecurityGroupOwnerAlias() {
        return this.jsiiGet("loadBalancerSourceSecurityGroupOwnerAlias", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerProps.Builder();
        }

        /**
         * VPC network of the fleet instances.
         * <p>
         * @return {@code this}
         * @param vpc VPC network of the fleet instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Whether cross zone load balancing is enabled.
         * <p>
         * This controls whether the load balancer evenly distributes requests
         * across each availability zone
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param crossZone Whether cross zone load balancing is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossZone(final java.lang.Boolean crossZone) {
            this.props.crossZone(crossZone);
            return this;
        }

        /**
         * Health check settings for the load balancing targets.
         * <p>
         * Not required but recommended.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param healthCheck Health check settings for the load balancing targets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(final software.amazon.awscdk.services.elasticloadbalancing.HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        /**
         * Whether this is an internet-facing Load Balancer.
         * <p>
         * This controls whether the LB has a public IP address assigned. It does
         * not open up the Load Balancer's security groups to public internet access.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param internetFacing Whether this is an internet-facing Load Balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetFacing(final java.lang.Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        /**
         * What listeners to set up for the load balancer.
         * <p>
         * Can also be added by .addListener()
         * <p>
         * Default: -
         * <p>
         * @return {@code this}
         * @param listeners What listeners to set up for the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listeners(final java.util.List<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener> listeners) {
            this.props.listeners(listeners);
            return this;
        }

        /**
         * Which subnets to deploy the load balancer.
         * <p>
         * Can be used to define a specific set of subnets to deploy the load balancer to.
         * Useful multiple public or private subnets are covering the same availability zone.
         * <p>
         * Default: - Public subnets if internetFacing, Private subnets otherwise
         * <p>
         * @return {@code this}
         * @param subnetSelection Which subnets to deploy the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * What targets to load balance to.
         * <p>
         * Can also be added by .addTarget()
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param targets What targets to load balance to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget> targets) {
            this.props.targets(targets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer build() {
            return new software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
