package software.amazon.awscdk.services.elasticloadbalancingv2.actions;

/**
 * Properties for AuthenticateCognitoAction.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-28T21:12:39.686Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.actions.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2-actions.AuthenticateCognitoActionProps")
@software.amazon.jsii.Jsii.Proxy(AuthenticateCognitoActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AuthenticateCognitoActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * What action to execute next.
     * <p>
     * Multiple actions form a linked chain; the chain must always terminate in a
     * (weighted)forward, fixedResponse or redirect action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction getNext();

    /**
     * The Amazon Cognito user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool getUserPool();

    /**
     * The Amazon Cognito user pool client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPoolClient getUserPoolClient();

    /**
     * The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPoolDomain getUserPoolDomain();

    /**
     * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
     * <p>
     * Default: - No extra parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getAuthenticationRequestExtraParams() {
        return null;
    }

    /**
     * The behavior if the user is not authenticated.
     * <p>
     * Default: UnauthenticatedAction.AUTHENTICATE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction getOnUnauthenticatedRequest() {
        return null;
    }

    /**
     * The set of user claims to be requested from the IdP.
     * <p>
     * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
     * <p>
     * Default: "openid"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
        return null;
    }

    /**
     * The name of the cookie used to maintain session information.
     * <p>
     * Default: "AWSELBAuthSessionCookie"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSessionCookieName() {
        return null;
    }

    /**
     * The maximum duration of the authentication session.
     * <p>
     * Default: Duration.days(7)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getSessionTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AuthenticateCognitoActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AuthenticateCognitoActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AuthenticateCognitoActionProps> {
        private software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction next;
        private software.amazon.awscdk.services.cognito.IUserPool userPool;
        private software.amazon.awscdk.services.cognito.IUserPoolClient userPoolClient;
        private software.amazon.awscdk.services.cognito.IUserPoolDomain userPoolDomain;
        private java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams;
        private software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction onUnauthenticatedRequest;
        private java.lang.String scope;
        private java.lang.String sessionCookieName;
        private software.amazon.awscdk.core.Duration sessionTimeout;

        /**
         * Sets the value of {@link AuthenticateCognitoActionProps#getNext}
         * @param next What action to execute next. This parameter is required.
         *             Multiple actions form a linked chain; the chain must always terminate in a
         *             (weighted)forward, fixedResponse or redirect action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder next(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction next) {
            this.next = next;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateCognitoActionProps#getUserPool}
         * @param userPool The Amazon Cognito user pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.userPool = userPool;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateCognitoActionProps#getUserPoolClient}
         * @param userPoolClient The Amazon Cognito user pool client. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolClient(software.amazon.awscdk.services.cognito.IUserPoolClient userPoolClient) {
            this.userPoolClient = userPoolClient;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateCognitoActionProps#getUserPoolDomain}
         * @param userPoolDomain The domain prefix or fully-qualified domain name of the Amazon Cognito user pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolDomain(software.amazon.awscdk.services.cognito.IUserPoolDomain userPoolDomain) {
            this.userPoolDomain = userPoolDomain;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateCognitoActionProps#getAuthenticationRequestExtraParams}
         * @param authenticationRequestExtraParams The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationRequestExtraParams(java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = authenticationRequestExtraParams;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateCognitoActionProps#getOnUnauthenticatedRequest}
         * @param onUnauthenticatedRequest The behavior if the user is not authenticated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onUnauthenticatedRequest(software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateCognitoActionProps#getScope}
         * @param scope The set of user claims to be requested from the IdP.
         *              To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(java.lang.String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateCognitoActionProps#getSessionCookieName}
         * @param sessionCookieName The name of the cookie used to maintain session information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionCookieName(java.lang.String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateCognitoActionProps#getSessionTimeout}
         * @param sessionTimeout The maximum duration of the authentication session.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionTimeout(software.amazon.awscdk.core.Duration sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AuthenticateCognitoActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AuthenticateCognitoActionProps build() {
            return new Jsii$Proxy(next, userPool, userPoolClient, userPoolDomain, authenticationRequestExtraParams, onUnauthenticatedRequest, scope, sessionCookieName, sessionTimeout);
        }
    }

    /**
     * An implementation for {@link AuthenticateCognitoActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticateCognitoActionProps {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction next;
        private final software.amazon.awscdk.services.cognito.IUserPool userPool;
        private final software.amazon.awscdk.services.cognito.IUserPoolClient userPoolClient;
        private final software.amazon.awscdk.services.cognito.IUserPoolDomain userPoolDomain;
        private final java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction onUnauthenticatedRequest;
        private final java.lang.String scope;
        private final java.lang.String sessionCookieName;
        private final software.amazon.awscdk.core.Duration sessionTimeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.next = this.jsiiGet("next", software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class);
            this.userPool = this.jsiiGet("userPool", software.amazon.awscdk.services.cognito.IUserPool.class);
            this.userPoolClient = this.jsiiGet("userPoolClient", software.amazon.awscdk.services.cognito.IUserPoolClient.class);
            this.userPoolDomain = this.jsiiGet("userPoolDomain", software.amazon.awscdk.services.cognito.IUserPoolDomain.class);
            this.authenticationRequestExtraParams = this.jsiiGet("authenticationRequestExtraParams", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.onUnauthenticatedRequest = this.jsiiGet("onUnauthenticatedRequest", software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction.class);
            this.scope = this.jsiiGet("scope", java.lang.String.class);
            this.sessionCookieName = this.jsiiGet("sessionCookieName", java.lang.String.class);
            this.sessionTimeout = this.jsiiGet("sessionTimeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction next, final software.amazon.awscdk.services.cognito.IUserPool userPool, final software.amazon.awscdk.services.cognito.IUserPoolClient userPoolClient, final software.amazon.awscdk.services.cognito.IUserPoolDomain userPoolDomain, final java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams, final software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction onUnauthenticatedRequest, final java.lang.String scope, final java.lang.String sessionCookieName, final software.amazon.awscdk.core.Duration sessionTimeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.next = java.util.Objects.requireNonNull(next, "next is required");
            this.userPool = java.util.Objects.requireNonNull(userPool, "userPool is required");
            this.userPoolClient = java.util.Objects.requireNonNull(userPoolClient, "userPoolClient is required");
            this.userPoolDomain = java.util.Objects.requireNonNull(userPoolDomain, "userPoolDomain is required");
            this.authenticationRequestExtraParams = authenticationRequestExtraParams;
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
            this.scope = scope;
            this.sessionCookieName = sessionCookieName;
            this.sessionTimeout = sessionTimeout;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction getNext() {
            return this.next;
        }

        @Override
        public software.amazon.awscdk.services.cognito.IUserPool getUserPool() {
            return this.userPool;
        }

        @Override
        public software.amazon.awscdk.services.cognito.IUserPoolClient getUserPoolClient() {
            return this.userPoolClient;
        }

        @Override
        public software.amazon.awscdk.services.cognito.IUserPoolDomain getUserPoolDomain() {
            return this.userPoolDomain;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getAuthenticationRequestExtraParams() {
            return this.authenticationRequestExtraParams;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction getOnUnauthenticatedRequest() {
            return this.onUnauthenticatedRequest;
        }

        @Override
        public java.lang.String getScope() {
            return this.scope;
        }

        @Override
        public java.lang.String getSessionCookieName() {
            return this.sessionCookieName;
        }

        @Override
        public software.amazon.awscdk.core.Duration getSessionTimeout() {
            return this.sessionTimeout;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("next", om.valueToTree(this.getNext()));
            data.set("userPool", om.valueToTree(this.getUserPool()));
            data.set("userPoolClient", om.valueToTree(this.getUserPoolClient()));
            data.set("userPoolDomain", om.valueToTree(this.getUserPoolDomain()));
            if (this.getAuthenticationRequestExtraParams() != null) {
                data.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
            }
            if (this.getOnUnauthenticatedRequest() != null) {
                data.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
            }
            if (this.getScope() != null) {
                data.set("scope", om.valueToTree(this.getScope()));
            }
            if (this.getSessionCookieName() != null) {
                data.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
            }
            if (this.getSessionTimeout() != null) {
                data.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2-actions.AuthenticateCognitoActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AuthenticateCognitoActionProps.Jsii$Proxy that = (AuthenticateCognitoActionProps.Jsii$Proxy) o;

            if (!next.equals(that.next)) return false;
            if (!userPool.equals(that.userPool)) return false;
            if (!userPoolClient.equals(that.userPoolClient)) return false;
            if (!userPoolDomain.equals(that.userPoolDomain)) return false;
            if (this.authenticationRequestExtraParams != null ? !this.authenticationRequestExtraParams.equals(that.authenticationRequestExtraParams) : that.authenticationRequestExtraParams != null) return false;
            if (this.onUnauthenticatedRequest != null ? !this.onUnauthenticatedRequest.equals(that.onUnauthenticatedRequest) : that.onUnauthenticatedRequest != null) return false;
            if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
            if (this.sessionCookieName != null ? !this.sessionCookieName.equals(that.sessionCookieName) : that.sessionCookieName != null) return false;
            return this.sessionTimeout != null ? this.sessionTimeout.equals(that.sessionTimeout) : that.sessionTimeout == null;
        }

        @Override
        public int hashCode() {
            int result = this.next.hashCode();
            result = 31 * result + (this.userPool.hashCode());
            result = 31 * result + (this.userPoolClient.hashCode());
            result = 31 * result + (this.userPoolDomain.hashCode());
            result = 31 * result + (this.authenticationRequestExtraParams != null ? this.authenticationRequestExtraParams.hashCode() : 0);
            result = 31 * result + (this.onUnauthenticatedRequest != null ? this.onUnauthenticatedRequest.hashCode() : 0);
            result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
            result = 31 * result + (this.sessionCookieName != null ? this.sessionCookieName.hashCode() : 0);
            result = 31 * result + (this.sessionTimeout != null ? this.sessionTimeout.hashCode() : 0);
            return result;
        }
    }
}
