/**
 * <h1>Actions for AWS Elastic Load Balancing V2</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This package contains integration actions for ELBv2. See the README of the <code>&#64;aws-cdk/aws-elasticloadbalancingv2</code> library.
 * <p>
 * <h2>Cognito</h2>
 * <p>
 * ELB allows for requests to be authenticated against a Cognito user pool using
 * the <code>AuthenticateCognitoAction</code>. For details on the setup's requirements,
 * read <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/listener-authenticate-users.html#cognito-requirements">Prepare to use Amazon
 * Cognito</a>.
 * Here's an example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.cognito.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * import software.amazon.awscdk.core.App;
 * import software.amazon.awscdk.core.CfnOutput;
 * import software.amazon.awscdk.core.Construct;
 * import software.amazon.awscdk.core.Stack;
 * import lib.*;CognitoStack extends Stack {CognitoStack(
 * 
 * ApplicationLoadBalancer lb = new ApplicationLoadBalancer(this, "LB", new ApplicationLoadBalancerProps()
 *         .vpc(vpc)
 *         .internetFacing(true));
 * 
 * UserPool userPool = new UserPool(this, "UserPool");
 * UserPoolClient userPoolClient = new UserPoolClient(this, "Client", new UserPoolClientProps()
 *         .userPool(userPool)
 * 
 *         // Required minimal configuration for use with an ELB
 *         .generateSecret(true)
 *         .authFlows(new AuthFlow()
 *                 .userPassword(true)
 *                 .refreshToken(true))
 *         .oAuth(new OAuthSettings()
 *                 .flows(new OAuthFlows()
 *                         .authorizationCodeGrant(true))
 *                 .scopes(asList(cognito.OAuthScope.getEMAIL()))
 *                 .callbackUrls(asList("https://" + lb.loadBalancerDnsName + "/oauth2/idpresponse"))));
 * CfnUserPoolClient cfnClient = (CfnUserPoolClient)userPoolClient.node.getDefaultChild();
 * cfnClient.addPropertyOverride("RefreshTokenValidity", 1);
 * cfnClient.addPropertyOverride("SupportedIdentityProviders", asList("COGNITO"));
 * 
 * UserPoolDomain userPoolDomain = new UserPoolDomain(this, "Domain", new UserPoolDomainProps()
 *         .userPool(userPool)
 *         .cognitoDomain(new CognitoDomainOptions()
 *                 .domainPrefix("test-cdk-prefix")));
 * 
 * lb.addListener("Listener", new BaseApplicationListenerProps()
 *         .port(443)
 *         .certificates(asList(certificate))
 *         .defaultAction(new AuthenticateCognitoAction(new AuthenticateCognitoActionProps()
 *                 .userPool(userPool)
 *                 .userPoolClient(userPoolClient)
 *                 .userPoolDomain(userPoolDomain)
 *                 .next(elbv2.ListenerAction.fixedResponse(200, new FixedResponseOptions()
 *                         .contentType("text/plain")
 *                         .messageBody("Authenticated"))))));
 * 
 * new CfnOutput(this, "DNS", new CfnOutputProps()
 *         .value(lb.getLoadBalancerDnsName()));
 * 
 * App app = new App();
 * new CognitoStack(app, "integ-cognito");
 * app.synth();
 * </pre></blockquote>
 * <p>
 * <blockquote>
 * <p>
 * NOTE: this example seems incomplete, I was not able to get the redirect back to the
 * Load Balancer after authentication working. Would love some pointers on what a full working
 * setup actually looks like!
 * <p>
 * </blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.elasticloadbalancingv2.actions;
