package software.amazon.awscdk.services.lambda.codepipeline;
/**
 * Construction properties of the {@link PipelineInvokeAction Lambda invoke CodePipeline Action}.
 */
public interface PipelineInvokeActionProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The lambda function to invoke.
     */
    software.amazon.awscdk.services.lambda.LambdaRef getLambda();
    /**
     * The lambda function to invoke.
     */
    void setLambda(final software.amazon.awscdk.services.lambda.LambdaRef value);
    /**
     * String to be used in the event data parameter passed to the Lambda
     * function
     * 
     * See an example JSON event in the CodePipeline documentation.
     * 
     * https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
     */
    java.lang.Object getUserParameters();
    /**
     * String to be used in the event data parameter passed to the Lambda
     * function
     * 
     * See an example JSON event in the CodePipeline documentation.
     * 
     * https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
     */
    void setUserParameters(final java.lang.Object value);
    /**
     * Adds the "codepipeline:PutJobSuccessResult" and
     * "codepipeline:PutJobFailureResult" for '*' resource to the Lambda
     * execution role policy.
     * 
     * NOTE: the reason we can't add the specific pipeline ARN as a resource is
     * to avoid a cyclic dependency between the pipeline and the Lambda function
     * (the pipeline references) the Lambda and the Lambda needs permissions on
     * the pipeline.
     * @default true
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-create-function
     */
    java.lang.Boolean getAddPutJobResultPolicy();
    /**
     * Adds the "codepipeline:PutJobSuccessResult" and
     * "codepipeline:PutJobFailureResult" for '*' resource to the Lambda
     * execution role policy.
     * 
     * NOTE: the reason we can't add the specific pipeline ARN as a resource is
     * to avoid a cyclic dependency between the pipeline and the Lambda function
     * (the pipeline references) the Lambda and the Lambda needs permissions on
     * the pipeline.
     * @default true
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-create-function
     */
    void setAddPutJobResultPolicy(final java.lang.Boolean value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link PipelineInvokeActionProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The lambda function to invoke.
         */
        public Build withLambda(final software.amazon.awscdk.services.lambda.LambdaRef value) {
            return new FullBuilder().withLambda(value);
        }

        public interface Build {
            /**
             * @return a new {@link PipelineInvokeActionProps} object, initialized with the values set on this builder.
             */
            PipelineInvokeActionProps build();
            /**
             * String to be used in the event data parameter passed to the Lambda
             * function
             * 
             * See an example JSON event in the CodePipeline documentation.
             * 
             * https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
             */
            Build withUserParameters(final java.lang.Object value);
            /**
             * Adds the "codepipeline:PutJobSuccessResult" and
             * "codepipeline:PutJobFailureResult" for '*' resource to the Lambda
             * execution role policy.
             * 
             * NOTE: the reason we can't add the specific pipeline ARN as a resource is
             * to avoid a cyclic dependency between the pipeline and the Lambda function
             * (the pipeline references) the Lambda and the Lambda needs permissions on
             * the pipeline.
             * @default true
             * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-create-function
             */
            Build withAddPutJobResultPolicy(final java.lang.Boolean value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The lambda function to invoke.
             */
            public Build withLambda(final software.amazon.awscdk.services.lambda.LambdaRef value) {
                java.util.Objects.requireNonNull(value, "PipelineInvokeActionProps#lambda is required");
                this.instance._lambda = value;
                return this;
            }
            /**
             * String to be used in the event data parameter passed to the Lambda
             * function
             * 
             * See an example JSON event in the CodePipeline documentation.
             * 
             * https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
             */
            public Build withUserParameters(final java.lang.Object value) {
                this.instance._userParameters = value;
                return this;
            }
            /**
             * Adds the "codepipeline:PutJobSuccessResult" and
             * "codepipeline:PutJobFailureResult" for '*' resource to the Lambda
             * execution role policy.
             * 
             * NOTE: the reason we can't add the specific pipeline ARN as a resource is
             * to avoid a cyclic dependency between the pipeline and the Lambda function
             * (the pipeline references) the Lambda and the Lambda needs permissions on
             * the pipeline.
             * @default true
             * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-create-function
             */
            public Build withAddPutJobResultPolicy(final java.lang.Boolean value) {
                this.instance._addPutJobResultPolicy = value;
                return this;
            }
            public PipelineInvokeActionProps build() {
                PipelineInvokeActionProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link PipelineInvokeActionProps}.
     */
    final class Jsii$Pojo implements PipelineInvokeActionProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.lambda.LambdaRef _lambda;

        public software.amazon.awscdk.services.lambda.LambdaRef getLambda() {
            return this._lambda;
        }
        public void setLambda(final software.amazon.awscdk.services.lambda.LambdaRef value) {
            this._lambda = value;
        }

        protected java.lang.Object _userParameters;

        public java.lang.Object getUserParameters() {
            return this._userParameters;
        }
        public void setUserParameters(final java.lang.Object value) {
            this._userParameters = value;
        }

        protected java.lang.Boolean _addPutJobResultPolicy;

        public java.lang.Boolean getAddPutJobResultPolicy() {
            return this._addPutJobResultPolicy;
        }
        public void setAddPutJobResultPolicy(final java.lang.Boolean value) {
            this._addPutJobResultPolicy = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.codepipeline.PipelineInvokeActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The lambda function to invoke.
         */
        public software.amazon.awscdk.services.lambda.LambdaRef getLambda() {
            return this.jsiiGet("lambda", software.amazon.awscdk.services.lambda.LambdaRef.class);
        }
        /**
         * The lambda function to invoke.
         */
        public void setLambda(final software.amazon.awscdk.services.lambda.LambdaRef value) {
            this.jsiiSet("lambda", java.util.Objects.requireNonNull(value, "lambda is required"));
        }
        /**
         * String to be used in the event data parameter passed to the Lambda
         * function
         * 
         * See an example JSON event in the CodePipeline documentation.
         * 
         * https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
         */
        @javax.annotation.Nullable
        public java.lang.Object getUserParameters() {
            return this.jsiiGet("userParameters", java.lang.Object.class);
        }
        /**
         * String to be used in the event data parameter passed to the Lambda
         * function
         * 
         * See an example JSON event in the CodePipeline documentation.
         * 
         * https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
         */
        public void setUserParameters(@javax.annotation.Nullable final java.lang.Object value) {
            this.jsiiSet("userParameters", value);
        }
        /**
         * Adds the "codepipeline:PutJobSuccessResult" and
         * "codepipeline:PutJobFailureResult" for '*' resource to the Lambda
         * execution role policy.
         * 
         * NOTE: the reason we can't add the specific pipeline ARN as a resource is
         * to avoid a cyclic dependency between the pipeline and the Lambda function
         * (the pipeline references) the Lambda and the Lambda needs permissions on
         * the pipeline.
         * @default true
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-create-function
         */
        @javax.annotation.Nullable
        public java.lang.Boolean getAddPutJobResultPolicy() {
            return this.jsiiGet("addPutJobResultPolicy", java.lang.Boolean.class);
        }
        /**
         * Adds the "codepipeline:PutJobSuccessResult" and
         * "codepipeline:PutJobFailureResult" for '*' resource to the Lambda
         * execution role policy.
         * 
         * NOTE: the reason we can't add the specific pipeline ARN as a resource is
         * to avoid a cyclic dependency between the pipeline and the Lambda function
         * (the pipeline references) the Lambda and the Lambda needs permissions on
         * the pipeline.
         * @default true
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-create-function
         */
        public void setAddPutJobResultPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("addPutJobResultPolicy", value);
        }
    }
}
