package software.amazon.awscdk.services.lambda.go;

/**
 * (experimental) Bundling options.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.39.0 (build 8af72c2)", date = "2021-10-14T05:49:04.106Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.go.$Module.class, fqn = "@aws-cdk/aws-lambda-go.BundlingOptions")
@software.amazon.jsii.Jsii.Proxy(BundlingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BundlingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Specify a custom hash for this asset.
     * <p>
     * If <code>assetHashType</code> is set it must
     * be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
     * be SHA256 hashed and encoded as hex. The resulting hash will be the asset
     * hash.
     * <p>
     * NOTE: the hash is used in order to identify a specific revision of the asset, and
     * used for optimizing and caching deployment activities related to this asset such as
     * packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
     * need to make sure it is updated every time the asset changes, or otherwise it is
     * possible that some deployments will not be invalidated.
     * <p>
     * Default: - based on `assetHashType`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssetHash() {
        return null;
    }

    /**
     * (experimental) Determines how the asset hash is calculated. Assets will get rebuilt and uploaded only if their hash has changed.
     * <p>
     * If the asset hash is set to <code>OUTPUT</code> (default), the hash is calculated
     * after bundling. This means that any change in the output will cause
     * the asset to be invalidated and uploaded. Bear in mind that the
     * go binary that is output can be different depending on the environment
     * that it was compiled in. If you want to control when the output is changed
     * it is recommended that you use immutable build images such as
     * <code>public.ecr.aws/bitnami/golang:1.16.3-debian-10-r16</code>.
     * <p>
     * If the asset hash is set to <code>SOURCE</code>, then only changes to the source
     * directory will cause the asset to rebuild. If your go project has multiple
     * Lambda functions this means that an update to any one function could cause
     * all the functions to be rebuilt and uploaded.
     * <p>
     * Default: - AssetHashType.OUTPUT. If `assetHash` is also specified,
     * the default is `CUSTOM`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.AssetHashType getAssetHashType() {
        return null;
    }

    /**
     * (experimental) Build arguments to pass when building the bundling image.
     * <p>
     * Default: - no build arguments are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
        return null;
    }

    /**
     * (experimental) Whether or not to enable cgo during go build.
     * <p>
     * This will set the CGO_ENABLED environment variable
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCgoEnabled() {
        return null;
    }

    /**
     * (experimental) Command hooks.
     * <p>
     * Default: - do not run additional commands
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.go.ICommandHooks getCommandHooks() {
        return null;
    }

    /**
     * (experimental) A custom bundling Docker image.
     * <p>
     * Default: - use the Docker image provided by
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.DockerImage getDockerImage() {
        return null;
    }

    /**
     * (experimental) Environment variables defined when go runs.
     * <p>
     * Default: - no environment variables are defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * (experimental) Force bundling in a Docker container even if local bundling is possible.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getForcedDockerBundling() {
        return null;
    }

    /**
     * (experimental) List of additional flags to use while building.
     * <p>
     * For example:
     * ['ldflags "-s -w"']
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGoBuildFlags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BundlingOptions> {
        private java.lang.String assetHash;
        private software.amazon.awscdk.core.AssetHashType assetHashType;
        private java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private java.lang.Boolean cgoEnabled;
        private software.amazon.awscdk.services.lambda.go.ICommandHooks commandHooks;
        private software.amazon.awscdk.core.DockerImage dockerImage;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private java.lang.Boolean forcedDockerBundling;
        private java.util.List<java.lang.String> goBuildFlags;

        /**
         * Sets the value of {@link BundlingOptions#getAssetHash}
         * @param assetHash Specify a custom hash for this asset.
         *                  If <code>assetHashType</code> is set it must
         *                  be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
         *                  be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         *                  hash.
         *                  <p>
         *                  NOTE: the hash is used in order to identify a specific revision of the asset, and
         *                  used for optimizing and caching deployment activities related to this asset such as
         *                  packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         *                  need to make sure it is updated every time the asset changes, or otherwise it is
         *                  possible that some deployments will not be invalidated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetHash(java.lang.String assetHash) {
            this.assetHash = assetHash;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getAssetHashType}
         * @param assetHashType Determines how the asset hash is calculated. Assets will get rebuilt and uploaded only if their hash has changed.
         *                      If the asset hash is set to <code>OUTPUT</code> (default), the hash is calculated
         *                      after bundling. This means that any change in the output will cause
         *                      the asset to be invalidated and uploaded. Bear in mind that the
         *                      go binary that is output can be different depending on the environment
         *                      that it was compiled in. If you want to control when the output is changed
         *                      it is recommended that you use immutable build images such as
         *                      <code>public.ecr.aws/bitnami/golang:1.16.3-debian-10-r16</code>.
         *                      <p>
         *                      If the asset hash is set to <code>SOURCE</code>, then only changes to the source
         *                      directory will cause the asset to rebuild. If your go project has multiple
         *                      Lambda functions this means that an update to any one function could cause
         *                      all the functions to be rebuilt and uploaded.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetHashType(software.amazon.awscdk.core.AssetHashType assetHashType) {
            this.assetHashType = assetHashType;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getBuildArgs}
         * @param buildArgs Build arguments to pass when building the bundling image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildArgs(java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getCgoEnabled}
         * @param cgoEnabled Whether or not to enable cgo during go build.
         *                   This will set the CGO_ENABLED environment variable
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cgoEnabled(java.lang.Boolean cgoEnabled) {
            this.cgoEnabled = cgoEnabled;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getCommandHooks}
         * @param commandHooks Command hooks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder commandHooks(software.amazon.awscdk.services.lambda.go.ICommandHooks commandHooks) {
            this.commandHooks = commandHooks;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getDockerImage}
         * @param dockerImage A custom bundling Docker image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dockerImage(software.amazon.awscdk.core.DockerImage dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEnvironment}
         * @param environment Environment variables defined when go runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getForcedDockerBundling}
         * @param forcedDockerBundling Force bundling in a Docker container even if local bundling is possible.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forcedDockerBundling(java.lang.Boolean forcedDockerBundling) {
            this.forcedDockerBundling = forcedDockerBundling;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getGoBuildFlags}
         * @param goBuildFlags List of additional flags to use while building.
         *                     For example:
         *                     ['ldflags "-s -w"']
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder goBuildFlags(java.util.List<java.lang.String> goBuildFlags) {
            this.goBuildFlags = goBuildFlags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BundlingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BundlingOptions build() {
            return new Jsii$Proxy(assetHash, assetHashType, buildArgs, cgoEnabled, commandHooks, dockerImage, environment, forcedDockerBundling, goBuildFlags);
        }
    }

    /**
     * An implementation for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BundlingOptions {
        private final java.lang.String assetHash;
        private final software.amazon.awscdk.core.AssetHashType assetHashType;
        private final java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private final java.lang.Boolean cgoEnabled;
        private final software.amazon.awscdk.services.lambda.go.ICommandHooks commandHooks;
        private final software.amazon.awscdk.core.DockerImage dockerImage;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.Boolean forcedDockerBundling;
        private final java.util.List<java.lang.String> goBuildFlags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assetHash = software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetHashType = software.amazon.jsii.Kernel.get(this, "assetHashType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.AssetHashType.class));
            this.buildArgs = software.amazon.jsii.Kernel.get(this, "buildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cgoEnabled = software.amazon.jsii.Kernel.get(this, "cgoEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.commandHooks = software.amazon.jsii.Kernel.get(this, "commandHooks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.go.ICommandHooks.class));
            this.dockerImage = software.amazon.jsii.Kernel.get(this, "dockerImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.DockerImage.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.forcedDockerBundling = software.amazon.jsii.Kernel.get(this, "forcedDockerBundling", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.goBuildFlags = software.amazon.jsii.Kernel.get(this, "goBuildFlags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String assetHash, final software.amazon.awscdk.core.AssetHashType assetHashType, final java.util.Map<java.lang.String, java.lang.String> buildArgs, final java.lang.Boolean cgoEnabled, final software.amazon.awscdk.services.lambda.go.ICommandHooks commandHooks, final software.amazon.awscdk.core.DockerImage dockerImage, final java.util.Map<java.lang.String, java.lang.String> environment, final java.lang.Boolean forcedDockerBundling, final java.util.List<java.lang.String> goBuildFlags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assetHash = assetHash;
            this.assetHashType = assetHashType;
            this.buildArgs = buildArgs;
            this.cgoEnabled = cgoEnabled;
            this.commandHooks = commandHooks;
            this.dockerImage = dockerImage;
            this.environment = environment;
            this.forcedDockerBundling = forcedDockerBundling;
            this.goBuildFlags = goBuildFlags;
        }

        @Override
        public final java.lang.String getAssetHash() {
            return this.assetHash;
        }

        @Override
        public final software.amazon.awscdk.core.AssetHashType getAssetHashType() {
            return this.assetHashType;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
            return this.buildArgs;
        }

        @Override
        public final java.lang.Boolean getCgoEnabled() {
            return this.cgoEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.go.ICommandHooks getCommandHooks() {
            return this.commandHooks;
        }

        @Override
        public final software.amazon.awscdk.core.DockerImage getDockerImage() {
            return this.dockerImage;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.Boolean getForcedDockerBundling() {
            return this.forcedDockerBundling;
        }

        @Override
        public final java.util.List<java.lang.String> getGoBuildFlags() {
            return this.goBuildFlags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssetHash() != null) {
                data.set("assetHash", om.valueToTree(this.getAssetHash()));
            }
            if (this.getAssetHashType() != null) {
                data.set("assetHashType", om.valueToTree(this.getAssetHashType()));
            }
            if (this.getBuildArgs() != null) {
                data.set("buildArgs", om.valueToTree(this.getBuildArgs()));
            }
            if (this.getCgoEnabled() != null) {
                data.set("cgoEnabled", om.valueToTree(this.getCgoEnabled()));
            }
            if (this.getCommandHooks() != null) {
                data.set("commandHooks", om.valueToTree(this.getCommandHooks()));
            }
            if (this.getDockerImage() != null) {
                data.set("dockerImage", om.valueToTree(this.getDockerImage()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getForcedDockerBundling() != null) {
                data.set("forcedDockerBundling", om.valueToTree(this.getForcedDockerBundling()));
            }
            if (this.getGoBuildFlags() != null) {
                data.set("goBuildFlags", om.valueToTree(this.getGoBuildFlags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda-go.BundlingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BundlingOptions.Jsii$Proxy that = (BundlingOptions.Jsii$Proxy) o;

            if (this.assetHash != null ? !this.assetHash.equals(that.assetHash) : that.assetHash != null) return false;
            if (this.assetHashType != null ? !this.assetHashType.equals(that.assetHashType) : that.assetHashType != null) return false;
            if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) return false;
            if (this.cgoEnabled != null ? !this.cgoEnabled.equals(that.cgoEnabled) : that.cgoEnabled != null) return false;
            if (this.commandHooks != null ? !this.commandHooks.equals(that.commandHooks) : that.commandHooks != null) return false;
            if (this.dockerImage != null ? !this.dockerImage.equals(that.dockerImage) : that.dockerImage != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.forcedDockerBundling != null ? !this.forcedDockerBundling.equals(that.forcedDockerBundling) : that.forcedDockerBundling != null) return false;
            return this.goBuildFlags != null ? this.goBuildFlags.equals(that.goBuildFlags) : that.goBuildFlags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assetHash != null ? this.assetHash.hashCode() : 0;
            result = 31 * result + (this.assetHashType != null ? this.assetHashType.hashCode() : 0);
            result = 31 * result + (this.buildArgs != null ? this.buildArgs.hashCode() : 0);
            result = 31 * result + (this.cgoEnabled != null ? this.cgoEnabled.hashCode() : 0);
            result = 31 * result + (this.commandHooks != null ? this.commandHooks.hashCode() : 0);
            result = 31 * result + (this.dockerImage != null ? this.dockerImage.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.forcedDockerBundling != null ? this.forcedDockerBundling.hashCode() : 0);
            result = 31 * result + (this.goBuildFlags != null ? this.goBuildFlags.hashCode() : 0);
            return result;
        }
    }
}
