package software.amazon.awscdk.services.lambda.nodejs;

/**
 * SourceMap mode for esbuild.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * NodejsFunction.Builder.create(this, "my-handler")
 *         .bundling(BundlingOptions.builder()
 *                 .minify(true) // minify code, defaults to false
 *                 .sourceMap(true) // include source map, defaults to false
 *                 .sourceMapMode(SourceMapMode.INLINE) // defaults to SourceMapMode.DEFAULT
 *                 .sourcesContent(false) // do not include original source into source map, defaults to true
 *                 .target("es2020") // target environment for the generated JavaScript code
 *                 .loader(Map.of( // Use the 'dataurl' loader for '.png' files
 *                         ".png", "dataurl"))
 *                 .define(Map.of( // Replace strings during build time
 *                         "process.env.API_KEY", JSON.stringify("xxx-xxxx-xxx"),
 *                         "process.env.PRODUCTION", JSON.stringify(true),
 *                         "process.env.NUMBER", JSON.stringify(123)))
 *                 .logLevel(LogLevel.SILENT) // defaults to LogLevel.WARNING
 *                 .keepNames(true) // defaults to false
 *                 .tsconfig("custom-tsconfig.json") // use custom-tsconfig.json instead of default,
 *                 .metafile(true) // include meta file, defaults to false
 *                 .banner("/* comments *&#47;") // requires esbuild &gt;= 0.9.0, defaults to none
 *                 .footer("/* comments *&#47;") // requires esbuild &gt;= 0.9.0, defaults to none
 *                 .charset(Charset.UTF8) // do not escape non-ASCII characters, defaults to Charset.ASCII
 *                 .format(OutputFormat.ESM) // ECMAScript module output format, defaults to OutputFormat.CJS (OutputFormat.ESM requires Node.js 14.x)
 *                 .mainFields(List.of("module", "main"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see https://esbuild.github.io/api/#sourcemap
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-01T02:29:02.580Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.nodejs.$Module.class, fqn = "@aws-cdk/aws-lambda-nodejs.SourceMapMode")
public enum SourceMapMode {
    /**
     * Default sourceMap mode - will generate a .js.map file alongside any generated .js file and add a special //# sourceMappingURL= comment to the bottom of the .js file pointing to the .js.map file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEFAULT,
    /**
     * External sourceMap mode - If you want to omit the special //# sourceMappingURL= comment from the generated .js file but you still want to generate the .js.map files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXTERNAL,
    /**
     * Inline sourceMap mode - If you want to insert the entire source map into the .js file instead of generating a separate .js.map file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INLINE,
    /**
     * Both sourceMap mode - If you want to have the effect of both inline and external simultaneously.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOTH,
}
