package software.amazon.awscdk.services.lambda.nodejs;

/**
 * Log levels for esbuild and package managers' install commands.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * NodejsFunction.Builder.create(this, "my-handler")
 *         .bundling(BundlingOptions.builder()
 *                 .minify(true) // minify code, defaults to false
 *                 .sourceMap(true) // include source map, defaults to false
 *                 .sourceMapMode(SourceMapMode.INLINE) // defaults to SourceMapMode.DEFAULT
 *                 .sourcesContent(false) // do not include original source into source map, defaults to true
 *                 .target("es2020") // target environment for the generated JavaScript code
 *                 .loader(Map.of( // Use the 'dataurl' loader for '.png' files
 *                         ".png", "dataurl"))
 *                 .define(Map.of( // Replace strings during build time
 *                         "process.env.API_KEY", JSON.stringify("xxx-xxxx-xxx"),
 *                         "process.env.PRODUCTION", JSON.stringify(true),
 *                         "process.env.NUMBER", JSON.stringify(123)))
 *                 .logLevel(LogLevel.SILENT) // defaults to LogLevel.WARNING
 *                 .keepNames(true) // defaults to false
 *                 .tsconfig("custom-tsconfig.json") // use custom-tsconfig.json instead of default,
 *                 .metafile(true) // include meta file, defaults to false
 *                 .banner("/* comments *&#47;") // requires esbuild &gt;= 0.9.0, defaults to none
 *                 .footer("/* comments *&#47;") // requires esbuild &gt;= 0.9.0, defaults to none
 *                 .charset(Charset.UTF8) // do not escape non-ASCII characters, defaults to Charset.ASCII
 *                 .format(OutputFormat.ESM) // ECMAScript module output format, defaults to OutputFormat.CJS (OutputFormat.ESM requires Node.js 14.x)
 *                 .mainFields(List.of("module", "main")) // prefer ECMAScript versions of dependencies
 *                 .inject(List.of("./my-shim.js", "./other-shim.js")) // allows to automatically replace a global variable with an import from another file
 *                 .esbuildArgs(Map.of( // Pass additional arguments to esbuild
 *                         "--log-limit", "0",
 *                         "--splitting", true))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-22T09:25:21.077Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.nodejs.$Module.class, fqn = "@aws-cdk/aws-lambda-nodejs.LogLevel")
public enum LogLevel {
    /**
     * Show everything.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFO,
    /**
     * Show warnings and errors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WARNING,
    /**
     * Show errors only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ERROR,
    /**
     * Show nothing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SILENT,
}
