package software.amazon.awscdk.services.lambda.nodejs;

/**
 * SourceMap mode for esbuild.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * NodejsFunction.Builder.create(this, "my-handler")
 *         .bundling(BundlingOptions.builder()
 *                 .minify(true) // minify code, defaults to false
 *                 .sourceMap(true) // include source map, defaults to false
 *                 .sourceMapMode(SourceMapMode.INLINE) // defaults to SourceMapMode.DEFAULT
 *                 .sourcesContent(false) // do not include original source into source map, defaults to true
 *                 .target("es2020") // target environment for the generated JavaScript code
 *                 .loader(Map.of( // Use the 'dataurl' loader for '.png' files
 *                         ".png", "dataurl"))
 *                 .define(Map.of( // Replace strings during build time
 *                         "process.env.API_KEY", JSON.stringify("xxx-xxxx-xxx"),
 *                         "process.env.PRODUCTION", JSON.stringify(true),
 *                         "process.env.NUMBER", JSON.stringify(123)))
 *                 .logLevel(LogLevel.SILENT) // defaults to LogLevel.WARNING
 *                 .keepNames(true) // defaults to false
 *                 .tsconfig("custom-tsconfig.json") // use custom-tsconfig.json instead of default,
 *                 .metafile(true) // include meta file, defaults to false
 *                 .banner("/* comments *&#47;") // requires esbuild &gt;= 0.9.0, defaults to none
 *                 .footer("/* comments *&#47;") // requires esbuild &gt;= 0.9.0, defaults to none
 *                 .charset(Charset.UTF8) // do not escape non-ASCII characters, defaults to Charset.ASCII
 *                 .format(OutputFormat.ESM) // ECMAScript module output format, defaults to OutputFormat.CJS (OutputFormat.ESM requires Node.js 14.x)
 *                 .mainFields(List.of("module", "main")) // prefer ECMAScript versions of dependencies
 *                 .inject(List.of("./my-shim.js", "./other-shim.js")) // allows to automatically replace a global variable with an import from another file
 *                 .esbuildArgs(Map.of( // Pass additional arguments to esbuild
 *                         "--log-limit", "0",
 *                         "--splitting", true))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://esbuild.github.io/api/#sourcemap">https://esbuild.github.io/api/#sourcemap</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.66.0 (build 3c9512b)", date = "2022-08-31T20:25:14.899Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.nodejs.$Module.class, fqn = "@aws-cdk/aws-lambda-nodejs.SourceMapMode")
public enum SourceMapMode {
    /**
     * Default sourceMap mode - will generate a .js.map file alongside any generated .js file and add a special //# sourceMappingURL= comment to the bottom of the .js file pointing to the .js.map file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEFAULT,
    /**
     * External sourceMap mode - If you want to omit the special //# sourceMappingURL= comment from the generated .js file but you still want to generate the .js.map files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXTERNAL,
    /**
     * Inline sourceMap mode - If you want to insert the entire source map into the .js file instead of generating a separate .js.map file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INLINE,
    /**
     * Both sourceMap mode - If you want to have the effect of both inline and external simultaneously.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOTH,
}
