package software.amazon.awscdk.services.lambda.nodejs;

/**
 * Properties for a NodejsFunction.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.1.0 (build df55f5e)", date = "2020-04-07T12:30:33.534Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.nodejs.$Module.class, fqn = "@aws-cdk/aws-lambda-nodejs.NodejsFunctionProps")
@software.amazon.jsii.Jsii.Proxy(NodejsFunctionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface NodejsFunctionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.FunctionOptions {

    /**
     * The build directory.
     * <p>
     * Default: - `.build` in the entry file directory
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBuildDir() {
        return null;
    }

    /**
     * The cache directory.
     * <p>
     * Parcel uses a filesystem cache for fast rebuilds.
     * <p>
     * Default: - `.cache` in the root directory
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacheDir() {
        return null;
    }

    /**
     * Path to the entry file (JavaScript or TypeScript).
     * <p>
     * Default: - Derived from the name of the defining file and the construct's id.
     * If the `NodejsFunction` is defined in `stack.ts` with `my-handler` as id
     * (`new NodejsFunction(this, 'my-handler')`), the construct will look at `stack.my-handler.ts`
     * and `stack.my-handler.js`.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getEntry() {
        return null;
    }

    /**
     * The name of the exported handler in the entry file.
     * <p>
     * Default: handler
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getHandler() {
        return null;
    }

    /**
     * Whether to minify files when bundling.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMinify() {
        return null;
    }

    /**
     * The runtime environment.
     * <p>
     * Only runtimes of the Node.js family are
     * supported.
     * <p>
     * Default: - `NODEJS_12_X` if `process.versions.node` >= '12.0.0',
     * `NODEJS_10_X` otherwise.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.Runtime getRuntime() {
        return null;
    }

    /**
     * Whether to include source maps when bundling.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSourceMaps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NodejsFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NodejsFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.lang.String buildDir;
        private java.lang.String cacheDir;
        private java.lang.String entry;
        private java.lang.String handler;
        private java.lang.Boolean minify;
        private software.amazon.awscdk.services.lambda.Runtime runtime;
        private java.lang.Boolean sourceMaps;
        private java.lang.Boolean allowAllOutbound;
        private software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions;
        private software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private java.lang.Boolean deadLetterQueueEnabled;
        private java.lang.String description;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events;
        private java.lang.String functionName;
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy;
        private java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers;
        private software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private software.amazon.awscdk.services.iam.IRole logRetentionRole;
        private java.lang.Number memorySize;
        private java.lang.Number reservedConcurrentExecutions;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private software.amazon.awscdk.core.Duration timeout;
        private software.amazon.awscdk.services.lambda.Tracing tracing;
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        private software.amazon.awscdk.core.Duration maxEventAge;
        private software.amazon.awscdk.services.lambda.IDestination onFailure;
        private software.amazon.awscdk.services.lambda.IDestination onSuccess;
        private java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link NodejsFunctionProps#getBuildDir}
         * @param buildDir The build directory.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildDir(java.lang.String buildDir) {
            this.buildDir = buildDir;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getCacheDir}
         * @param cacheDir The cache directory.
         *                 Parcel uses a filesystem cache for fast rebuilds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cacheDir(java.lang.String cacheDir) {
            this.cacheDir = cacheDir;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getEntry}
         * @param entry Path to the entry file (JavaScript or TypeScript).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder entry(java.lang.String entry) {
            this.entry = entry;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getHandler}
         * @param handler The name of the exported handler in the entry file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder handler(java.lang.String handler) {
            this.handler = handler;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getMinify}
         * @param minify Whether to minify files when bundling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minify(java.lang.Boolean minify) {
            this.minify = minify;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getRuntime}
         * @param runtime The runtime environment.
         *                Only runtimes of the Node.js family are
         *                supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runtime(software.amazon.awscdk.services.lambda.Runtime runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getSourceMaps}
         * @param sourceMaps Whether to include source maps when bundling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceMaps(java.lang.Boolean sourceMaps) {
            this.sourceMaps = sourceMaps;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getAllowAllOutbound}
         * @param allowAllOutbound Whether to allow the Lambda to send all network traffic.
         *                         If set to false, you must individually add traffic rules to allow the
         *                         Lambda to connect to network targets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getCurrentVersionOptions}
         * @param currentVersionOptions Options for the `lambda.Version` resource automatically created by the `fn.currentVersion` method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentVersionOptions(software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions) {
            this.currentVersionOptions = currentVersionOptions;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getDeadLetterQueue}
         * @param deadLetterQueue The SQS queue to use if DLQ is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getDeadLetterQueueEnabled}
         * @param deadLetterQueueEnabled Enabled DLQ.
         *                               If <code>deadLetterQueue</code> is undefined,
         *                               an SQS queue with default options will be defined for your Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueueEnabled(java.lang.Boolean deadLetterQueueEnabled) {
            this.deadLetterQueueEnabled = deadLetterQueueEnabled;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getDescription}
         * @param description A description of the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getEnvironment}
         * @param environment Key-value pairs that Lambda caches and makes available for your Lambda functions.
         *                    Use environment variables to apply configuration changes, such
         *                    as test and production environment configurations, without changing your
         *                    Lambda function source code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getEvents}
         * @param events Event sources for this function.
         *               You can also add event sources using <code>addEventSource</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events) {
            this.events = events;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getFunctionName}
         * @param functionName A name for the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getInitialPolicy}
         * @param initialPolicy Initial policy statements to add to the created Lambda Role.
         *                      You can call <code>addToRolePolicy</code> to the created lambda to add statements post creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialPolicy(java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy) {
            this.initialPolicy = initialPolicy;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getLayers}
         * @param layers A list of layers to add to the function's execution environment.
         *               You can configure your Lambda function to pull in
         *               additional code during initialization in the form of layers. Layers are packages of libraries or other dependencies
         *               that can be used by mulitple functions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layers(java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers) {
            this.layers = layers;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getLogRetention}
         * @param logRetention The number of days log events are kept in CloudWatch Logs.
         *                     When updating
         *                     this property, unsetting it doesn't remove the log retention policy. To
         *                     remove the retention policy, set the value to <code>INFINITE</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getLogRetentionRole}
         * @param logRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRole(software.amazon.awscdk.services.iam.IRole logRetentionRole) {
            this.logRetentionRole = logRetentionRole;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getMemorySize}
         * @param memorySize The amount of memory, in MB, that is allocated to your Lambda function.
         *                   Lambda uses this value to proportionally allocate the amount of CPU
         *                   power. For more information, see Resource Model in the AWS Lambda
         *                   Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(java.lang.Number memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getReservedConcurrentExecutions}
         * @param reservedConcurrentExecutions The maximum of concurrent executions you want to reserve for the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reservedConcurrentExecutions(java.lang.Number reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getRole}
         * @param role Lambda execution role.
         *             This is the role that will be assumed by the function upon execution.
         *             It controls the permissions that the function will have. The Role must
         *             be assumable by the 'lambda.amazonaws.com' service principal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getSecurityGroup}
         * @param securityGroup What security group to associate with the Lambda's network interfaces. This property is being deprecated, consider using securityGroups instead.
         *                      Only used if 'vpc' is supplied.
         *                      <p>
         *                      Use securityGroups property instead.
         *                      Function constructor will throw an error if both are specified.
         * @return {@code this}
         * @deprecated - This property is deprecated, use securityGroups instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getSecurityGroups}
         * @param securityGroups The list of security groups to associate with the Lambda's network interfaces.
         *                       Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getTimeout}
         * @param timeout The function execution time (in seconds) after which Lambda terminates the function.
         *                Because the execution time affects cost, set this value
         *                based on the function's expected execution time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getTracing}
         * @param tracing Enable AWS X-Ray Tracing for Lambda Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(software.amazon.awscdk.services.lambda.Tracing tracing) {
            this.tracing = tracing;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getVpc}
         * @param vpc VPC network to place Lambda network interfaces.
         *            Specify this if the Lambda function needs to access resources in a VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getVpcSubnets}
         * @param vpcSubnets Where to place the network interfaces within the VPC.
         *                   Only used if 'vpc' is supplied. Note: internet access for Lambdas
         *                   requires a NAT gateway, so picking Public subnets is not allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing.
         *                    Minimum: 60 seconds
         *                    Maximum: 6 hours
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.core.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getOnFailure}
         * @param onFailure The destination for failed invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.lambda.IDestination onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getOnSuccess}
         * @param onSuccess The destination for successful invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSuccess(software.amazon.awscdk.services.lambda.IDestination onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        /**
         * Sets the value of {@link NodejsFunctionProps#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Minimum: 0
         *                      Maximum: 2
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NodejsFunctionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public NodejsFunctionProps build() {
            return new Jsii$Proxy(buildDir, cacheDir, entry, handler, minify, runtime, sourceMaps, allowAllOutbound, currentVersionOptions, deadLetterQueue, deadLetterQueueEnabled, description, environment, events, functionName, initialPolicy, layers, logRetention, logRetentionRole, memorySize, reservedConcurrentExecutions, role, securityGroup, securityGroups, timeout, tracing, vpc, vpcSubnets, maxEventAge, onFailure, onSuccess, retryAttempts);
        }
    }

    /**
     * An implementation for {@link NodejsFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodejsFunctionProps {
        private final java.lang.String buildDir;
        private final java.lang.String cacheDir;
        private final java.lang.String entry;
        private final java.lang.String handler;
        private final java.lang.Boolean minify;
        private final software.amazon.awscdk.services.lambda.Runtime runtime;
        private final java.lang.Boolean sourceMaps;
        private final java.lang.Boolean allowAllOutbound;
        private final software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final java.lang.Boolean deadLetterQueueEnabled;
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events;
        private final java.lang.String functionName;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy;
        private final java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final software.amazon.awscdk.services.iam.IRole logRetentionRole;
        private final java.lang.Number memorySize;
        private final java.lang.Number reservedConcurrentExecutions;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.core.Duration timeout;
        private final software.amazon.awscdk.services.lambda.Tracing tracing;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        private final software.amazon.awscdk.core.Duration maxEventAge;
        private final software.amazon.awscdk.services.lambda.IDestination onFailure;
        private final software.amazon.awscdk.services.lambda.IDestination onSuccess;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.buildDir = this.jsiiGet("buildDir", java.lang.String.class);
            this.cacheDir = this.jsiiGet("cacheDir", java.lang.String.class);
            this.entry = this.jsiiGet("entry", java.lang.String.class);
            this.handler = this.jsiiGet("handler", java.lang.String.class);
            this.minify = this.jsiiGet("minify", java.lang.Boolean.class);
            this.runtime = this.jsiiGet("runtime", software.amazon.awscdk.services.lambda.Runtime.class);
            this.sourceMaps = this.jsiiGet("sourceMaps", java.lang.Boolean.class);
            this.allowAllOutbound = this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
            this.currentVersionOptions = this.jsiiGet("currentVersionOptions", software.amazon.awscdk.services.lambda.VersionOptions.class);
            this.deadLetterQueue = this.jsiiGet("deadLetterQueue", software.amazon.awscdk.services.sqs.IQueue.class);
            this.deadLetterQueueEnabled = this.jsiiGet("deadLetterQueueEnabled", java.lang.Boolean.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.environment = this.jsiiGet("environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.events = this.jsiiGet("events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IEventSource.class)));
            this.functionName = this.jsiiGet("functionName", java.lang.String.class);
            this.initialPolicy = this.jsiiGet("initialPolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.layers = this.jsiiGet("layers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class)));
            this.logRetention = this.jsiiGet("logRetention", software.amazon.awscdk.services.logs.RetentionDays.class);
            this.logRetentionRole = this.jsiiGet("logRetentionRole", software.amazon.awscdk.services.iam.IRole.class);
            this.memorySize = this.jsiiGet("memorySize", java.lang.Number.class);
            this.reservedConcurrentExecutions = this.jsiiGet("reservedConcurrentExecutions", java.lang.Number.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.securityGroup = this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
            this.securityGroups = this.jsiiGet("securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.timeout = this.jsiiGet("timeout", software.amazon.awscdk.core.Duration.class);
            this.tracing = this.jsiiGet("tracing", software.amazon.awscdk.services.lambda.Tracing.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.vpcSubnets = this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
            this.maxEventAge = this.jsiiGet("maxEventAge", software.amazon.awscdk.core.Duration.class);
            this.onFailure = this.jsiiGet("onFailure", software.amazon.awscdk.services.lambda.IDestination.class);
            this.onSuccess = this.jsiiGet("onSuccess", software.amazon.awscdk.services.lambda.IDestination.class);
            this.retryAttempts = this.jsiiGet("retryAttempts", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String buildDir, final java.lang.String cacheDir, final java.lang.String entry, final java.lang.String handler, final java.lang.Boolean minify, final software.amazon.awscdk.services.lambda.Runtime runtime, final java.lang.Boolean sourceMaps, final java.lang.Boolean allowAllOutbound, final software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions, final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue, final java.lang.Boolean deadLetterQueueEnabled, final java.lang.String description, final java.util.Map<java.lang.String, java.lang.String> environment, final java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events, final java.lang.String functionName, final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy, final java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers, final software.amazon.awscdk.services.logs.RetentionDays logRetention, final software.amazon.awscdk.services.iam.IRole logRetentionRole, final java.lang.Number memorySize, final java.lang.Number reservedConcurrentExecutions, final software.amazon.awscdk.services.iam.IRole role, final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups, final software.amazon.awscdk.core.Duration timeout, final software.amazon.awscdk.services.lambda.Tracing tracing, final software.amazon.awscdk.services.ec2.IVpc vpc, final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets, final software.amazon.awscdk.core.Duration maxEventAge, final software.amazon.awscdk.services.lambda.IDestination onFailure, final software.amazon.awscdk.services.lambda.IDestination onSuccess, final java.lang.Number retryAttempts) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.buildDir = buildDir;
            this.cacheDir = cacheDir;
            this.entry = entry;
            this.handler = handler;
            this.minify = minify;
            this.runtime = runtime;
            this.sourceMaps = sourceMaps;
            this.allowAllOutbound = allowAllOutbound;
            this.currentVersionOptions = currentVersionOptions;
            this.deadLetterQueue = deadLetterQueue;
            this.deadLetterQueueEnabled = deadLetterQueueEnabled;
            this.description = description;
            this.environment = environment;
            this.events = events;
            this.functionName = functionName;
            this.initialPolicy = initialPolicy;
            this.layers = layers;
            this.logRetention = logRetention;
            this.logRetentionRole = logRetentionRole;
            this.memorySize = memorySize;
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            this.role = role;
            this.securityGroup = securityGroup;
            this.securityGroups = securityGroups;
            this.timeout = timeout;
            this.tracing = tracing;
            this.vpc = vpc;
            this.vpcSubnets = vpcSubnets;
            this.maxEventAge = maxEventAge;
            this.onFailure = onFailure;
            this.onSuccess = onSuccess;
            this.retryAttempts = retryAttempts;
        }

        @Override
        public java.lang.String getBuildDir() {
            return this.buildDir;
        }

        @Override
        public java.lang.String getCacheDir() {
            return this.cacheDir;
        }

        @Override
        public java.lang.String getEntry() {
            return this.entry;
        }

        @Override
        public java.lang.String getHandler() {
            return this.handler;
        }

        @Override
        public java.lang.Boolean getMinify() {
            return this.minify;
        }

        @Override
        public software.amazon.awscdk.services.lambda.Runtime getRuntime() {
            return this.runtime;
        }

        @Override
        public java.lang.Boolean getSourceMaps() {
            return this.sourceMaps;
        }

        @Override
        public java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public software.amazon.awscdk.services.lambda.VersionOptions getCurrentVersionOptions() {
            return this.currentVersionOptions;
        }

        @Override
        public software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public java.lang.Boolean getDeadLetterQueueEnabled() {
            return this.deadLetterQueueEnabled;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.lambda.IEventSource> getEvents() {
            return this.events;
        }

        @Override
        public java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getInitialPolicy() {
            return this.initialPolicy;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> getLayers() {
            return this.layers;
        }

        @Override
        public software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getLogRetentionRole() {
            return this.logRetentionRole;
        }

        @Override
        public java.lang.Number getMemorySize() {
            return this.memorySize;
        }

        @Override
        public java.lang.Number getReservedConcurrentExecutions() {
            return this.reservedConcurrentExecutions;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public software.amazon.awscdk.services.lambda.Tracing getTracing() {
            return this.tracing;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public software.amazon.awscdk.core.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IDestination getOnFailure() {
            return this.onFailure;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IDestination getOnSuccess() {
            return this.onSuccess;
        }

        @Override
        public java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBuildDir() != null) {
                data.set("buildDir", om.valueToTree(this.getBuildDir()));
            }
            if (this.getCacheDir() != null) {
                data.set("cacheDir", om.valueToTree(this.getCacheDir()));
            }
            if (this.getEntry() != null) {
                data.set("entry", om.valueToTree(this.getEntry()));
            }
            if (this.getHandler() != null) {
                data.set("handler", om.valueToTree(this.getHandler()));
            }
            if (this.getMinify() != null) {
                data.set("minify", om.valueToTree(this.getMinify()));
            }
            if (this.getRuntime() != null) {
                data.set("runtime", om.valueToTree(this.getRuntime()));
            }
            if (this.getSourceMaps() != null) {
                data.set("sourceMaps", om.valueToTree(this.getSourceMaps()));
            }
            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getCurrentVersionOptions() != null) {
                data.set("currentVersionOptions", om.valueToTree(this.getCurrentVersionOptions()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getDeadLetterQueueEnabled() != null) {
                data.set("deadLetterQueueEnabled", om.valueToTree(this.getDeadLetterQueueEnabled()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getEvents() != null) {
                data.set("events", om.valueToTree(this.getEvents()));
            }
            if (this.getFunctionName() != null) {
                data.set("functionName", om.valueToTree(this.getFunctionName()));
            }
            if (this.getInitialPolicy() != null) {
                data.set("initialPolicy", om.valueToTree(this.getInitialPolicy()));
            }
            if (this.getLayers() != null) {
                data.set("layers", om.valueToTree(this.getLayers()));
            }
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getLogRetentionRole() != null) {
                data.set("logRetentionRole", om.valueToTree(this.getLogRetentionRole()));
            }
            if (this.getMemorySize() != null) {
                data.set("memorySize", om.valueToTree(this.getMemorySize()));
            }
            if (this.getReservedConcurrentExecutions() != null) {
                data.set("reservedConcurrentExecutions", om.valueToTree(this.getReservedConcurrentExecutions()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getTracing() != null) {
                data.set("tracing", om.valueToTree(this.getTracing()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }
            if (this.getOnSuccess() != null) {
                data.set("onSuccess", om.valueToTree(this.getOnSuccess()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda-nodejs.NodejsFunctionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NodejsFunctionProps.Jsii$Proxy that = (NodejsFunctionProps.Jsii$Proxy) o;

            if (this.buildDir != null ? !this.buildDir.equals(that.buildDir) : that.buildDir != null) return false;
            if (this.cacheDir != null ? !this.cacheDir.equals(that.cacheDir) : that.cacheDir != null) return false;
            if (this.entry != null ? !this.entry.equals(that.entry) : that.entry != null) return false;
            if (this.handler != null ? !this.handler.equals(that.handler) : that.handler != null) return false;
            if (this.minify != null ? !this.minify.equals(that.minify) : that.minify != null) return false;
            if (this.runtime != null ? !this.runtime.equals(that.runtime) : that.runtime != null) return false;
            if (this.sourceMaps != null ? !this.sourceMaps.equals(that.sourceMaps) : that.sourceMaps != null) return false;
            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.currentVersionOptions != null ? !this.currentVersionOptions.equals(that.currentVersionOptions) : that.currentVersionOptions != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.deadLetterQueueEnabled != null ? !this.deadLetterQueueEnabled.equals(that.deadLetterQueueEnabled) : that.deadLetterQueueEnabled != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.events != null ? !this.events.equals(that.events) : that.events != null) return false;
            if (this.functionName != null ? !this.functionName.equals(that.functionName) : that.functionName != null) return false;
            if (this.initialPolicy != null ? !this.initialPolicy.equals(that.initialPolicy) : that.initialPolicy != null) return false;
            if (this.layers != null ? !this.layers.equals(that.layers) : that.layers != null) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            if (this.logRetentionRole != null ? !this.logRetentionRole.equals(that.logRetentionRole) : that.logRetentionRole != null) return false;
            if (this.memorySize != null ? !this.memorySize.equals(that.memorySize) : that.memorySize != null) return false;
            if (this.reservedConcurrentExecutions != null ? !this.reservedConcurrentExecutions.equals(that.reservedConcurrentExecutions) : that.reservedConcurrentExecutions != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.tracing != null ? !this.tracing.equals(that.tracing) : that.tracing != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            if (this.vpcSubnets != null ? !this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
            if (this.onSuccess != null ? !this.onSuccess.equals(that.onSuccess) : that.onSuccess != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public int hashCode() {
            int result = this.buildDir != null ? this.buildDir.hashCode() : 0;
            result = 31 * result + (this.cacheDir != null ? this.cacheDir.hashCode() : 0);
            result = 31 * result + (this.entry != null ? this.entry.hashCode() : 0);
            result = 31 * result + (this.handler != null ? this.handler.hashCode() : 0);
            result = 31 * result + (this.minify != null ? this.minify.hashCode() : 0);
            result = 31 * result + (this.runtime != null ? this.runtime.hashCode() : 0);
            result = 31 * result + (this.sourceMaps != null ? this.sourceMaps.hashCode() : 0);
            result = 31 * result + (this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0);
            result = 31 * result + (this.currentVersionOptions != null ? this.currentVersionOptions.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueueEnabled != null ? this.deadLetterQueueEnabled.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
            result = 31 * result + (this.functionName != null ? this.functionName.hashCode() : 0);
            result = 31 * result + (this.initialPolicy != null ? this.initialPolicy.hashCode() : 0);
            result = 31 * result + (this.layers != null ? this.layers.hashCode() : 0);
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.logRetentionRole != null ? this.logRetentionRole.hashCode() : 0);
            result = 31 * result + (this.memorySize != null ? this.memorySize.hashCode() : 0);
            result = 31 * result + (this.reservedConcurrentExecutions != null ? this.reservedConcurrentExecutions.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.tracing != null ? this.tracing.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            result = 31 * result + (this.onSuccess != null ? this.onSuccess.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
