/**
 * <h2>Amazon Lambda Node.js Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development. They are subject to non-backward compatible changes or removal in any future version. These are not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be announced in the release notes. This means that while you may use them, you may need to update your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This library provides constructs for Node.js Lambda functions.
 * <p>
 * To use this module, you will need to have Docker installed.
 * <p>
 * <h3>Node.js Function</h3>
 * <p>
 * Define a <code>NodejsFunction</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * new NodejsFunction(this, "my-handler");
 * </pre></blockquote>
 * <p>
 * By default, the construct will use the name of the defining file and the construct's id to look
 * up the entry file:
 * <p>
 * <blockquote><pre>
 * .
 * ├── stack.ts # defines a 'NodejsFunction' with 'my-handler' as id
 * ├── stack.my-handler.ts # exports a function named 'handler'
 * </pre></blockquote>
 * <p>
 * This file is used as "entry" for <a href="https://parceljs.org/">Parcel</a>. This means that your code is
 * automatically transpiled and bundled whether it's written in JavaScript or TypeScript.
 * <p>
 * Alternatively, an entry file and handler can be specified:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * NodejsFunction.Builder.create(this, "MyFunction")
 *         .entry("/path/to/my/file.ts")
 *         .handler("myExportedFunc")
 *         .build();
 * </pre></blockquote>
 * <p>
 * All other properties of <code>lambda.Function</code> are supported, see also the <a href="https://github.com/aws/aws-cdk/tree/master/packages/%40aws-cdk/aws-lambda">AWS Lambda construct library</a>.
 * <p>
 * Use the <code>containerEnvironment</code> prop to pass environments variables to the Docker container
 * running Parcel:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * NodejsFunction.Builder.create(this, "my-handler")
 *         .containerEnvironment(Map.of(
 *                 "NODE_ENV", "production"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Configuring Parcel</h3>
 * <p>
 * The <code>NodejsFunction</code> construct exposes some <a href="https://parceljs.org/">Parcel</a> options via properties: <code>minify</code>, <code>sourceMaps</code>,
 * <code>buildDir</code> and <code>cacheDir</code>.
 * <p>
 * Parcel transpiles your code (every internal module) with <a href="https://babeljs.io/docs/en/babel-preset-env">&#64;babel/preset-env</a> and uses the
 * runtime version of your Lambda function as target.
 * <p>
 * Configuring Babel with Parcel is possible via a <code>.babelrc</code> or a <code>babel</code> config in <code>package.json</code>.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.lambda.nodejs;
