/**
 * <h2>Amazon Lambda Node.js Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development. They are subject to non-backward compatible changes or removal in any future version. These are not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be announced in the release notes. This means that while you may use them, you may need to update your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This library provides constructs for Node.js Lambda functions.
 * <p>
 * To use this module, you will need to have Docker installed.
 * <p>
 * <h3>Node.js Function</h3>
 * <p>
 * Define a <code>NodejsFunction</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * new NodejsFunction(this, "my-handler");
 * </pre></blockquote>
 * <p>
 * By default, the construct will use the name of the defining file and the construct's id to look
 * up the entry file:
 * <p>
 * <blockquote><pre>
 * .
 * ├── stack.ts # defines a 'NodejsFunction' with 'my-handler' as id
 * ├── stack.my-handler.ts # exports a function named 'handler'
 * </pre></blockquote>
 * <p>
 * This file is used as "entry" for <a href="https://esbuild.github.io/">esbuild</a>. This means that your code is automatically transpiled and bundled whether it's written in JavaScript or TypeScript.
 * <p>
 * Alternatively, an entry file and handler can be specified:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * NodejsFunction.Builder.create(this, "MyFunction")
 *         .entry("/path/to/my/file.ts")// accepts .js, .jsx, .ts and .tsx files
 *         .handler("myExportedFunc")
 *         .build();
 * </pre></blockquote>
 * <p>
 * All other properties of <code>lambda.Function</code> are supported, see also the <a href="https://github.com/aws/aws-cdk/tree/master/packages/%40aws-cdk/aws-lambda">AWS Lambda construct library</a>.
 * <p>
 * The <code>NodejsFunction</code> construct automatically <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/node-reusing-connections.html">reuses existing connections</a>
 * when working with the AWS SDK for JavaScript. Set the <code>awsSdkConnectionReuse</code> prop to <code>false</code> to disable it.
 * <p>
 * Use the <code>bundlingEnvironment</code> prop to define environments variables when esbuild runs:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * NodejsFunction.Builder.create(this, "my-handler")
 *         .bundlingEnvironment(Map.of(
 *                 "NODE_ENV", "production"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Use the <code>buildArgs</code> prop to pass build arguments when building the bundling image:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * NodejsFunction.Builder.create(this, "my-handler")
 *         .buildArgs(Map.of(
 *                 "HTTPS_PROXY", "https://127.0.0.1:3001"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Use the <code>bundlingDockerImage</code> prop to use a custom bundling image:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * NodejsFunction.Builder.create(this, "my-handler")
 *         .bundlingDockerImage(dk.BundlingDockerImage.fromAsset("/path/to/Dockerfile"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * This image should have esbuild installed globally. If you plan to use <code>nodeModules</code> it
 * should also have <code>npm</code> or <code>yarn</code> depending on the lock file you're using.
 * <p>
 * Use the <a href="https://github.com/aws/aws-cdk/blob/master/packages/%40aws-cdk/aws-lambda-nodejs/lib/Dockerfile">default image provided by <code>&#64;aws-cdk/aws-lambda-nodejs</code></a>
 * as a source of inspiration.
 * <p>
 * <h3>Lock file</h3>
 * <p>
 * The <code>NodejsFunction</code> requires a dependencies lock file (<code>yarn.lock</code> or
 * <code>package-lock.json</code>). When bundling in a Docker container, the path containing this
 * lock file is used as the source (<code>/asset-input</code>) for the volume mounted in the
 * container.
 * <p>
 * By default, it will try to automatically determine your project lock file.
 * Alternatively, you can specify the <code>depsLockFilePath</code> prop manually. In this
 * case you need to ensure that this path includes <code>entry</code> and any module/dependencies
 * used by your function. Otherwise bundling will fail.
 * <p>
 * <h3>Configuring esbuild</h3>
 * <p>
 * The <code>NodejsFunction</code> construct exposes some <a href="https://esbuild.github.io/">esbuild</a> options via properties: <code>minify</code>, <code>sourceMaps</code> and <code>target</code>.
 * <p>
 * <h3>Working with modules</h3>
 * <p>
 * <h4>Externals</h4>
 * <p>
 * By default, all node modules are bundled except for <code>aws-sdk</code>. This can be configured by specifying
 * the <code>externalModules</code> prop.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * NodejsFunction.Builder.create(this, "my-handler")
 *         .externalModules(asList("aws-sdk", "cool-module"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h4>Install modules</h4>
 * <p>
 * By default, all node modules referenced in your Lambda code will be bundled by esbuild.
 * Use the <code>nodeModules</code> prop to specify a list of modules that should not be bundled
 * but instead included in the <code>node_modules</code> folder of the Lambda package. This is useful
 * when working with native dependencies or when esbuild fails to bundle a module.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * NodejsFunction.Builder.create(this, "my-handler")
 *         .nodeModules(asList("native-module", "other-module"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * The modules listed in <code>nodeModules</code> must be present in the <code>package.json</code>'s dependencies. The
 * same version will be used for installation. The lock file (<code>yarn.lock</code> or <code>package-lock.json</code>)
 * will be used along with the right installer (<code>yarn</code> or <code>npm</code>).
 * <p>
 * <h3>Local bundling</h3>
 * <p>
 * If esbuild is available it will be used to bundle your code in your environment. Otherwise,
 * bundling will happen in a <a href="https://hub.docker.com/r/amazon/aws-sam-cli-build-image-nodejs12.x">Lambda compatible Docker container</a>.
 * <p>
 * For macOS the recommendend approach is to install esbuild as Docker volume performance is really poor.
 * <p>
 * esbuild can be installed with:
 * <p>
 * <blockquote><pre>
 * $ npm install --save-dev esbuild&#64;0
 * </pre></blockquote>
 * <p>
 * OR
 * <p>
 * <blockquote><pre>
 * $ yarn add --dev esbuild&#64;0
 * </pre></blockquote>
 * <p>
 * To force bundling in a Docker container, set the <code>forceDockerBundling</code> prop to <code>true</code>. This
 * is useful if your function relies on node modules that should be installed (<code>nodeModules</code> prop, see <a href="#install-modules">above</a>) in a Lambda compatible environment. This is usually the
 * case with modules using native dependencies.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.lambda.nodejs;
