package software.amazon.awscdk.services.lambda.python.alpha;

/**
 * (experimental) Options for bundling.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String entry = "/path/to/function";
 * DockerImage image = DockerImage.fromBuild(entry);
 * PythonFunction.Builder.create(this, "function")
 *         .entry(entry)
 *         .runtime(Runtime.PYTHON_3_8)
 *         .bundling(BundlingOptions.builder()
 *                 .buildArgs(Map.of("PIP_INDEX_URL", "https://your.index.url/simple/", "PIP_EXTRA_INDEX_URL", "https://your.extra-index.url/simple/"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:49.997Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.python.alpha.$Module.class, fqn = "@aws-cdk/aws-lambda-python-alpha.BundlingOptions")
@software.amazon.jsii.Jsii.Proxy(BundlingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BundlingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Specify a custom hash for this asset.
     * <p>
     * If <code>assetHashType</code> is set it must
     * be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
     * be SHA256 hashed and encoded as hex. The resulting hash will be the asset
     * hash.
     * <p>
     * NOTE: the hash is used in order to identify a specific revision of the asset, and
     * used for optimizing and caching deployment activities related to this asset such as
     * packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
     * need to make sure it is updated every time the asset changes, or otherwise it is
     * possible that some deployments will not be invalidated.
     * <p>
     * Default: - Based on `assetHashType`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssetHash() {
        return null;
    }

    /**
     * (experimental) Determines how asset hash is calculated. Assets will get rebuild and uploaded only if their hash has changed.
     * <p>
     * If asset hash is set to <code>SOURCE</code> (default), then only changes to the source
     * directory will cause the asset to rebuild. This means, for example, that in
     * order to pick up a new dependency version, a change must be made to the
     * source tree. Ideally, this can be implemented by including a dependency
     * lockfile in your source tree or using fixed dependencies.
     * <p>
     * If the asset hash is set to <code>OUTPUT</code>, the hash is calculated after
     * bundling. This means that any change in the output will cause the asset to
     * be invalidated and uploaded. Bear in mind that <code>pip</code> adds timestamps to
     * dependencies it installs, which implies that in this mode Python bundles
     * will <em>always</em> get rebuild and uploaded. Normally this is an anti-pattern
     * since build
     * <p>
     * Default: AssetHashType.SOURCE By default, hash is calculated based on the
     * contents of the source directory. This means that only updates to the
     * source will cause the asset to rebuild.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.AssetHashType getAssetHashType() {
        return null;
    }

    /**
     * (experimental) Optional build arguments to pass to the default container.
     * <p>
     * This can be used to customize
     * the index URLs used for installing dependencies.
     * This is not used if a custom image is provided.
     * <p>
     * Default: - No build arguments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
        return null;
    }

    /**
     * (experimental) Environment variables defined when bundling runs.
     * <p>
     * Default: - no environment variables are defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * (experimental) Docker image to use for bundling.
     * <p>
     * If no options are provided, the default bundling image
     * will be used. Dependencies will be installed using the default packaging commands
     * and copied over from into the Lambda asset.
     * <p>
     * Default: - Default bundling image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.DockerImage getImage() {
        return null;
    }

    /**
     * (experimental) Output path suffix: the suffix for the directory into which the bundled output is written.
     * <p>
     * Default: - 'python' for a layer, empty string otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutputPathSuffix() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BundlingOptions> {
        java.lang.String assetHash;
        software.amazon.awscdk.AssetHashType assetHashType;
        java.util.Map<java.lang.String, java.lang.String> buildArgs;
        java.util.Map<java.lang.String, java.lang.String> environment;
        software.amazon.awscdk.DockerImage image;
        java.lang.String outputPathSuffix;

        /**
         * Sets the value of {@link BundlingOptions#getAssetHash}
         * @param assetHash Specify a custom hash for this asset.
         *                  If <code>assetHashType</code> is set it must
         *                  be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
         *                  be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         *                  hash.
         *                  <p>
         *                  NOTE: the hash is used in order to identify a specific revision of the asset, and
         *                  used for optimizing and caching deployment activities related to this asset such as
         *                  packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         *                  need to make sure it is updated every time the asset changes, or otherwise it is
         *                  possible that some deployments will not be invalidated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetHash(java.lang.String assetHash) {
            this.assetHash = assetHash;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getAssetHashType}
         * @param assetHashType Determines how asset hash is calculated. Assets will get rebuild and uploaded only if their hash has changed.
         *                      If asset hash is set to <code>SOURCE</code> (default), then only changes to the source
         *                      directory will cause the asset to rebuild. This means, for example, that in
         *                      order to pick up a new dependency version, a change must be made to the
         *                      source tree. Ideally, this can be implemented by including a dependency
         *                      lockfile in your source tree or using fixed dependencies.
         *                      <p>
         *                      If the asset hash is set to <code>OUTPUT</code>, the hash is calculated after
         *                      bundling. This means that any change in the output will cause the asset to
         *                      be invalidated and uploaded. Bear in mind that <code>pip</code> adds timestamps to
         *                      dependencies it installs, which implies that in this mode Python bundles
         *                      will <em>always</em> get rebuild and uploaded. Normally this is an anti-pattern
         *                      since build
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetHashType(software.amazon.awscdk.AssetHashType assetHashType) {
            this.assetHashType = assetHashType;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getBuildArgs}
         * @param buildArgs Optional build arguments to pass to the default container.
         *                  This can be used to customize
         *                  the index URLs used for installing dependencies.
         *                  This is not used if a custom image is provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildArgs(java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEnvironment}
         * @param environment Environment variables defined when bundling runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getImage}
         * @param image Docker image to use for bundling.
         *              If no options are provided, the default bundling image
         *              will be used. Dependencies will be installed using the default packaging commands
         *              and copied over from into the Lambda asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder image(software.amazon.awscdk.DockerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getOutputPathSuffix}
         * @param outputPathSuffix Output path suffix: the suffix for the directory into which the bundled output is written.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputPathSuffix(java.lang.String outputPathSuffix) {
            this.outputPathSuffix = outputPathSuffix;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BundlingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BundlingOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BundlingOptions {
        private final java.lang.String assetHash;
        private final software.amazon.awscdk.AssetHashType assetHashType;
        private final java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final software.amazon.awscdk.DockerImage image;
        private final java.lang.String outputPathSuffix;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assetHash = software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetHashType = software.amazon.jsii.Kernel.get(this, "assetHashType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.AssetHashType.class));
            this.buildArgs = software.amazon.jsii.Kernel.get(this, "buildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImage.class));
            this.outputPathSuffix = software.amazon.jsii.Kernel.get(this, "outputPathSuffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assetHash = builder.assetHash;
            this.assetHashType = builder.assetHashType;
            this.buildArgs = builder.buildArgs;
            this.environment = builder.environment;
            this.image = builder.image;
            this.outputPathSuffix = builder.outputPathSuffix;
        }

        @Override
        public final java.lang.String getAssetHash() {
            return this.assetHash;
        }

        @Override
        public final software.amazon.awscdk.AssetHashType getAssetHashType() {
            return this.assetHashType;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
            return this.buildArgs;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final software.amazon.awscdk.DockerImage getImage() {
            return this.image;
        }

        @Override
        public final java.lang.String getOutputPathSuffix() {
            return this.outputPathSuffix;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssetHash() != null) {
                data.set("assetHash", om.valueToTree(this.getAssetHash()));
            }
            if (this.getAssetHashType() != null) {
                data.set("assetHashType", om.valueToTree(this.getAssetHashType()));
            }
            if (this.getBuildArgs() != null) {
                data.set("buildArgs", om.valueToTree(this.getBuildArgs()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getImage() != null) {
                data.set("image", om.valueToTree(this.getImage()));
            }
            if (this.getOutputPathSuffix() != null) {
                data.set("outputPathSuffix", om.valueToTree(this.getOutputPathSuffix()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda-python-alpha.BundlingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BundlingOptions.Jsii$Proxy that = (BundlingOptions.Jsii$Proxy) o;

            if (this.assetHash != null ? !this.assetHash.equals(that.assetHash) : that.assetHash != null) return false;
            if (this.assetHashType != null ? !this.assetHashType.equals(that.assetHashType) : that.assetHashType != null) return false;
            if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.image != null ? !this.image.equals(that.image) : that.image != null) return false;
            return this.outputPathSuffix != null ? this.outputPathSuffix.equals(that.outputPathSuffix) : that.outputPathSuffix == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assetHash != null ? this.assetHash.hashCode() : 0;
            result = 31 * result + (this.assetHashType != null ? this.assetHashType.hashCode() : 0);
            result = 31 * result + (this.buildArgs != null ? this.buildArgs.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
            result = 31 * result + (this.outputPathSuffix != null ? this.outputPathSuffix.hashCode() : 0);
            return result;
        }
    }
}
