package software.amazon.awscdk.services.lambda.python.alpha;

/**
 * (experimental) Options for bundling.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String entry = "/path/to/function";
 * DockerImage image = DockerImage.fromBuild(entry);
 * PythonFunction.Builder.create(this, "function")
 *         .entry(entry)
 *         .runtime(Runtime.PYTHON_3_8)
 *         .bundling(BundlingOptions.builder()
 *                 .buildArgs(Map.of("PIP_INDEX_URL", "https://your.index.url/simple/", "PIP_EXTRA_INDEX_URL", "https://your.extra-index.url/simple/"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-03T19:59:44.600Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.python.alpha.$Module.class, fqn = "@aws-cdk/aws-lambda-python-alpha.BundlingOptions")
@software.amazon.jsii.Jsii.Proxy(BundlingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BundlingOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.DockerRunOptions {

    /**
     * (experimental) Specify a custom hash for this asset.
     * <p>
     * If <code>assetHashType</code> is set it must
     * be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
     * be SHA256 hashed and encoded as hex. The resulting hash will be the asset
     * hash.
     * <p>
     * NOTE: the hash is used in order to identify a specific revision of the asset, and
     * used for optimizing and caching deployment activities related to this asset such as
     * packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
     * need to make sure it is updated every time the asset changes, or otherwise it is
     * possible that some deployments will not be invalidated.
     * <p>
     * Default: - Based on `assetHashType`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssetHash() {
        return null;
    }

    /**
     * (experimental) Determines how asset hash is calculated. Assets will get rebuild and uploaded only if their hash has changed.
     * <p>
     * If asset hash is set to <code>SOURCE</code> (default), then only changes to the source
     * directory will cause the asset to rebuild. This means, for example, that in
     * order to pick up a new dependency version, a change must be made to the
     * source tree. Ideally, this can be implemented by including a dependency
     * lockfile in your source tree or using fixed dependencies.
     * <p>
     * If the asset hash is set to <code>OUTPUT</code>, the hash is calculated after
     * bundling. This means that any change in the output will cause the asset to
     * be invalidated and uploaded. Bear in mind that <code>pip</code> adds timestamps to
     * dependencies it installs, which implies that in this mode Python bundles
     * will <em>always</em> get rebuild and uploaded. Normally this is an anti-pattern
     * since build
     * <p>
     * Default: AssetHashType.SOURCE By default, hash is calculated based on the
     * contents of the source directory. This means that only updates to the
     * source will cause the asset to rebuild.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.AssetHashType getAssetHashType() {
        return null;
    }

    /**
     * (experimental) Optional build arguments to pass to the default container.
     * <p>
     * This can be used to customize
     * the index URLs used for installing dependencies.
     * This is not used if a custom image is provided.
     * <p>
     * Default: - No build arguments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
        return null;
    }

    /**
     * (experimental) Which option to use to copy the source files to the docker container and output files back.
     * <p>
     * Default: - BundlingFileAccess.BIND_MOUNT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.BundlingFileAccess getBundlingFileAccess() {
        return null;
    }

    /**
     * (experimental) Command hooks.
     * <p>
     * Default: - do not run additional commands
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.python.alpha.ICommandHooks getCommandHooks() {
        return null;
    }

    /**
     * (experimental) Docker image to use for bundling.
     * <p>
     * If no options are provided, the default bundling image
     * will be used. Dependencies will be installed using the default packaging commands
     * and copied over from into the Lambda asset.
     * <p>
     * Default: - Default bundling image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.DockerImage getImage() {
        return null;
    }

    /**
     * (experimental) Output path suffix: the suffix for the directory into which the bundled output is written.
     * <p>
     * Default: - 'python' for a layer, empty string otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutputPathSuffix() {
        return null;
    }

    /**
     * (experimental) Whether to export Poetry dependencies with hashes.
     * <p>
     * Note that this can cause builds to fail if not all dependencies
     * export with a hash.
     * <p>
     * Default: Hashes are NOT included in the exported `requirements.txt` file
     * <p>
     * @see <a href="https://github.com/aws/aws-cdk/issues/19232">https://github.com/aws/aws-cdk/issues/19232</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPoetryIncludeHashes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BundlingOptions> {
        java.lang.String assetHash;
        software.amazon.awscdk.AssetHashType assetHashType;
        java.util.Map<java.lang.String, java.lang.String> buildArgs;
        software.amazon.awscdk.BundlingFileAccess bundlingFileAccess;
        software.amazon.awscdk.services.lambda.python.alpha.ICommandHooks commandHooks;
        software.amazon.awscdk.DockerImage image;
        java.lang.String outputPathSuffix;
        java.lang.Boolean poetryIncludeHashes;
        java.util.List<java.lang.String> command;
        java.util.List<java.lang.String> entrypoint;
        java.util.Map<java.lang.String, java.lang.String> environment;
        java.lang.String network;
        java.lang.String securityOpt;
        java.lang.String user;
        java.util.List<software.amazon.awscdk.DockerVolume> volumes;
        java.util.List<java.lang.String> volumesFrom;
        java.lang.String workingDirectory;

        /**
         * Sets the value of {@link BundlingOptions#getAssetHash}
         * @param assetHash Specify a custom hash for this asset.
         *                  If <code>assetHashType</code> is set it must
         *                  be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
         *                  be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         *                  hash.
         *                  <p>
         *                  NOTE: the hash is used in order to identify a specific revision of the asset, and
         *                  used for optimizing and caching deployment activities related to this asset such as
         *                  packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         *                  need to make sure it is updated every time the asset changes, or otherwise it is
         *                  possible that some deployments will not be invalidated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetHash(java.lang.String assetHash) {
            this.assetHash = assetHash;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getAssetHashType}
         * @param assetHashType Determines how asset hash is calculated. Assets will get rebuild and uploaded only if their hash has changed.
         *                      If asset hash is set to <code>SOURCE</code> (default), then only changes to the source
         *                      directory will cause the asset to rebuild. This means, for example, that in
         *                      order to pick up a new dependency version, a change must be made to the
         *                      source tree. Ideally, this can be implemented by including a dependency
         *                      lockfile in your source tree or using fixed dependencies.
         *                      <p>
         *                      If the asset hash is set to <code>OUTPUT</code>, the hash is calculated after
         *                      bundling. This means that any change in the output will cause the asset to
         *                      be invalidated and uploaded. Bear in mind that <code>pip</code> adds timestamps to
         *                      dependencies it installs, which implies that in this mode Python bundles
         *                      will <em>always</em> get rebuild and uploaded. Normally this is an anti-pattern
         *                      since build
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetHashType(software.amazon.awscdk.AssetHashType assetHashType) {
            this.assetHashType = assetHashType;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getBuildArgs}
         * @param buildArgs Optional build arguments to pass to the default container.
         *                  This can be used to customize
         *                  the index URLs used for installing dependencies.
         *                  This is not used if a custom image is provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildArgs(java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getBundlingFileAccess}
         * @param bundlingFileAccess Which option to use to copy the source files to the docker container and output files back.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bundlingFileAccess(software.amazon.awscdk.BundlingFileAccess bundlingFileAccess) {
            this.bundlingFileAccess = bundlingFileAccess;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getCommandHooks}
         * @param commandHooks Command hooks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder commandHooks(software.amazon.awscdk.services.lambda.python.alpha.ICommandHooks commandHooks) {
            this.commandHooks = commandHooks;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getImage}
         * @param image Docker image to use for bundling.
         *              If no options are provided, the default bundling image
         *              will be used. Dependencies will be installed using the default packaging commands
         *              and copied over from into the Lambda asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder image(software.amazon.awscdk.DockerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getOutputPathSuffix}
         * @param outputPathSuffix Output path suffix: the suffix for the directory into which the bundled output is written.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputPathSuffix(java.lang.String outputPathSuffix) {
            this.outputPathSuffix = outputPathSuffix;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getPoetryIncludeHashes}
         * @param poetryIncludeHashes Whether to export Poetry dependencies with hashes.
         *                            Note that this can cause builds to fail if not all dependencies
         *                            export with a hash.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder poetryIncludeHashes(java.lang.Boolean poetryIncludeHashes) {
            this.poetryIncludeHashes = poetryIncludeHashes;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getCommand}
         * @param command The command to run in the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEntrypoint}
         * @param entrypoint The entrypoint to run in the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entrypoint(java.util.List<java.lang.String> entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEnvironment}
         * @param environment The environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getNetwork}
         * @param network Docker [Networking options](https://docs.docker.com/engine/reference/commandline/run/#connect-a-container-to-a-network---network).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder network(java.lang.String network) {
            this.network = network;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getSecurityOpt}
         * @param securityOpt [Security configuration](https://docs.docker.com/engine/reference/run/#security-configuration) when running the docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityOpt(java.lang.String securityOpt) {
            this.securityOpt = securityOpt;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getUser}
         * @param user The user to use when running the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getVolumes}
         * @param volumes Docker volumes to mount.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends software.amazon.awscdk.DockerVolume> volumes) {
            this.volumes = (java.util.List<software.amazon.awscdk.DockerVolume>)volumes;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getVolumesFrom}
         * @param volumesFrom Where to mount the specified volumes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumesFrom(java.util.List<java.lang.String> volumesFrom) {
            this.volumesFrom = volumesFrom;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getWorkingDirectory}
         * @param workingDirectory Working directory inside the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(java.lang.String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BundlingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BundlingOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BundlingOptions {
        private final java.lang.String assetHash;
        private final software.amazon.awscdk.AssetHashType assetHashType;
        private final java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private final software.amazon.awscdk.BundlingFileAccess bundlingFileAccess;
        private final software.amazon.awscdk.services.lambda.python.alpha.ICommandHooks commandHooks;
        private final software.amazon.awscdk.DockerImage image;
        private final java.lang.String outputPathSuffix;
        private final java.lang.Boolean poetryIncludeHashes;
        private final java.util.List<java.lang.String> command;
        private final java.util.List<java.lang.String> entrypoint;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.String network;
        private final java.lang.String securityOpt;
        private final java.lang.String user;
        private final java.util.List<software.amazon.awscdk.DockerVolume> volumes;
        private final java.util.List<java.lang.String> volumesFrom;
        private final java.lang.String workingDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assetHash = software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetHashType = software.amazon.jsii.Kernel.get(this, "assetHashType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.AssetHashType.class));
            this.buildArgs = software.amazon.jsii.Kernel.get(this, "buildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.bundlingFileAccess = software.amazon.jsii.Kernel.get(this, "bundlingFileAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.BundlingFileAccess.class));
            this.commandHooks = software.amazon.jsii.Kernel.get(this, "commandHooks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.python.alpha.ICommandHooks.class));
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImage.class));
            this.outputPathSuffix = software.amazon.jsii.Kernel.get(this, "outputPathSuffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.poetryIncludeHashes = software.amazon.jsii.Kernel.get(this, "poetryIncludeHashes", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.entrypoint = software.amazon.jsii.Kernel.get(this, "entrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.network = software.amazon.jsii.Kernel.get(this, "network", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityOpt = software.amazon.jsii.Kernel.get(this, "securityOpt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerVolume.class)));
            this.volumesFrom = software.amazon.jsii.Kernel.get(this, "volumesFrom", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assetHash = builder.assetHash;
            this.assetHashType = builder.assetHashType;
            this.buildArgs = builder.buildArgs;
            this.bundlingFileAccess = builder.bundlingFileAccess;
            this.commandHooks = builder.commandHooks;
            this.image = builder.image;
            this.outputPathSuffix = builder.outputPathSuffix;
            this.poetryIncludeHashes = builder.poetryIncludeHashes;
            this.command = builder.command;
            this.entrypoint = builder.entrypoint;
            this.environment = builder.environment;
            this.network = builder.network;
            this.securityOpt = builder.securityOpt;
            this.user = builder.user;
            this.volumes = (java.util.List<software.amazon.awscdk.DockerVolume>)builder.volumes;
            this.volumesFrom = builder.volumesFrom;
            this.workingDirectory = builder.workingDirectory;
        }

        @Override
        public final java.lang.String getAssetHash() {
            return this.assetHash;
        }

        @Override
        public final software.amazon.awscdk.AssetHashType getAssetHashType() {
            return this.assetHashType;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
            return this.buildArgs;
        }

        @Override
        public final software.amazon.awscdk.BundlingFileAccess getBundlingFileAccess() {
            return this.bundlingFileAccess;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.python.alpha.ICommandHooks getCommandHooks() {
            return this.commandHooks;
        }

        @Override
        public final software.amazon.awscdk.DockerImage getImage() {
            return this.image;
        }

        @Override
        public final java.lang.String getOutputPathSuffix() {
            return this.outputPathSuffix;
        }

        @Override
        public final java.lang.Boolean getPoetryIncludeHashes() {
            return this.poetryIncludeHashes;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.util.List<java.lang.String> getEntrypoint() {
            return this.entrypoint;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.String getNetwork() {
            return this.network;
        }

        @Override
        public final java.lang.String getSecurityOpt() {
            return this.securityOpt;
        }

        @Override
        public final java.lang.String getUser() {
            return this.user;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.DockerVolume> getVolumes() {
            return this.volumes;
        }

        @Override
        public final java.util.List<java.lang.String> getVolumesFrom() {
            return this.volumesFrom;
        }

        @Override
        public final java.lang.String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssetHash() != null) {
                data.set("assetHash", om.valueToTree(this.getAssetHash()));
            }
            if (this.getAssetHashType() != null) {
                data.set("assetHashType", om.valueToTree(this.getAssetHashType()));
            }
            if (this.getBuildArgs() != null) {
                data.set("buildArgs", om.valueToTree(this.getBuildArgs()));
            }
            if (this.getBundlingFileAccess() != null) {
                data.set("bundlingFileAccess", om.valueToTree(this.getBundlingFileAccess()));
            }
            if (this.getCommandHooks() != null) {
                data.set("commandHooks", om.valueToTree(this.getCommandHooks()));
            }
            if (this.getImage() != null) {
                data.set("image", om.valueToTree(this.getImage()));
            }
            if (this.getOutputPathSuffix() != null) {
                data.set("outputPathSuffix", om.valueToTree(this.getOutputPathSuffix()));
            }
            if (this.getPoetryIncludeHashes() != null) {
                data.set("poetryIncludeHashes", om.valueToTree(this.getPoetryIncludeHashes()));
            }
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEntrypoint() != null) {
                data.set("entrypoint", om.valueToTree(this.getEntrypoint()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getNetwork() != null) {
                data.set("network", om.valueToTree(this.getNetwork()));
            }
            if (this.getSecurityOpt() != null) {
                data.set("securityOpt", om.valueToTree(this.getSecurityOpt()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }
            if (this.getVolumesFrom() != null) {
                data.set("volumesFrom", om.valueToTree(this.getVolumesFrom()));
            }
            if (this.getWorkingDirectory() != null) {
                data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda-python-alpha.BundlingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BundlingOptions.Jsii$Proxy that = (BundlingOptions.Jsii$Proxy) o;

            if (this.assetHash != null ? !this.assetHash.equals(that.assetHash) : that.assetHash != null) return false;
            if (this.assetHashType != null ? !this.assetHashType.equals(that.assetHashType) : that.assetHashType != null) return false;
            if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) return false;
            if (this.bundlingFileAccess != null ? !this.bundlingFileAccess.equals(that.bundlingFileAccess) : that.bundlingFileAccess != null) return false;
            if (this.commandHooks != null ? !this.commandHooks.equals(that.commandHooks) : that.commandHooks != null) return false;
            if (this.image != null ? !this.image.equals(that.image) : that.image != null) return false;
            if (this.outputPathSuffix != null ? !this.outputPathSuffix.equals(that.outputPathSuffix) : that.outputPathSuffix != null) return false;
            if (this.poetryIncludeHashes != null ? !this.poetryIncludeHashes.equals(that.poetryIncludeHashes) : that.poetryIncludeHashes != null) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.entrypoint != null ? !this.entrypoint.equals(that.entrypoint) : that.entrypoint != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.network != null ? !this.network.equals(that.network) : that.network != null) return false;
            if (this.securityOpt != null ? !this.securityOpt.equals(that.securityOpt) : that.securityOpt != null) return false;
            if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
            if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) return false;
            if (this.volumesFrom != null ? !this.volumesFrom.equals(that.volumesFrom) : that.volumesFrom != null) return false;
            return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assetHash != null ? this.assetHash.hashCode() : 0;
            result = 31 * result + (this.assetHashType != null ? this.assetHashType.hashCode() : 0);
            result = 31 * result + (this.buildArgs != null ? this.buildArgs.hashCode() : 0);
            result = 31 * result + (this.bundlingFileAccess != null ? this.bundlingFileAccess.hashCode() : 0);
            result = 31 * result + (this.commandHooks != null ? this.commandHooks.hashCode() : 0);
            result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
            result = 31 * result + (this.outputPathSuffix != null ? this.outputPathSuffix.hashCode() : 0);
            result = 31 * result + (this.poetryIncludeHashes != null ? this.poetryIncludeHashes.hashCode() : 0);
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.entrypoint != null ? this.entrypoint.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.network != null ? this.network.hashCode() : 0);
            result = 31 * result + (this.securityOpt != null ? this.securityOpt.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            result = 31 * result + (this.volumesFrom != null ? this.volumesFrom.hashCode() : 0);
            result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
            return result;
        }
    }
}
