package software.amazon.awscdk.services.lambda.python;

/**
 * (experimental) A Python Lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String entry = "/path/to/function";
 * DockerImage image = DockerImage.fromBuild(entry);
 * PythonFunction.Builder.create(this, "function")
 *         .entry(entry)
 *         .runtime(Runtime.PYTHON_3_8)
 *         .bundling(BundlingOptions.builder()
 *                 .buildArgs(Map.of("PIP_INDEX_URL", "https://your.index.url/simple/", "PIP_EXTRA_INDEX_URL", "https://your.extra-index.url/simple/"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-23T19:56:57.978Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.python.$Module.class, fqn = "@aws-cdk/aws-lambda-python.PythonFunction")
public class PythonFunction extends software.amazon.awscdk.services.lambda.Function {

    protected PythonFunction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PythonFunction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public PythonFunction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.python.PythonFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.lambda.python.PythonFunction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.python.PythonFunction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.python.PythonFunctionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.python.PythonFunctionProps.Builder();
        }

        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum: 60 seconds
         * Maximum: 6 hours
         * <p>
         * Default: Duration.hours(6)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.core.Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The destination for failed invocations.
         * <p>
         * Default: - no destination
         * <p>
         * @return {@code this}
         * @param onFailure The destination for failed invocations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(final software.amazon.awscdk.services.lambda.IDestination onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        /**
         * The destination for successful invocations.
         * <p>
         * Default: - no destination
         * <p>
         * @return {@code this}
         * @param onSuccess The destination for successful invocations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSuccess(final software.amazon.awscdk.services.lambda.IDestination onSuccess) {
            this.props.onSuccess(onSuccess);
            return this;
        }

        /**
         * The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum: 0
         * Maximum: 2
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * Whether to allow the Lambda to send all network traffic.
         * <p>
         * If set to false, you must individually add traffic rules to allow the
         * Lambda to connect to network targets.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowAllOutbound Whether to allow the Lambda to send all network traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * Lambda Functions in a public subnet can NOT access the internet.
         * <p>
         * Use this property to acknowledge this limitation and still place the function in a public subnet.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://stackoverflow.com/questions/52992085/why-cant-an-aws-lambda-function-inside-a-public-subnet-in-a-vpc-connect-to-the/52994841#52994841">https://stackoverflow.com/questions/52992085/why-cant-an-aws-lambda-function-inside-a-public-subnet-in-a-vpc-connect-to-the/52994841#52994841</a>
         * @param allowPublicSubnet Lambda Functions in a public subnet can NOT access the internet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowPublicSubnet(final java.lang.Boolean allowPublicSubnet) {
            this.props.allowPublicSubnet(allowPublicSubnet);
            return this;
        }

        /**
         * The system architectures compatible with this lambda function.
         * <p>
         * Default: Architecture.X86_64
         * <p>
         * @return {@code this}
         * @param architecture The system architectures compatible with this lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architecture(final software.amazon.awscdk.services.lambda.Architecture architecture) {
            this.props.architecture(architecture);
            return this;
        }

        /**
         * (deprecated) DEPRECATED.
         * <p>
         * Default: [Architecture.X86_64]
         * <p>
         * @return {@code this}
         * @deprecated use `architecture`
         * @param architectures DEPRECATED. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder architectures(final java.util.List<? extends software.amazon.awscdk.services.lambda.Architecture> architectures) {
            this.props.architectures(architectures);
            return this;
        }

        /**
         * Code signing config associated with this function.
         * <p>
         * Default: - Not Sign the Code
         * <p>
         * @return {@code this}
         * @param codeSigningConfig Code signing config associated with this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSigningConfig(final software.amazon.awscdk.services.lambda.ICodeSigningConfig codeSigningConfig) {
            this.props.codeSigningConfig(codeSigningConfig);
            return this;
        }

        /**
         * Options for the `lambda.Version` resource automatically created by the `fn.currentVersion` method.
         * <p>
         * Default: - default options as described in `VersionOptions`
         * <p>
         * @return {@code this}
         * @param currentVersionOptions Options for the `lambda.Version` resource automatically created by the `fn.currentVersion` method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentVersionOptions(final software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions) {
            this.props.currentVersionOptions(currentVersionOptions);
            return this;
        }

        /**
         * The SQS queue to use if DLQ is enabled.
         * <p>
         * If SNS topic is desired, specify <code>deadLetterTopic</code> property instead.
         * <p>
         * Default: - SQS queue with 14 day retention period if `deadLetterQueueEnabled` is `true`
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to use if DLQ is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * Enabled DLQ.
         * <p>
         * If <code>deadLetterQueue</code> is undefined,
         * an SQS queue with default options will be defined for your Function.
         * <p>
         * Default: - false unless `deadLetterQueue` is set, which implies DLQ is enabled.
         * <p>
         * @return {@code this}
         * @param deadLetterQueueEnabled Enabled DLQ. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueueEnabled(final java.lang.Boolean deadLetterQueueEnabled) {
            this.props.deadLetterQueueEnabled(deadLetterQueueEnabled);
            return this;
        }

        /**
         * The SNS topic to use as a DLQ.
         * <p>
         * Note that if <code>deadLetterQueueEnabled</code> is set to <code>true</code>, an SQS queue will be created
         * rather than an SNS topic. Using an SNS topic as a DLQ requires this property to be set explicitly.
         * <p>
         * Default: - no SNS topic
         * <p>
         * @return {@code this}
         * @param deadLetterTopic The SNS topic to use as a DLQ. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterTopic(final software.amazon.awscdk.services.sns.ITopic deadLetterTopic) {
            this.props.deadLetterTopic(deadLetterTopic);
            return this;
        }

        /**
         * A description of the function.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Key-value pairs that Lambda caches and makes available for your Lambda functions.
         * <p>
         * Use environment variables to apply configuration changes, such
         * as test and production environment configurations, without changing your
         * Lambda function source code.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param environment Key-value pairs that Lambda caches and makes available for your Lambda functions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * The AWS KMS key that's used to encrypt your function's environment variables.
         * <p>
         * Default: - AWS Lambda creates and uses an AWS managed customer master key (CMK).
         * <p>
         * @return {@code this}
         * @param environmentEncryption The AWS KMS key that's used to encrypt your function's environment variables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentEncryption(final software.amazon.awscdk.services.kms.IKey environmentEncryption) {
            this.props.environmentEncryption(environmentEncryption);
            return this;
        }

        /**
         * The size of the function’s /tmp directory in MiB.
         * <p>
         * Default: 512 MiB
         * <p>
         * @return {@code this}
         * @param ephemeralStorageSize The size of the function’s /tmp directory in MiB. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageSize(final software.amazon.awscdk.core.Size ephemeralStorageSize) {
            this.props.ephemeralStorageSize(ephemeralStorageSize);
            return this;
        }

        /**
         * Event sources for this function.
         * <p>
         * You can also add event sources using <code>addEventSource</code>.
         * <p>
         * Default: - No event sources.
         * <p>
         * @return {@code this}
         * @param events Event sources for this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final java.util.List<? extends software.amazon.awscdk.services.lambda.IEventSource> events) {
            this.props.events(events);
            return this;
        }

        /**
         * The filesystem configuration for the lambda function.
         * <p>
         * Default: - will not mount any filesystem
         * <p>
         * @return {@code this}
         * @param filesystem The filesystem configuration for the lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filesystem(final software.amazon.awscdk.services.lambda.FileSystem filesystem) {
            this.props.filesystem(filesystem);
            return this;
        }

        /**
         * A name for the function.
         * <p>
         * Default: - AWS CloudFormation generates a unique physical ID and uses that
         * ID for the function's name. For more information, see Name Type.
         * <p>
         * @return {@code this}
         * @param functionName A name for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(final java.lang.String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        /**
         * Initial policy statements to add to the created Lambda Role.
         * <p>
         * You can call <code>addToRolePolicy</code> to the created lambda to add statements post creation.
         * <p>
         * Default: - No policy statements are added to the created Lambda role.
         * <p>
         * @return {@code this}
         * @param initialPolicy Initial policy statements to add to the created Lambda Role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialPolicy(final java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy) {
            this.props.initialPolicy(initialPolicy);
            return this;
        }

        /**
         * Specify the version of CloudWatch Lambda insights to use for monitoring.
         * <p>
         * Default: - No Lambda Insights
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-Getting-Started-docker.html">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-Getting-Started-docker.html</a>
         * @param insightsVersion Specify the version of CloudWatch Lambda insights to use for monitoring. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightsVersion(final software.amazon.awscdk.services.lambda.LambdaInsightsVersion insightsVersion) {
            this.props.insightsVersion(insightsVersion);
            return this;
        }

        /**
         * A list of layers to add to the function's execution environment.
         * <p>
         * You can configure your Lambda function to pull in
         * additional code during initialization in the form of layers. Layers are packages of libraries or other dependencies
         * that can be used by multiple functions.
         * <p>
         * Default: - No layers.
         * <p>
         * @return {@code this}
         * @param layers A list of layers to add to the function's execution environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layers(final java.util.List<? extends software.amazon.awscdk.services.lambda.ILayerVersion> layers) {
            this.props.layers(layers);
            return this;
        }

        /**
         * The number of days log events are kept in CloudWatch Logs.
         * <p>
         * When updating
         * this property, unsetting it doesn't remove the log retention policy. To
         * remove the retention policy, set the value to <code>INFINITE</code>.
         * <p>
         * Default: logs.RetentionDays.INFINITE
         * <p>
         * @return {@code this}
         * @param logRetention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(final software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.props.logRetention(logRetention);
            return this;
        }

        /**
         * When log retention is specified, a custom resource attempts to create the CloudWatch log group.
         * <p>
         * These options control the retry policy when interacting with CloudWatch APIs.
         * <p>
         * Default: - Default AWS SDK retry options.
         * <p>
         * @return {@code this}
         * @param logRetentionRetryOptions When log retention is specified, a custom resource attempts to create the CloudWatch log group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRetryOptions(final software.amazon.awscdk.services.lambda.LogRetentionRetryOptions logRetentionRetryOptions) {
            this.props.logRetentionRetryOptions(logRetentionRetryOptions);
            return this;
        }

        /**
         * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * <p>
         * Default: - A new role is created.
         * <p>
         * @return {@code this}
         * @param logRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRole(final software.amazon.awscdk.services.iam.IRole logRetentionRole) {
            this.props.logRetentionRole(logRetentionRole);
            return this;
        }

        /**
         * The amount of memory, in MB, that is allocated to your Lambda function.
         * <p>
         * Lambda uses this value to proportionally allocate the amount of CPU
         * power. For more information, see Resource Model in the AWS Lambda
         * Developer Guide.
         * <p>
         * Default: 128
         * <p>
         * @return {@code this}
         * @param memorySize The amount of memory, in MB, that is allocated to your Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(final java.lang.Number memorySize) {
            this.props.memorySize(memorySize);
            return this;
        }

        /**
         * Enable profiling.
         * <p>
         * Default: - No profiling.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html">https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html</a>
         * @param profiling Enable profiling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profiling(final java.lang.Boolean profiling) {
            this.props.profiling(profiling);
            return this;
        }

        /**
         * Profiling Group.
         * <p>
         * Default: - A new profiling group will be created if `profiling` is set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html">https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html</a>
         * @param profilingGroup Profiling Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profilingGroup(final software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup profilingGroup) {
            this.props.profilingGroup(profilingGroup);
            return this;
        }

        /**
         * The maximum of concurrent executions you want to reserve for the function.
         * <p>
         * Default: - No specific limit - account limit.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html</a>
         * @param reservedConcurrentExecutions The maximum of concurrent executions you want to reserve for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reservedConcurrentExecutions(final java.lang.Number reservedConcurrentExecutions) {
            this.props.reservedConcurrentExecutions(reservedConcurrentExecutions);
            return this;
        }

        /**
         * Lambda execution role.
         * <p>
         * This is the role that will be assumed by the function upon execution.
         * It controls the permissions that the function will have. The Role must
         * be assumable by the 'lambda.amazonaws.com' service principal.
         * <p>
         * The default Role automatically has permissions granted for Lambda execution. If you
         * provide a Role, you must add the relevant AWS managed policies yourself.
         * <p>
         * The relevant managed policies are "service-role/AWSLambdaBasicExecutionRole" and
         * "service-role/AWSLambdaVPCAccessExecutionRole".
         * <p>
         * Default: - A unique role will be generated for this lambda function.
         * Both supplied and generated roles can always be changed by calling `addToRolePolicy`.
         * <p>
         * @return {@code this}
         * @param role Lambda execution role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (deprecated) What security group to associate with the Lambda's network interfaces. This property is being deprecated, consider using securityGroups instead.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Use securityGroups property instead.
         * Function constructor will throw an error if both are specified.
         * <p>
         * Default: - If the function is placed within a VPC and a security group is
         * not specified, either by this or securityGroups prop, a dedicated security
         * group will be created for this function.
         * <p>
         * @return {@code this}
         * @deprecated - This property is deprecated, use securityGroups instead
         * @param securityGroup What security group to associate with the Lambda's network interfaces. This property is being deprecated, consider using securityGroups instead. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * The list of security groups to associate with the Lambda's network interfaces.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: - If the function is placed within a VPC and a security group is
         * not specified, either by this or securityGroup prop, a dedicated security
         * group will be created for this function.
         * <p>
         * @return {@code this}
         * @param securityGroups The list of security groups to associate with the Lambda's network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * The function execution time (in seconds) after which Lambda terminates the function.
         * <p>
         * Because the execution time affects cost, set this value
         * based on the function's expected execution time.
         * <p>
         * Default: Duration.seconds(3)
         * <p>
         * @return {@code this}
         * @param timeout The function execution time (in seconds) after which Lambda terminates the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.core.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * Enable AWS X-Ray Tracing for Lambda Function.
         * <p>
         * Default: Tracing.Disabled
         * <p>
         * @return {@code this}
         * @param tracing Enable AWS X-Ray Tracing for Lambda Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(final software.amazon.awscdk.services.lambda.Tracing tracing) {
            this.props.tracing(tracing);
            return this;
        }

        /**
         * VPC network to place Lambda network interfaces.
         * <p>
         * Specify this if the Lambda function needs to access resources in a VPC.
         * <p>
         * Default: - Function is not placed within a VPC.
         * <p>
         * @return {@code this}
         * @param vpc VPC network to place Lambda network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Where to place the network interfaces within the VPC.
         * <p>
         * Only used if 'vpc' is supplied. Note: internet access for Lambdas
         * requires a NAT gateway, so picking Public subnets is not allowed.
         * <p>
         * Default: - the Vpc default strategy if not specified
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place the network interfaces within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * (experimental) Path to the source of the function or the location for dependencies.
         * <p>
         * @return {@code this}
         * @param entry Path to the source of the function or the location for dependencies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder entry(final java.lang.String entry) {
            this.props.entry(entry);
            return this;
        }

        /**
         * (experimental) The runtime environment.
         * <p>
         * Only runtimes of the Python family are
         * supported.
         * <p>
         * Default: Runtime.PYTHON_3_7
         * <p>
         * @return {@code this}
         * @param runtime The runtime environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runtime(final software.amazon.awscdk.services.lambda.Runtime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        /**
         * (experimental) Bundling options to use for this function.
         * <p>
         * Use this to specify custom bundling options like
         * the bundling Docker image, asset hash type, custom hash, architecture, etc.
         * <p>
         * Default: - Use the default bundling Docker image, with x86_64 architecture.
         * <p>
         * @return {@code this}
         * @param bundling Bundling options to use for this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bundling(final software.amazon.awscdk.services.lambda.python.BundlingOptions bundling) {
            this.props.bundling(bundling);
            return this;
        }

        /**
         * (experimental) The name of the exported handler in the index file.
         * <p>
         * Default: handler
         * <p>
         * @return {@code this}
         * @param handler The name of the exported handler in the index file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder handler(final java.lang.String handler) {
            this.props.handler(handler);
            return this;
        }

        /**
         * (experimental) The path (relative to entry) to the index file containing the exported handler.
         * <p>
         * Default: index.py
         * <p>
         * @return {@code this}
         * @param index The path (relative to entry) to the index file containing the exported handler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder index(final java.lang.String index) {
            this.props.index(index);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.python.PythonFunction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.lambda.python.PythonFunction build() {
            return new software.amazon.awscdk.services.lambda.python.PythonFunction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
