/**
 * <h2>Amazon Lambda Python Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development. They are subject to non-backward compatible changes or removal in any future version. These are not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be announced in the release notes. This means that while you may use them, you may need to update your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This library provides constructs for Python Lambda functions.
 * <p>
 * To use this module, you will need to have Docker installed.
 * <p>
 * <h3>Python Function</h3>
 * <p>
 * Define a <code>PythonFunction</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.lambda.python.PythonFunction;
 * 
 * new PythonFunction(this, "MyFunction", new PythonFunctionProps()
 *         .entry("/path/to/my/function")// required
 *         .index("my_index.py")// optional, defaults to 'index.py'
 *         .handler("my_exported_func")// optional, defaults to 'handler'
 *         .runtime(lambda.Runtime.getPYTHON_3_6()));
 * </pre></blockquote>
 * <p>
 * All other properties of <code>lambda.Function</code> are supported, see also the <a href="https://github.com/aws/aws-cdk/tree/master/packages/%40aws-cdk/aws-lambda">AWS Lambda construct library</a>.
 * <p>
 * <h3>Module Dependencies</h3>
 * <p>
 * If <code>requirements.txt</code> exists at the entry path, the construct will handle installing
 * all required modules in a <a href="https://hub.docker.com/r/amazon/aws-sam-cli-build-image-python3.7">Lambda compatible Docker container</a>
 * according to the <code>runtime</code>.
 * <p>
 * <blockquote><pre>
 * .
 * ├── lambda_function.py # exports a function named 'handler'
 * ├── requirements.txt # has to be present at the entry path
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.lambda.python;
