/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricCustomization;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.events.EventRuleTargetProps;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.lambda.;
import software.amazon.awscdk.services.lambda.CommonPipelineInvokeActionProps;
import software.amazon.awscdk.services.lambda.FunctionImportProps;
import software.amazon.awscdk.services.lambda.IEventSource;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.lambda.Permission;
import software.amazon.awscdk.services.lambda.PipelineInvokeAction;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.awscdk.services.logs.LogSubscriptionDestination;
import software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationProps;
import software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskResourceProps;
import software.amazon.awscdk.services.stepfunctions.Task;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiObject;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-lambda.FunctionBase")
public abstract class FunctionBase
extends Construct
implements IFunction {
    protected FunctionBase(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    @Override
    public void addEventSource(IEventSource source) {
        this.jsiiCall("addEventSource", Void.class, Stream.of(Objects.requireNonNull(source, "source is required")).toArray());
    }

    @Override
    public void addPermission(String id, Permission permission) {
        this.jsiiCall("addPermission", Void.class, Stream.concat(Stream.of(Objects.requireNonNull(id, "id is required")), Stream.of(Objects.requireNonNull(permission, "permission is required"))).toArray());
    }

    @Override
    public void addToRolePolicy(PolicyStatement statement) {
        this.jsiiCall("addToRolePolicy", Void.class, Stream.of(Objects.requireNonNull(statement, "statement is required")).toArray());
    }

    public BucketNotificationDestinationProps asBucketNotificationDestination(String bucketArn, String bucketId) {
        return (BucketNotificationDestinationProps)this.jsiiCall("asBucketNotificationDestination", BucketNotificationDestinationProps.class, Stream.concat(Stream.of(Objects.requireNonNull(bucketArn, "bucketArn is required")), Stream.of(Objects.requireNonNull(bucketId, "bucketId is required"))).toArray());
    }

    public EventRuleTargetProps asEventRuleTarget(String ruleArn, String ruleId) {
        return (EventRuleTargetProps)this.jsiiCall("asEventRuleTarget", EventRuleTargetProps.class, Stream.concat(Stream.of(Objects.requireNonNull(ruleArn, "ruleArn is required")), Stream.of(Objects.requireNonNull(ruleId, "ruleId is required"))).toArray());
    }

    public StepFunctionsTaskResourceProps asStepFunctionsTaskResource(Task _callingTask) {
        return (StepFunctionsTaskResourceProps)this.jsiiCall("asStepFunctionsTaskResource", StepFunctionsTaskResourceProps.class, Stream.of(Objects.requireNonNull(_callingTask, "_callingTask is required")).toArray());
    }

    @Override
    public abstract FunctionImportProps export();

    @Override
    public void grantInvoke(@Nullable IPrincipal identity) {
        this.jsiiCall("grantInvoke", Void.class, Stream.of(identity).toArray());
    }

    @Override
    public void grantInvoke() {
        this.jsiiCall("grantInvoke", Void.class, new Object[0]);
    }

    public LogSubscriptionDestination logSubscriptionDestination(ILogGroup sourceLogGroup) {
        return (LogSubscriptionDestination)this.jsiiCall("logSubscriptionDestination", LogSubscriptionDestination.class, Stream.of(Objects.requireNonNull(sourceLogGroup, "sourceLogGroup is required")).toArray());
    }

    @Override
    public Metric metric(String metricName, @Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metric", Metric.class, Stream.concat(Stream.of(Objects.requireNonNull(metricName, "metricName is required")), Stream.of(props)).toArray());
    }

    @Override
    public Metric metric(String metricName) {
        return (Metric)this.jsiiCall("metric", Metric.class, Stream.of(Objects.requireNonNull(metricName, "metricName is required")).toArray());
    }

    @Override
    public Metric metricDuration(@Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metricDuration", Metric.class, Stream.of(props).toArray());
    }

    @Override
    public Metric metricDuration() {
        return (Metric)this.jsiiCall("metricDuration", Metric.class, new Object[0]);
    }

    @Override
    public Metric metricErrors(@Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metricErrors", Metric.class, Stream.of(props).toArray());
    }

    @Override
    public Metric metricErrors() {
        return (Metric)this.jsiiCall("metricErrors", Metric.class, new Object[0]);
    }

    @Override
    public Metric metricInvocations(@Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metricInvocations", Metric.class, Stream.of(props).toArray());
    }

    @Override
    public Metric metricInvocations() {
        return (Metric)this.jsiiCall("metricInvocations", Metric.class, new Object[0]);
    }

    @Override
    public Metric metricThrottles(@Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metricThrottles", Metric.class, Stream.of(props).toArray());
    }

    @Override
    public Metric metricThrottles() {
        return (Metric)this.jsiiCall("metricThrottles", Metric.class, new Object[0]);
    }

    @Override
    public PipelineInvokeAction toCodePipelineInvokeAction(CommonPipelineInvokeActionProps props) {
        return (PipelineInvokeAction)((Object)this.jsiiCall("toCodePipelineInvokeAction", PipelineInvokeAction.class, Stream.of(Objects.requireNonNull(props, "props is required")).toArray()));
    }

    protected Boolean getCanCreatePermissions() {
        return (Boolean)this.jsiiGet("canCreatePermissions", Boolean.class);
    }

    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @Override
    public String getFunctionArn() {
        return (String)this.jsiiGet("functionArn", String.class);
    }

    @Override
    public String getFunctionName() {
        return (String)this.jsiiGet("functionName", String.class);
    }

    @Override
    public String getId() {
        return (String)this.jsiiGet("id", String.class);
    }

    @Override
    public Boolean getIsBoundToVpc() {
        return (Boolean)this.jsiiGet("isBoundToVpc", Boolean.class);
    }

    @Override
    @Nullable
    public IRole getRole() {
        return (IRole)this.jsiiGet("role", IRole.class);
    }
}

