/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpcNetwork;
import software.amazon.awscdk.services.ec2.VpcPlacementStrategy;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.lambda.Code;
import software.amazon.awscdk.services.lambda.IEventSource;
import software.amazon.awscdk.services.lambda.ILayerVersion;
import software.amazon.awscdk.services.lambda.Runtime;
import software.amazon.awscdk.services.lambda.Tracing;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.JsiiSerializable;

public interface FunctionProps
extends JsiiSerializable {
    public Code getCode();

    public void setCode(Code var1);

    public String getHandler();

    public void setHandler(String var1);

    public Runtime getRuntime();

    public void setRuntime(Runtime var1);

    public Boolean getAllowAllOutbound();

    public void setAllowAllOutbound(Boolean var1);

    public IQueue getDeadLetterQueue();

    public void setDeadLetterQueue(IQueue var1);

    public Boolean getDeadLetterQueueEnabled();

    public void setDeadLetterQueueEnabled(Boolean var1);

    public String getDescription();

    public void setDescription(String var1);

    public Map<String, Object> getEnvironment();

    public void setEnvironment(Map<String, Object> var1);

    public List<IEventSource> getEvents();

    public void setEvents(List<IEventSource> var1);

    public String getFunctionName();

    public void setFunctionName(String var1);

    public List<PolicyStatement> getInitialPolicy();

    public void setInitialPolicy(List<PolicyStatement> var1);

    public List<ILayerVersion> getLayers();

    public void setLayers(List<ILayerVersion> var1);

    public Number getMemorySize();

    public void setMemorySize(Number var1);

    public Number getReservedConcurrentExecutions();

    public void setReservedConcurrentExecutions(Number var1);

    public IRole getRole();

    public void setRole(IRole var1);

    public ISecurityGroup getSecurityGroup();

    public void setSecurityGroup(ISecurityGroup var1);

    public Number getTimeout();

    public void setTimeout(Number var1);

    public Tracing getTracing();

    public void setTracing(Tracing var1);

    public IVpcNetwork getVpc();

    public void setVpc(IVpcNetwork var1);

    public VpcPlacementStrategy getVpcPlacement();

    public void setVpcPlacement(VpcPlacementStrategy var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Code _code;
        private String _handler;
        private Runtime _runtime;
        @Nullable
        private Boolean _allowAllOutbound;
        @Nullable
        private IQueue _deadLetterQueue;
        @Nullable
        private Boolean _deadLetterQueueEnabled;
        @Nullable
        private String _description;
        @Nullable
        private Map<String, Object> _environment;
        @Nullable
        private List<IEventSource> _events;
        @Nullable
        private String _functionName;
        @Nullable
        private List<PolicyStatement> _initialPolicy;
        @Nullable
        private List<ILayerVersion> _layers;
        @Nullable
        private Number _memorySize;
        @Nullable
        private Number _reservedConcurrentExecutions;
        @Nullable
        private IRole _role;
        @Nullable
        private ISecurityGroup _securityGroup;
        @Nullable
        private Number _timeout;
        @Nullable
        private Tracing _tracing;
        @Nullable
        private IVpcNetwork _vpc;
        @Nullable
        private VpcPlacementStrategy _vpcPlacement;

        public Builder withCode(Code value) {
            this._code = Objects.requireNonNull(value, "code is required");
            return this;
        }

        public Builder withHandler(String value) {
            this._handler = Objects.requireNonNull(value, "handler is required");
            return this;
        }

        public Builder withRuntime(Runtime value) {
            this._runtime = Objects.requireNonNull(value, "runtime is required");
            return this;
        }

        public Builder withAllowAllOutbound(@Nullable Boolean value) {
            this._allowAllOutbound = value;
            return this;
        }

        public Builder withDeadLetterQueue(@Nullable IQueue value) {
            this._deadLetterQueue = value;
            return this;
        }

        public Builder withDeadLetterQueueEnabled(@Nullable Boolean value) {
            this._deadLetterQueueEnabled = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withEnvironment(@Nullable Map<String, Object> value) {
            this._environment = value;
            return this;
        }

        public Builder withEvents(@Nullable List<IEventSource> value) {
            this._events = value;
            return this;
        }

        public Builder withFunctionName(@Nullable String value) {
            this._functionName = value;
            return this;
        }

        public Builder withInitialPolicy(@Nullable List<PolicyStatement> value) {
            this._initialPolicy = value;
            return this;
        }

        public Builder withLayers(@Nullable List<ILayerVersion> value) {
            this._layers = value;
            return this;
        }

        public Builder withMemorySize(@Nullable Number value) {
            this._memorySize = value;
            return this;
        }

        public Builder withReservedConcurrentExecutions(@Nullable Number value) {
            this._reservedConcurrentExecutions = value;
            return this;
        }

        public Builder withRole(@Nullable IRole value) {
            this._role = value;
            return this;
        }

        public Builder withSecurityGroup(@Nullable ISecurityGroup value) {
            this._securityGroup = value;
            return this;
        }

        public Builder withTimeout(@Nullable Number value) {
            this._timeout = value;
            return this;
        }

        public Builder withTracing(@Nullable Tracing value) {
            this._tracing = value;
            return this;
        }

        public Builder withVpc(@Nullable IVpcNetwork value) {
            this._vpc = value;
            return this;
        }

        public Builder withVpcPlacement(@Nullable VpcPlacementStrategy value) {
            this._vpcPlacement = value;
            return this;
        }

        public FunctionProps build() {
            return new FunctionProps(){
                private Code $code;
                private String $handler;
                private Runtime $runtime;
                @Nullable
                private Boolean $allowAllOutbound;
                @Nullable
                private IQueue $deadLetterQueue;
                @Nullable
                private Boolean $deadLetterQueueEnabled;
                @Nullable
                private String $description;
                @Nullable
                private Map<String, Object> $environment;
                @Nullable
                private List<IEventSource> $events;
                @Nullable
                private String $functionName;
                @Nullable
                private List<PolicyStatement> $initialPolicy;
                @Nullable
                private List<ILayerVersion> $layers;
                @Nullable
                private Number $memorySize;
                @Nullable
                private Number $reservedConcurrentExecutions;
                @Nullable
                private IRole $role;
                @Nullable
                private ISecurityGroup $securityGroup;
                @Nullable
                private Number $timeout;
                @Nullable
                private Tracing $tracing;
                @Nullable
                private IVpcNetwork $vpc;
                @Nullable
                private VpcPlacementStrategy $vpcPlacement;
                {
                    this.$code = Objects.requireNonNull(_code, "code is required");
                    this.$handler = Objects.requireNonNull(_handler, "handler is required");
                    this.$runtime = Objects.requireNonNull(_runtime, "runtime is required");
                    this.$allowAllOutbound = _allowAllOutbound;
                    this.$deadLetterQueue = _deadLetterQueue;
                    this.$deadLetterQueueEnabled = _deadLetterQueueEnabled;
                    this.$description = _description;
                    this.$environment = _environment;
                    this.$events = _events;
                    this.$functionName = _functionName;
                    this.$initialPolicy = _initialPolicy;
                    this.$layers = _layers;
                    this.$memorySize = _memorySize;
                    this.$reservedConcurrentExecutions = _reservedConcurrentExecutions;
                    this.$role = _role;
                    this.$securityGroup = _securityGroup;
                    this.$timeout = _timeout;
                    this.$tracing = _tracing;
                    this.$vpc = _vpc;
                    this.$vpcPlacement = _vpcPlacement;
                }

                @Override
                public Code getCode() {
                    return this.$code;
                }

                @Override
                public void setCode(Code value) {
                    this.$code = Objects.requireNonNull(value, "code is required");
                }

                @Override
                public String getHandler() {
                    return this.$handler;
                }

                @Override
                public void setHandler(String value) {
                    this.$handler = Objects.requireNonNull(value, "handler is required");
                }

                @Override
                public Runtime getRuntime() {
                    return this.$runtime;
                }

                @Override
                public void setRuntime(Runtime value) {
                    this.$runtime = Objects.requireNonNull(value, "runtime is required");
                }

                @Override
                public Boolean getAllowAllOutbound() {
                    return this.$allowAllOutbound;
                }

                @Override
                public void setAllowAllOutbound(@Nullable Boolean value) {
                    this.$allowAllOutbound = value;
                }

                @Override
                public IQueue getDeadLetterQueue() {
                    return this.$deadLetterQueue;
                }

                @Override
                public void setDeadLetterQueue(@Nullable IQueue value) {
                    this.$deadLetterQueue = value;
                }

                @Override
                public Boolean getDeadLetterQueueEnabled() {
                    return this.$deadLetterQueueEnabled;
                }

                @Override
                public void setDeadLetterQueueEnabled(@Nullable Boolean value) {
                    this.$deadLetterQueueEnabled = value;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public void setDescription(@Nullable String value) {
                    this.$description = value;
                }

                @Override
                public Map<String, Object> getEnvironment() {
                    return this.$environment;
                }

                @Override
                public void setEnvironment(@Nullable Map<String, Object> value) {
                    this.$environment = value;
                }

                @Override
                public List<IEventSource> getEvents() {
                    return this.$events;
                }

                @Override
                public void setEvents(@Nullable List<IEventSource> value) {
                    this.$events = value;
                }

                @Override
                public String getFunctionName() {
                    return this.$functionName;
                }

                @Override
                public void setFunctionName(@Nullable String value) {
                    this.$functionName = value;
                }

                @Override
                public List<PolicyStatement> getInitialPolicy() {
                    return this.$initialPolicy;
                }

                @Override
                public void setInitialPolicy(@Nullable List<PolicyStatement> value) {
                    this.$initialPolicy = value;
                }

                @Override
                public List<ILayerVersion> getLayers() {
                    return this.$layers;
                }

                @Override
                public void setLayers(@Nullable List<ILayerVersion> value) {
                    this.$layers = value;
                }

                @Override
                public Number getMemorySize() {
                    return this.$memorySize;
                }

                @Override
                public void setMemorySize(@Nullable Number value) {
                    this.$memorySize = value;
                }

                @Override
                public Number getReservedConcurrentExecutions() {
                    return this.$reservedConcurrentExecutions;
                }

                @Override
                public void setReservedConcurrentExecutions(@Nullable Number value) {
                    this.$reservedConcurrentExecutions = value;
                }

                @Override
                public IRole getRole() {
                    return this.$role;
                }

                @Override
                public void setRole(@Nullable IRole value) {
                    this.$role = value;
                }

                @Override
                public ISecurityGroup getSecurityGroup() {
                    return this.$securityGroup;
                }

                @Override
                public void setSecurityGroup(@Nullable ISecurityGroup value) {
                    this.$securityGroup = value;
                }

                @Override
                public Number getTimeout() {
                    return this.$timeout;
                }

                @Override
                public void setTimeout(@Nullable Number value) {
                    this.$timeout = value;
                }

                @Override
                public Tracing getTracing() {
                    return this.$tracing;
                }

                @Override
                public void setTracing(@Nullable Tracing value) {
                    this.$tracing = value;
                }

                @Override
                public IVpcNetwork getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(@Nullable IVpcNetwork value) {
                    this.$vpc = value;
                }

                @Override
                public VpcPlacementStrategy getVpcPlacement() {
                    return this.$vpcPlacement;
                }

                @Override
                public void setVpcPlacement(@Nullable VpcPlacementStrategy value) {
                    this.$vpcPlacement = value;
                }
            };
        }
    }
}

