package software.amazon.awscdk.services.lambda;

/**
 * Properties for a new Lambda alias
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.887Z")
public interface AliasProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Name of this alias
     */
    java.lang.String getAliasName();
    /**
     * Function version this alias refers to
     * 
     * Use lambda.addVersion() to obtain a new lambda version to refer to.
     */
    software.amazon.awscdk.services.lambda.Version getVersion();
    /**
     * Additional versions with individual weights this alias points to
     * 
     * Individual additional version weights specified here should add up to
     * (less than) one. All remaining weight is routed to the default
     * version.
     * 
     * For example, the config is
     * 
     *     version: "1"
     *     additionalVersions: [{ version: "2", weight: 0.05 }]
     * 
     * Then 5% of traffic will be routed to function version 2, while
     * the remaining 95% of traffic will be routed to function version 1.
     * @default No additional versions
     */
    java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> getAdditionalVersions();
    /**
     * Description for the alias
     * @default No description
     */
    java.lang.String getDescription();

    /**
     * @return a {@link Builder} of {@link AliasProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AliasProps}
     */
    final class Builder {
        private java.lang.String _aliasName;
        private software.amazon.awscdk.services.lambda.Version _version;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> _additionalVersions;
        @javax.annotation.Nullable
        private java.lang.String _description;

        /**
         * Sets the value of AliasName
         * @param value Name of this alias
         * @return {@code this}
         */
        public Builder withAliasName(final java.lang.String value) {
            this._aliasName = java.util.Objects.requireNonNull(value, "aliasName is required");
            return this;
        }
        /**
         * Sets the value of Version
         * @param value Function version this alias refers to

Use lambda.addVersion() to obtain a new lambda version to refer to.
         * @return {@code this}
         */
        public Builder withVersion(final software.amazon.awscdk.services.lambda.Version value) {
            this._version = java.util.Objects.requireNonNull(value, "version is required");
            return this;
        }
        /**
         * Sets the value of AdditionalVersions
         * @param value Additional versions with individual weights this alias points to

Individual additional version weights specified here should add up to
(less than) one. All remaining weight is routed to the default
version.

For example, the config is

    version: "1"
    additionalVersions: [{ version: "2", weight: 0.05 }]

Then 5% of traffic will be routed to function version 2, while
the remaining 95% of traffic will be routed to function version 1.
         * @return {@code this}
         */
        public Builder withAdditionalVersions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> value) {
            this._additionalVersions = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value Description for the alias
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AliasProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public AliasProps build() {
            return new AliasProps() {
                private final java.lang.String $aliasName = java.util.Objects.requireNonNull(_aliasName, "aliasName is required");
                private final software.amazon.awscdk.services.lambda.Version $version = java.util.Objects.requireNonNull(_version, "version is required");
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> $additionalVersions = _additionalVersions;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;

                @Override
                public java.lang.String getAliasName() {
                    return this.$aliasName;
                }

                @Override
                public software.amazon.awscdk.services.lambda.Version getVersion() {
                    return this.$version;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> getAdditionalVersions() {
                    return this.$additionalVersions;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("aliasName", om.valueToTree(this.getAliasName()));
                    obj.set("version", om.valueToTree(this.getVersion()));
                    obj.set("additionalVersions", om.valueToTree(this.getAdditionalVersions()));
                    obj.set("description", om.valueToTree(this.getDescription()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.AliasProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Name of this alias
         */
        @Override
        public java.lang.String getAliasName() {
            return this.jsiiGet("aliasName", java.lang.String.class);
        }

        /**
         * Function version this alias refers to
         * 
         * Use lambda.addVersion() to obtain a new lambda version to refer to.
         */
        @Override
        public software.amazon.awscdk.services.lambda.Version getVersion() {
            return this.jsiiGet("version", software.amazon.awscdk.services.lambda.Version.class);
        }

        /**
         * Additional versions with individual weights this alias points to
         * 
         * Individual additional version weights specified here should add up to
         * (less than) one. All remaining weight is routed to the default
         * version.
         * 
         * For example, the config is
         * 
         *     version: "1"
         *     additionalVersions: [{ version: "2", weight: 0.05 }]
         * 
         * Then 5% of traffic will be routed to function version 2, while
         * the remaining 95% of traffic will be routed to function version 1.
         * @default No additional versions
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> getAdditionalVersions() {
            return this.jsiiGet("additionalVersions", java.util.List.class);
        }

        /**
         * Description for the alias
         * @default No description
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }
    }
}
