package software.amazon.awscdk.services.lambda;

/**
 * @cloudformationResource AWS::Lambda::Function
 * A CloudFormation `AWS::Lambda::Function`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.893Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnFunction")
public class CfnFunction extends software.amazon.awscdk.CfnResource {
    protected CfnFunction(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.CfnFunction.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::Lambda::Function`.
     * @param scope - scope in which this resource is defined
     * @param id - scoped id of the resource
     * @param props - resource properties
     */
    public CfnFunction(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.CfnFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    /**
     * @cloudformationAttribute Arn
     */
    public java.lang.String getFunctionArn() {
        return this.jsiiGet("functionArn", java.lang.String.class);
    }

    public java.lang.String getFunctionName() {
        return this.jsiiGet("functionName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.lambda.CfnFunctionProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.lambda.CfnFunctionProps.class);
    }

    /**
     * The `TagManager` handles setting, removing and formatting tags
     * 
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. `Tag` (aspect)
     * will use the manager.
     */
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html
     */
    public static interface CodeProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.CodeProperty.S3Bucket`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3bucket
         */
        java.lang.String getS3Bucket();
        /**
         * `CfnFunction.CodeProperty.S3Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3key
         */
        java.lang.String getS3Key();
        /**
         * `CfnFunction.CodeProperty.S3ObjectVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3objectversion
         */
        java.lang.String getS3ObjectVersion();
        /**
         * `CfnFunction.CodeProperty.ZipFile`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-zipfile
         */
        java.lang.String getZipFile();

        /**
         * @return a {@link Builder} of {@link CodeProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CodeProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _s3Bucket;
            @javax.annotation.Nullable
            private java.lang.String _s3Key;
            @javax.annotation.Nullable
            private java.lang.String _s3ObjectVersion;
            @javax.annotation.Nullable
            private java.lang.String _zipFile;

            /**
             * Sets the value of S3Bucket
             * @param value `CfnFunction.CodeProperty.S3Bucket`
             * @return {@code this}
             */
            public Builder withS3Bucket(@javax.annotation.Nullable final java.lang.String value) {
                this._s3Bucket = value;
                return this;
            }
            /**
             * Sets the value of S3Key
             * @param value `CfnFunction.CodeProperty.S3Key`
             * @return {@code this}
             */
            public Builder withS3Key(@javax.annotation.Nullable final java.lang.String value) {
                this._s3Key = value;
                return this;
            }
            /**
             * Sets the value of S3ObjectVersion
             * @param value `CfnFunction.CodeProperty.S3ObjectVersion`
             * @return {@code this}
             */
            public Builder withS3ObjectVersion(@javax.annotation.Nullable final java.lang.String value) {
                this._s3ObjectVersion = value;
                return this;
            }
            /**
             * Sets the value of ZipFile
             * @param value `CfnFunction.CodeProperty.ZipFile`
             * @return {@code this}
             */
            public Builder withZipFile(@javax.annotation.Nullable final java.lang.String value) {
                this._zipFile = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CodeProperty build() {
                return new CodeProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $s3Bucket = _s3Bucket;
                    @javax.annotation.Nullable
                    private final java.lang.String $s3Key = _s3Key;
                    @javax.annotation.Nullable
                    private final java.lang.String $s3ObjectVersion = _s3ObjectVersion;
                    @javax.annotation.Nullable
                    private final java.lang.String $zipFile = _zipFile;

                    @Override
                    public java.lang.String getS3Bucket() {
                        return this.$s3Bucket;
                    }

                    @Override
                    public java.lang.String getS3Key() {
                        return this.$s3Key;
                    }

                    @Override
                    public java.lang.String getS3ObjectVersion() {
                        return this.$s3ObjectVersion;
                    }

                    @Override
                    public java.lang.String getZipFile() {
                        return this.$zipFile;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                        obj.set("s3Key", om.valueToTree(this.getS3Key()));
                        obj.set("s3ObjectVersion", om.valueToTree(this.getS3ObjectVersion()));
                        obj.set("zipFile", om.valueToTree(this.getZipFile()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.CfnFunction.CodeProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.CodeProperty.S3Bucket`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3bucket
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getS3Bucket() {
                return this.jsiiGet("s3Bucket", java.lang.String.class);
            }

            /**
             * `CfnFunction.CodeProperty.S3Key`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3key
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getS3Key() {
                return this.jsiiGet("s3Key", java.lang.String.class);
            }

            /**
             * `CfnFunction.CodeProperty.S3ObjectVersion`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3objectversion
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getS3ObjectVersion() {
                return this.jsiiGet("s3ObjectVersion", java.lang.String.class);
            }

            /**
             * `CfnFunction.CodeProperty.ZipFile`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-zipfile
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getZipFile() {
                return this.jsiiGet("zipFile", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-deadletterconfig.html
     */
    public static interface DeadLetterConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.DeadLetterConfigProperty.TargetArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-deadletterconfig.html#cfn-lambda-function-deadletterconfig-targetarn
         */
        java.lang.String getTargetArn();

        /**
         * @return a {@link Builder} of {@link DeadLetterConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DeadLetterConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _targetArn;

            /**
             * Sets the value of TargetArn
             * @param value `CfnFunction.DeadLetterConfigProperty.TargetArn`
             * @return {@code this}
             */
            public Builder withTargetArn(@javax.annotation.Nullable final java.lang.String value) {
                this._targetArn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeadLetterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DeadLetterConfigProperty build() {
                return new DeadLetterConfigProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $targetArn = _targetArn;

                    @Override
                    public java.lang.String getTargetArn() {
                        return this.$targetArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("targetArn", om.valueToTree(this.getTargetArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.CfnFunction.DeadLetterConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.DeadLetterConfigProperty.TargetArn`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-deadletterconfig.html#cfn-lambda-function-deadletterconfig-targetarn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getTargetArn() {
                return this.jsiiGet("targetArn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-environment.html
     */
    public static interface EnvironmentProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.EnvironmentProperty.Variables`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-environment.html#cfn-lambda-function-environment-variables
         */
        java.lang.Object getVariables();

        /**
         * @return a {@link Builder} of {@link EnvironmentProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EnvironmentProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _variables;

            /**
             * Sets the value of Variables
             * @param value `CfnFunction.EnvironmentProperty.Variables`
             * @return {@code this}
             */
            public Builder withVariables(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._variables = value;
                return this;
            }
            /**
             * Sets the value of Variables
             * @param value `CfnFunction.EnvironmentProperty.Variables`
             * @return {@code this}
             */
            public Builder withVariables(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._variables = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EnvironmentProperty build() {
                return new EnvironmentProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $variables = _variables;

                    @Override
                    public java.lang.Object getVariables() {
                        return this.$variables;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("variables", om.valueToTree(this.getVariables()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.CfnFunction.EnvironmentProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.EnvironmentProperty.Variables`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-environment.html#cfn-lambda-function-environment-variables
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVariables() {
                return this.jsiiGet("variables", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-tracingconfig.html
     */
    public static interface TracingConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.TracingConfigProperty.Mode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-tracingconfig.html#cfn-lambda-function-tracingconfig-mode
         */
        java.lang.String getMode();

        /**
         * @return a {@link Builder} of {@link TracingConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TracingConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _mode;

            /**
             * Sets the value of Mode
             * @param value `CfnFunction.TracingConfigProperty.Mode`
             * @return {@code this}
             */
            public Builder withMode(@javax.annotation.Nullable final java.lang.String value) {
                this._mode = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TracingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TracingConfigProperty build() {
                return new TracingConfigProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $mode = _mode;

                    @Override
                    public java.lang.String getMode() {
                        return this.$mode;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("mode", om.valueToTree(this.getMode()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.CfnFunction.TracingConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.TracingConfigProperty.Mode`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-tracingconfig.html#cfn-lambda-function-tracingconfig-mode
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getMode() {
                return this.jsiiGet("mode", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
     */
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.VpcConfigProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html#cfn-lambda-function-vpcconfig-securitygroupids
         */
        java.util.List<java.lang.String> getSecurityGroupIds();
        /**
         * `CfnFunction.VpcConfigProperty.SubnetIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html#cfn-lambda-function-vpcconfig-subnetids
         */
        java.util.List<java.lang.String> getSubnetIds();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VpcConfigProperty}
         */
        final class Builder {
            private java.util.List<java.lang.String> _securityGroupIds;
            private java.util.List<java.lang.String> _subnetIds;

            /**
             * Sets the value of SecurityGroupIds
             * @param value `CfnFunction.VpcConfigProperty.SecurityGroupIds`
             * @return {@code this}
             */
            public Builder withSecurityGroupIds(final java.util.List<java.lang.String> value) {
                this._securityGroupIds = java.util.Objects.requireNonNull(value, "securityGroupIds is required");
                return this;
            }
            /**
             * Sets the value of SubnetIds
             * @param value `CfnFunction.VpcConfigProperty.SubnetIds`
             * @return {@code this}
             */
            public Builder withSubnetIds(final java.util.List<java.lang.String> value) {
                this._subnetIds = java.util.Objects.requireNonNull(value, "subnetIds is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public VpcConfigProperty build() {
                return new VpcConfigProperty() {
                    private final java.util.List<java.lang.String> $securityGroupIds = java.util.Objects.requireNonNull(_securityGroupIds, "securityGroupIds is required");
                    private final java.util.List<java.lang.String> $subnetIds = java.util.Objects.requireNonNull(_subnetIds, "subnetIds is required");

                    @Override
                    public java.util.List<java.lang.String> getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public java.util.List<java.lang.String> getSubnetIds() {
                        return this.$subnetIds;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                        obj.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.CfnFunction.VpcConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.VpcConfigProperty.SecurityGroupIds`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html#cfn-lambda-function-vpcconfig-securitygroupids
             */
            @Override
            public java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.jsiiGet("securityGroupIds", java.util.List.class);
            }

            /**
             * `CfnFunction.VpcConfigProperty.SubnetIds`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html#cfn-lambda-function-vpcconfig-subnetids
             */
            @Override
            public java.util.List<java.lang.String> getSubnetIds() {
                return this.jsiiGet("subnetIds", java.util.List.class);
            }
        }
    }
}
