package software.amazon.awscdk.services.lambda;

/**
 * @cloudformationResource AWS::Lambda::LayerVersion
 * A CloudFormation `AWS::Lambda::LayerVersion`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.897Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnLayerVersion")
public class CfnLayerVersion extends software.amazon.awscdk.CfnResource {
    protected CfnLayerVersion(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.CfnLayerVersion.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::Lambda::LayerVersion`.
     * @param scope - scope in which this resource is defined
     * @param id - scoped id of the resource
     * @param props - resource properties
     */
    public CfnLayerVersion(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.CfnLayerVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getLayerVersionArn() {
        return this.jsiiGet("layerVersionArn", java.lang.String.class);
    }

    public software.amazon.awscdk.services.lambda.CfnLayerVersionProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.lambda.CfnLayerVersionProps.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html
     */
    public static interface ContentProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLayerVersion.ContentProperty.S3Bucket`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3bucket
         */
        java.lang.String getS3Bucket();
        /**
         * `CfnLayerVersion.ContentProperty.S3Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3key
         */
        java.lang.String getS3Key();
        /**
         * `CfnLayerVersion.ContentProperty.S3ObjectVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3objectversion
         */
        java.lang.String getS3ObjectVersion();

        /**
         * @return a {@link Builder} of {@link ContentProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ContentProperty}
         */
        final class Builder {
            private java.lang.String _s3Bucket;
            private java.lang.String _s3Key;
            @javax.annotation.Nullable
            private java.lang.String _s3ObjectVersion;

            /**
             * Sets the value of S3Bucket
             * @param value `CfnLayerVersion.ContentProperty.S3Bucket`
             * @return {@code this}
             */
            public Builder withS3Bucket(final java.lang.String value) {
                this._s3Bucket = java.util.Objects.requireNonNull(value, "s3Bucket is required");
                return this;
            }
            /**
             * Sets the value of S3Key
             * @param value `CfnLayerVersion.ContentProperty.S3Key`
             * @return {@code this}
             */
            public Builder withS3Key(final java.lang.String value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }
            /**
             * Sets the value of S3ObjectVersion
             * @param value `CfnLayerVersion.ContentProperty.S3ObjectVersion`
             * @return {@code this}
             */
            public Builder withS3ObjectVersion(@javax.annotation.Nullable final java.lang.String value) {
                this._s3ObjectVersion = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ContentProperty build() {
                return new ContentProperty() {
                    private final java.lang.String $s3Bucket = java.util.Objects.requireNonNull(_s3Bucket, "s3Bucket is required");
                    private final java.lang.String $s3Key = java.util.Objects.requireNonNull(_s3Key, "s3Key is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $s3ObjectVersion = _s3ObjectVersion;

                    @Override
                    public java.lang.String getS3Bucket() {
                        return this.$s3Bucket;
                    }

                    @Override
                    public java.lang.String getS3Key() {
                        return this.$s3Key;
                    }

                    @Override
                    public java.lang.String getS3ObjectVersion() {
                        return this.$s3ObjectVersion;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                        obj.set("s3Key", om.valueToTree(this.getS3Key()));
                        obj.set("s3ObjectVersion", om.valueToTree(this.getS3ObjectVersion()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.CfnLayerVersion.ContentProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLayerVersion.ContentProperty.S3Bucket`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3bucket
             */
            @Override
            public java.lang.String getS3Bucket() {
                return this.jsiiGet("s3Bucket", java.lang.String.class);
            }

            /**
             * `CfnLayerVersion.ContentProperty.S3Key`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3key
             */
            @Override
            public java.lang.String getS3Key() {
                return this.jsiiGet("s3Key", java.lang.String.class);
            }

            /**
             * `CfnLayerVersion.ContentProperty.S3ObjectVersion`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3objectversion
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getS3ObjectVersion() {
                return this.jsiiGet("s3ObjectVersion", java.lang.String.class);
            }
        }
    }
}
