package software.amazon.awscdk.services.lambda;

/**
 * Deploys a file from from inside the construct library as a function.
 * 
 * The supplied file is subject to the 4096 bytes limit of being embedded in a
 * CloudFormation template.
 * 
 * The construct includes an associated role with the lambda.
 * 
 * This construct does not yet reproduce all features from the underlying resource
 * library.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.902Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.Function")
public class Function extends software.amazon.awscdk.services.lambda.FunctionBase {
    protected Function(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Function(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.FunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Creates a Lambda function object which represents a function not defined
     * within this stack.
     * 
     *     Lambda.import(this, 'MyImportedFunction', { lambdaArn: new LambdaArn('arn:aws:...') });
     * @param id The name of the lambda construct
     * @param props A reference to a Lambda function. Can be created manually (see
example above) or obtained through a call to `lambda.export()`.
     */
    public static software.amazon.awscdk.services.lambda.IFunction import_(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.FunctionImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "import", software.amazon.awscdk.services.lambda.IFunction.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Return the given named metric for this Lambda
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAll(final java.lang.String metricName, @javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAll", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(metricName, "metricName is required")), java.util.stream.Stream.of(props)).toArray());
    }

    /**
     * Return the given named metric for this Lambda
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAll(final java.lang.String metricName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAll", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(metricName, "metricName is required")).toArray());
    }

    /**
     * Metric for the number of concurrent executions across all Lambdas
     * @default max over 5 minutes
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllConcurrentExecutions(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllConcurrentExecutions", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of concurrent executions across all Lambdas
     * @default max over 5 minutes
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllConcurrentExecutions() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllConcurrentExecutions", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the Duration executing all Lambdas
     * @default average over 5 minutes
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllDuration(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllDuration", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the Duration executing all Lambdas
     * @default average over 5 minutes
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllDuration() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllDuration", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of Errors executing all Lambdas
     * @default sum over 5 minutes
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllErrors(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllErrors", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of Errors executing all Lambdas
     * @default sum over 5 minutes
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllErrors() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllErrors", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of invocations of all Lambdas
     * @default sum over 5 minutes
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllInvocations(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllInvocations", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of invocations of all Lambdas
     * @default sum over 5 minutes
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllInvocations() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllInvocations", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of throttled invocations of all Lambdas
     * @default sum over 5 minutes
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllThrottles(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllThrottles", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of throttled invocations of all Lambdas
     * @default sum over 5 minutes
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllThrottles() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllThrottles", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of unreserved concurrent executions across all Lambdas
     * @default max over 5 minutes
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllUnreservedConcurrentExecutions(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllUnreservedConcurrentExecutions", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of unreserved concurrent executions across all Lambdas
     * @default max over 5 minutes
     */
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllUnreservedConcurrentExecutions() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllUnreservedConcurrentExecutions", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Adds an environment variable to this Lambda function.
     * If this is a ref to a Lambda function, this operation results in a no-op.
     * @param key The environment variable key.
     * @param value The environment variable's value.
     */
    public software.amazon.awscdk.services.lambda.Function addEnvironment(final java.lang.String key, final java.lang.Object value) {
        return this.jsiiCall("addEnvironment", software.amazon.awscdk.services.lambda.Function.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(key, "key is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(value, "value is required"))).toArray());
    }

    /**
     * Adds a Lambda Layer to this Lambda function.
     * @throws if there are already 5 layers on this function, or the layer is incompatible with this function's runtime.
     * @param layer the layer to be added.
     */
    public software.amazon.awscdk.services.lambda.Function addLayer(final software.amazon.awscdk.services.lambda.ILayerVersion layer) {
        return this.jsiiCall("addLayer", software.amazon.awscdk.services.lambda.Function.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(layer, "layer is required")).toArray());
    }

    /**
     * Add a new version for this Lambda
     * 
     * If you want to deploy through CloudFormation and use aliases, you need to
     * add a new version (with a new name) to your Lambda every time you want
     * to deploy an update. An alias can then refer to the newly created Version.
     * 
     * All versions should have distinct names, and you should not delete versions
     * as long as your Alias needs to refer to them.
     * @return A new Version object.
     * @param name A unique name for this version
     * @param codeSha256 The SHA-256 hash of the most recently deployed Lambda source code, or
omit to skip validation.
     * @param description A description for this version.
     */
    public software.amazon.awscdk.services.lambda.Version addVersion(final java.lang.String name, @javax.annotation.Nullable final java.lang.String codeSha256, @javax.annotation.Nullable final java.lang.String description) {
        return this.jsiiCall("addVersion", software.amazon.awscdk.services.lambda.Version.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(codeSha256)), java.util.stream.Stream.of(description)).toArray());
    }

    /**
     * Add a new version for this Lambda
     * 
     * If you want to deploy through CloudFormation and use aliases, you need to
     * add a new version (with a new name) to your Lambda every time you want
     * to deploy an update. An alias can then refer to the newly created Version.
     * 
     * All versions should have distinct names, and you should not delete versions
     * as long as your Alias needs to refer to them.
     * @return A new Version object.
     * @param name A unique name for this version
     * @param codeSha256 The SHA-256 hash of the most recently deployed Lambda source code, or
omit to skip validation.
     */
    public software.amazon.awscdk.services.lambda.Version addVersion(final java.lang.String name, @javax.annotation.Nullable final java.lang.String codeSha256) {
        return this.jsiiCall("addVersion", software.amazon.awscdk.services.lambda.Version.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(codeSha256)).toArray());
    }

    /**
     * Add a new version for this Lambda
     * 
     * If you want to deploy through CloudFormation and use aliases, you need to
     * add a new version (with a new name) to your Lambda every time you want
     * to deploy an update. An alias can then refer to the newly created Version.
     * 
     * All versions should have distinct names, and you should not delete versions
     * as long as your Alias needs to refer to them.
     * @return A new Version object.
     * @param name A unique name for this version
     */
    public software.amazon.awscdk.services.lambda.Version addVersion(final java.lang.String name) {
        return this.jsiiCall("addVersion", software.amazon.awscdk.services.lambda.Version.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")).toArray());
    }

    /**
     * Export this Function (without the role)
     */
    @Override
    public software.amazon.awscdk.services.lambda.FunctionImportProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.lambda.FunctionImportProps.class);
    }

    /**
     * Whether the addPermission() call adds any permissions
     * 
     * True for new Lambdas, false for imported Lambdas (they might live in different accounts).
     */
    @Override
    protected java.lang.Boolean getCanCreatePermissions() {
        return this.jsiiGet("canCreatePermissions", java.lang.Boolean.class);
    }

    /**
     * ARN of this function
     */
    @Override
    public java.lang.String getFunctionArn() {
        return this.jsiiGet("functionArn", java.lang.String.class);
    }

    /**
     * Name of this function
     */
    @Override
    public java.lang.String getFunctionName() {
        return this.jsiiGet("functionName", java.lang.String.class);
    }

    /**
     * The name of the handler configured for this lambda.
     */
    public java.lang.String getHandler() {
        return this.jsiiGet("handler", java.lang.String.class);
    }

    /**
     * The runtime configured for this lambda.
     */
    public software.amazon.awscdk.services.lambda.Runtime getRuntime() {
        return this.jsiiGet("runtime", software.amazon.awscdk.services.lambda.Runtime.class);
    }

    /**
     * Execution role associated with this function
     */
    @Override
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.iam.IRole getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
    }
}
