package software.amazon.awscdk.services.lambda;

/**
 * Represents a Lambda function defined outside of this stack.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.908Z")
public interface FunctionImportProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN of the Lambda function.
     * 
     * Format: arn:<partition>:lambda:<region>:<account-id>:function:<function-name>
     */
    java.lang.String getFunctionArn();
    /**
     * The IAM execution role associated with this function.
     * 
     * If the role is not specified, any role-related operations will no-op.
     */
    software.amazon.awscdk.services.iam.IRole getRole();
    /**
     * Id of the securityGroup for this Lambda, if in a VPC.
     * 
     * This needs to be given in order to support allowing connections
     * to this Lambda.
     */
    java.lang.String getSecurityGroupId();

    /**
     * @return a {@link Builder} of {@link FunctionImportProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link FunctionImportProps}
     */
    final class Builder {
        private java.lang.String _functionArn;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.IRole _role;
        @javax.annotation.Nullable
        private java.lang.String _securityGroupId;

        /**
         * Sets the value of FunctionArn
         * @param value The ARN of the Lambda function.

Format: arn:<partition>:lambda:<region>:<account-id>:function:<function-name>
         * @return {@code this}
         */
        public Builder withFunctionArn(final java.lang.String value) {
            this._functionArn = java.util.Objects.requireNonNull(value, "functionArn is required");
            return this;
        }
        /**
         * Sets the value of Role
         * @param value The IAM execution role associated with this function.

If the role is not specified, any role-related operations will no-op.
         * @return {@code this}
         */
        public Builder withRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IRole value) {
            this._role = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroupId
         * @param value Id of the securityGroup for this Lambda, if in a VPC.

This needs to be given in order to support allowing connections
to this Lambda.
         * @return {@code this}
         */
        public Builder withSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
            this._securityGroupId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FunctionImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public FunctionImportProps build() {
            return new FunctionImportProps() {
                private final java.lang.String $functionArn = java.util.Objects.requireNonNull(_functionArn, "functionArn is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.iam.IRole $role = _role;
                @javax.annotation.Nullable
                private final java.lang.String $securityGroupId = _securityGroupId;

                @Override
                public java.lang.String getFunctionArn() {
                    return this.$functionArn;
                }

                @Override
                public software.amazon.awscdk.services.iam.IRole getRole() {
                    return this.$role;
                }

                @Override
                public java.lang.String getSecurityGroupId() {
                    return this.$securityGroupId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("functionArn", om.valueToTree(this.getFunctionArn()));
                    obj.set("role", om.valueToTree(this.getRole()));
                    obj.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.FunctionImportProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the Lambda function.
         * 
         * Format: arn:<partition>:lambda:<region>:<account-id>:function:<function-name>
         */
        @Override
        public java.lang.String getFunctionArn() {
            return this.jsiiGet("functionArn", java.lang.String.class);
        }

        /**
         * The IAM execution role associated with this function.
         * 
         * If the role is not specified, any role-related operations will no-op.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
        }

        /**
         * Id of the securityGroup for this Lambda, if in a VPC.
         * 
         * This needs to be given in order to support allowing connections
         * to this Lambda.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getSecurityGroupId() {
            return this.jsiiGet("securityGroupId", java.lang.String.class);
        }
    }
}
