package software.amazon.awscdk.services.lambda;

/**
 * Identification of an account (or organization) that is allowed to access a Lambda Layer Version.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.915Z")
public interface LayerVersionUsageGrantee extends software.amazon.jsii.JsiiSerializable {
    /**
     * The AWS Account id of the account that is authorized to use a Lambda Layer Version. The wild-card ``'*'`` can be
     * used to grant access to "any" account (or any account in an organization when ``organizationId`` is specified).
     */
    java.lang.String getAccountId();
    /**
     * The ID of the AWS Organization to hwich the grant is restricted.
     * 
     * Can only be specified if ``accountId`` is ``'*'``
     */
    java.lang.String getOrganizationId();

    /**
     * @return a {@link Builder} of {@link LayerVersionUsageGrantee}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LayerVersionUsageGrantee}
     */
    final class Builder {
        private java.lang.String _accountId;
        @javax.annotation.Nullable
        private java.lang.String _organizationId;

        /**
         * Sets the value of AccountId
         * @param value The AWS Account id of the account that is authorized to use a Lambda Layer Version. The wild-card ``'*'`` can be
used to grant access to "any" account (or any account in an organization when ``organizationId`` is specified).
         * @return {@code this}
         */
        public Builder withAccountId(final java.lang.String value) {
            this._accountId = java.util.Objects.requireNonNull(value, "accountId is required");
            return this;
        }
        /**
         * Sets the value of OrganizationId
         * @param value The ID of the AWS Organization to hwich the grant is restricted.

Can only be specified if ``accountId`` is ``'*'``
         * @return {@code this}
         */
        public Builder withOrganizationId(@javax.annotation.Nullable final java.lang.String value) {
            this._organizationId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LayerVersionUsageGrantee}
         * @throws NullPointerException if any required attribute was not provided
         */
        public LayerVersionUsageGrantee build() {
            return new LayerVersionUsageGrantee() {
                private final java.lang.String $accountId = java.util.Objects.requireNonNull(_accountId, "accountId is required");
                @javax.annotation.Nullable
                private final java.lang.String $organizationId = _organizationId;

                @Override
                public java.lang.String getAccountId() {
                    return this.$accountId;
                }

                @Override
                public java.lang.String getOrganizationId() {
                    return this.$organizationId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("accountId", om.valueToTree(this.getAccountId()));
                    obj.set("organizationId", om.valueToTree(this.getOrganizationId()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.LayerVersionUsageGrantee {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The AWS Account id of the account that is authorized to use a Lambda Layer Version. The wild-card ``'*'`` can be
         * used to grant access to "any" account (or any account in an organization when ``organizationId`` is specified).
         */
        @Override
        public java.lang.String getAccountId() {
            return this.jsiiGet("accountId", java.lang.String.class);
        }

        /**
         * The ID of the AWS Organization to hwich the grant is restricted.
         * 
         * Can only be specified if ``accountId`` is ``'*'``
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getOrganizationId() {
            return this.jsiiGet("organizationId", java.lang.String.class);
        }
    }
}
