package software.amazon.awscdk.services.lambda;

/**
 * Construction properties for a LogRetention.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.915Z")
public interface LogRetentionProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The log group name.
     */
    java.lang.String getLogGroupName();
    /**
     * The number of days log events are kept in CloudWatch Logs.
     */
    software.amazon.awscdk.services.logs.RetentionDays getRetentionDays();

    /**
     * @return a {@link Builder} of {@link LogRetentionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LogRetentionProps}
     */
    final class Builder {
        private java.lang.String _logGroupName;
        private software.amazon.awscdk.services.logs.RetentionDays _retentionDays;

        /**
         * Sets the value of LogGroupName
         * @param value The log group name.
         * @return {@code this}
         */
        public Builder withLogGroupName(final java.lang.String value) {
            this._logGroupName = java.util.Objects.requireNonNull(value, "logGroupName is required");
            return this;
        }
        /**
         * Sets the value of RetentionDays
         * @param value The number of days log events are kept in CloudWatch Logs.
         * @return {@code this}
         */
        public Builder withRetentionDays(final software.amazon.awscdk.services.logs.RetentionDays value) {
            this._retentionDays = java.util.Objects.requireNonNull(value, "retentionDays is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogRetentionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public LogRetentionProps build() {
            return new LogRetentionProps() {
                private final java.lang.String $logGroupName = java.util.Objects.requireNonNull(_logGroupName, "logGroupName is required");
                private final software.amazon.awscdk.services.logs.RetentionDays $retentionDays = java.util.Objects.requireNonNull(_retentionDays, "retentionDays is required");

                @Override
                public java.lang.String getLogGroupName() {
                    return this.$logGroupName;
                }

                @Override
                public software.amazon.awscdk.services.logs.RetentionDays getRetentionDays() {
                    return this.$retentionDays;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("logGroupName", om.valueToTree(this.getLogGroupName()));
                    obj.set("retentionDays", om.valueToTree(this.getRetentionDays()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.LogRetentionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The log group name.
         */
        @Override
        public java.lang.String getLogGroupName() {
            return this.jsiiGet("logGroupName", java.lang.String.class);
        }

        /**
         * The number of days log events are kept in CloudWatch Logs.
         */
        @Override
        public software.amazon.awscdk.services.logs.RetentionDays getRetentionDays() {
            return this.jsiiGet("retentionDays", software.amazon.awscdk.services.logs.RetentionDays.class);
        }
    }
}
