package software.amazon.awscdk.services.lambda;

/**
 * Represents a permission statement that can be added to a Lambda's resource policy
 * via the `addToResourcePolicy` method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.916Z")
public interface Permission extends software.amazon.jsii.JsiiSerializable {
    /**
     * The entity for which you are granting permission to invoke the Lambda
     * function. This entity can be any valid AWS service principal, such as
     * s3.amazonaws.com or sns.amazonaws.com, or, if you are granting
     * cross-account permission, an AWS account ID. For example, you might want
     * to allow a custom application in another AWS account to push events to
     * Lambda by invoking your function.
     * 
     * The principal can be either an AccountPrincipal or a ServicePrincipal.
     */
    software.amazon.awscdk.services.iam.PolicyPrincipal getPrincipal();
    /**
     * The Lambda actions that you want to allow in this statement. For example,
     * you can specify lambda:CreateFunction to specify a certain action, or use
     * a wildcard (``lambda:*``) to grant permission to all Lambda actions. For a
     * list of actions, see Actions and Condition Context Keys for AWS Lambda in
     * the IAM User Guide.
     * @default 'lambda:InvokeFunction'
     */
    java.lang.String getAction();
    /**
     * A unique token that must be supplied by the principal invoking the
     * function.
     * @default The caller would not need to present a token.
     */
    java.lang.String getEventSourceToken();
    /**
     * The AWS account ID (without hyphens) of the source owner. For example, if
     * you specify an S3 bucket in the SourceArn property, this value is the
     * bucket owner's account ID. You can use this property to ensure that all
     * source principals are owned by a specific account.
     */
    java.lang.String getSourceAccount();
    /**
     * The ARN of a resource that is invoking your function. When granting
     * Amazon Simple Storage Service (Amazon S3) permission to invoke your
     * function, specify this property with the bucket ARN as its value. This
     * ensures that events generated only from the specified bucket, not just
     * any bucket from any AWS account that creates a mapping to your function,
     * can invoke the function.
     */
    java.lang.String getSourceArn();

    /**
     * @return a {@link Builder} of {@link Permission}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link Permission}
     */
    final class Builder {
        private software.amazon.awscdk.services.iam.PolicyPrincipal _principal;
        @javax.annotation.Nullable
        private java.lang.String _action;
        @javax.annotation.Nullable
        private java.lang.String _eventSourceToken;
        @javax.annotation.Nullable
        private java.lang.String _sourceAccount;
        @javax.annotation.Nullable
        private java.lang.String _sourceArn;

        /**
         * Sets the value of Principal
         * @param value The entity for which you are granting permission to invoke the Lambda
function. This entity can be any valid AWS service principal, such as
s3.amazonaws.com or sns.amazonaws.com, or, if you are granting
cross-account permission, an AWS account ID. For example, you might want
to allow a custom application in another AWS account to push events to
Lambda by invoking your function.

The principal can be either an AccountPrincipal or a ServicePrincipal.
         * @return {@code this}
         */
        public Builder withPrincipal(final software.amazon.awscdk.services.iam.PolicyPrincipal value) {
            this._principal = java.util.Objects.requireNonNull(value, "principal is required");
            return this;
        }
        /**
         * Sets the value of Action
         * @param value The Lambda actions that you want to allow in this statement. For example,
you can specify lambda:CreateFunction to specify a certain action, or use
a wildcard (``lambda:*``) to grant permission to all Lambda actions. For a
list of actions, see Actions and Condition Context Keys for AWS Lambda in
the IAM User Guide.
         * @return {@code this}
         */
        public Builder withAction(@javax.annotation.Nullable final java.lang.String value) {
            this._action = value;
            return this;
        }
        /**
         * Sets the value of EventSourceToken
         * @param value A unique token that must be supplied by the principal invoking the
function.
         * @return {@code this}
         */
        public Builder withEventSourceToken(@javax.annotation.Nullable final java.lang.String value) {
            this._eventSourceToken = value;
            return this;
        }
        /**
         * Sets the value of SourceAccount
         * @param value The AWS account ID (without hyphens) of the source owner. For example, if
you specify an S3 bucket in the SourceArn property, this value is the
bucket owner's account ID. You can use this property to ensure that all
source principals are owned by a specific account.
         * @return {@code this}
         */
        public Builder withSourceAccount(@javax.annotation.Nullable final java.lang.String value) {
            this._sourceAccount = value;
            return this;
        }
        /**
         * Sets the value of SourceArn
         * @param value The ARN of a resource that is invoking your function. When granting
Amazon Simple Storage Service (Amazon S3) permission to invoke your
function, specify this property with the bucket ARN as its value. This
ensures that events generated only from the specified bucket, not just
any bucket from any AWS account that creates a mapping to your function,
can invoke the function.
         * @return {@code this}
         */
        public Builder withSourceArn(@javax.annotation.Nullable final java.lang.String value) {
            this._sourceArn = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Permission}
         * @throws NullPointerException if any required attribute was not provided
         */
        public Permission build() {
            return new Permission() {
                private final software.amazon.awscdk.services.iam.PolicyPrincipal $principal = java.util.Objects.requireNonNull(_principal, "principal is required");
                @javax.annotation.Nullable
                private final java.lang.String $action = _action;
                @javax.annotation.Nullable
                private final java.lang.String $eventSourceToken = _eventSourceToken;
                @javax.annotation.Nullable
                private final java.lang.String $sourceAccount = _sourceAccount;
                @javax.annotation.Nullable
                private final java.lang.String $sourceArn = _sourceArn;

                @Override
                public software.amazon.awscdk.services.iam.PolicyPrincipal getPrincipal() {
                    return this.$principal;
                }

                @Override
                public java.lang.String getAction() {
                    return this.$action;
                }

                @Override
                public java.lang.String getEventSourceToken() {
                    return this.$eventSourceToken;
                }

                @Override
                public java.lang.String getSourceAccount() {
                    return this.$sourceAccount;
                }

                @Override
                public java.lang.String getSourceArn() {
                    return this.$sourceArn;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("principal", om.valueToTree(this.getPrincipal()));
                    obj.set("action", om.valueToTree(this.getAction()));
                    obj.set("eventSourceToken", om.valueToTree(this.getEventSourceToken()));
                    obj.set("sourceAccount", om.valueToTree(this.getSourceAccount()));
                    obj.set("sourceArn", om.valueToTree(this.getSourceArn()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.Permission {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The entity for which you are granting permission to invoke the Lambda
         * function. This entity can be any valid AWS service principal, such as
         * s3.amazonaws.com or sns.amazonaws.com, or, if you are granting
         * cross-account permission, an AWS account ID. For example, you might want
         * to allow a custom application in another AWS account to push events to
         * Lambda by invoking your function.
         * 
         * The principal can be either an AccountPrincipal or a ServicePrincipal.
         */
        @Override
        public software.amazon.awscdk.services.iam.PolicyPrincipal getPrincipal() {
            return this.jsiiGet("principal", software.amazon.awscdk.services.iam.PolicyPrincipal.class);
        }

        /**
         * The Lambda actions that you want to allow in this statement. For example,
         * you can specify lambda:CreateFunction to specify a certain action, or use
         * a wildcard (``lambda:*``) to grant permission to all Lambda actions. For a
         * list of actions, see Actions and Condition Context Keys for AWS Lambda in
         * the IAM User Guide.
         * @default 'lambda:InvokeFunction'
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getAction() {
            return this.jsiiGet("action", java.lang.String.class);
        }

        /**
         * A unique token that must be supplied by the principal invoking the
         * function.
         * @default The caller would not need to present a token.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getEventSourceToken() {
            return this.jsiiGet("eventSourceToken", java.lang.String.class);
        }

        /**
         * The AWS account ID (without hyphens) of the source owner. For example, if
         * you specify an S3 bucket in the SourceArn property, this value is the
         * bucket owner's account ID. You can use this property to ensure that all
         * source principals are owned by a specific account.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getSourceAccount() {
            return this.jsiiGet("sourceAccount", java.lang.String.class);
        }

        /**
         * The ARN of a resource that is invoking your function. When granting
         * Amazon Simple Storage Service (Amazon S3) permission to invoke your
         * function, specify this property with the bucket ARN as its value. This
         * ensures that events generated only from the specified bucket, not just
         * any bucket from any AWS account that creates a mapping to your function,
         * can invoke the function.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getSourceArn() {
            return this.jsiiGet("sourceArn", java.lang.String.class);
        }
    }
}
