package software.amazon.awscdk.services.lambda;

/**
 * Construction properties of the {@link PipelineInvokeAction Lambda invoke CodePipeline Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.916Z")
public interface PipelineInvokeActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.CommonPipelineInvokeActionProps {
    /**
     * The lambda function to invoke.
     */
    software.amazon.awscdk.services.lambda.IFunction getLambda();

    /**
     * @return a {@link Builder} of {@link PipelineInvokeActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link PipelineInvokeActionProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.lambda.IFunction _lambda;
        @javax.annotation.Nullable
        private java.lang.Boolean _addPutJobResultPolicy;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.codepipeline.api.Artifact> _inputArtifacts;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _outputArtifactNames;
        @javax.annotation.Nullable
        private java.lang.Object _userParameters;
        private java.lang.String _actionName;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;

        /**
         * Sets the value of Lambda
         * @param value The lambda function to invoke.
         * @return {@code this}
         */
        public Builder withLambda(final software.amazon.awscdk.services.lambda.IFunction value) {
            this._lambda = java.util.Objects.requireNonNull(value, "lambda is required");
            return this;
        }
        /**
         * Sets the value of AddPutJobResultPolicy
         * @param value Adds the "codepipeline:PutJobSuccessResult" and
"codepipeline:PutJobFailureResult" for '*' resource to the Lambda
execution role policy.

NOTE: the reason we can't add the specific pipeline ARN as a resource is
to avoid a cyclic dependency between the pipeline and the Lambda function
(the pipeline references) the Lambda and the Lambda needs permissions on
the pipeline.
         * @return {@code this}
         */
        public Builder withAddPutJobResultPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._addPutJobResultPolicy = value;
            return this;
        }
        /**
         * Sets the value of InputArtifacts
         * @param value The optional input Artifacts of the Action.
A Lambda Action can have up to 5 inputs.
The inputs will appear in the event passed to the Lambda,
under the `'CodePipeline.job'.data.inputArtifacts` path.
         * @return {@code this}
         */
        public Builder withInputArtifacts(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.codepipeline.api.Artifact> value) {
            this._inputArtifacts = value;
            return this;
        }
        /**
         * Sets the value of OutputArtifactNames
         * @param value The optional names of the output Artifacts of the Action.
A Lambda Action can have up to 5 outputs.
The outputs will appear in the event passed to the Lambda,
under the `'CodePipeline.job'.data.outputArtifacts` path.
It is the responsibility of the Lambda to upload ZIP files with the Artifact contents to the provided locations.
         * @return {@code this}
         */
        public Builder withOutputArtifactNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._outputArtifactNames = value;
            return this;
        }
        /**
         * Sets the value of UserParameters
         * @param value String to be used in the event data parameter passed to the Lambda
function

See an example JSON event in the CodePipeline documentation.

https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
         * @return {@code this}
         */
        public Builder withUserParameters(@javax.annotation.Nullable final java.lang.Object value) {
            this._userParameters = value;
            return this;
        }
        /**
         * Sets the value of ActionName
         * @param value The physical, human-readable name of the Action.
Not that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        public Builder withActionName(final java.lang.String value) {
            this._actionName = java.util.Objects.requireNonNull(value, "actionName is required");
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineInvokeActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public PipelineInvokeActionProps build() {
            return new PipelineInvokeActionProps() {
                private final software.amazon.awscdk.services.lambda.IFunction $lambda = java.util.Objects.requireNonNull(_lambda, "lambda is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $addPutJobResultPolicy = _addPutJobResultPolicy;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.codepipeline.api.Artifact> $inputArtifacts = _inputArtifacts;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $outputArtifactNames = _outputArtifactNames;
                @javax.annotation.Nullable
                private final java.lang.Object $userParameters = _userParameters;
                private final java.lang.String $actionName = java.util.Objects.requireNonNull(_actionName, "actionName is required");
                @javax.annotation.Nullable
                private final java.lang.Number $runOrder = _runOrder;

                @Override
                public software.amazon.awscdk.services.lambda.IFunction getLambda() {
                    return this.$lambda;
                }

                @Override
                public java.lang.Boolean getAddPutJobResultPolicy() {
                    return this.$addPutJobResultPolicy;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.codepipeline.api.Artifact> getInputArtifacts() {
                    return this.$inputArtifacts;
                }

                @Override
                public java.util.List<java.lang.String> getOutputArtifactNames() {
                    return this.$outputArtifactNames;
                }

                @Override
                public java.lang.Object getUserParameters() {
                    return this.$userParameters;
                }

                @Override
                public java.lang.String getActionName() {
                    return this.$actionName;
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("lambda", om.valueToTree(this.getLambda()));
                    obj.set("addPutJobResultPolicy", om.valueToTree(this.getAddPutJobResultPolicy()));
                    obj.set("inputArtifacts", om.valueToTree(this.getInputArtifacts()));
                    obj.set("outputArtifactNames", om.valueToTree(this.getOutputArtifactNames()));
                    obj.set("userParameters", om.valueToTree(this.getUserParameters()));
                    obj.set("actionName", om.valueToTree(this.getActionName()));
                    obj.set("runOrder", om.valueToTree(this.getRunOrder()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.PipelineInvokeActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The lambda function to invoke.
         */
        @Override
        public software.amazon.awscdk.services.lambda.IFunction getLambda() {
            return this.jsiiGet("lambda", software.amazon.awscdk.services.lambda.IFunction.class);
        }

        /**
         * Adds the "codepipeline:PutJobSuccessResult" and
         * "codepipeline:PutJobFailureResult" for '*' resource to the Lambda
         * execution role policy.
         * 
         * NOTE: the reason we can't add the specific pipeline ARN as a resource is
         * to avoid a cyclic dependency between the pipeline and the Lambda function
         * (the pipeline references) the Lambda and the Lambda needs permissions on
         * the pipeline.
         * @default true
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-create-function
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getAddPutJobResultPolicy() {
            return this.jsiiGet("addPutJobResultPolicy", java.lang.Boolean.class);
        }

        /**
         * The optional input Artifacts of the Action.
         * A Lambda Action can have up to 5 inputs.
         * The inputs will appear in the event passed to the Lambda,
         * under the `'CodePipeline.job'.data.inputArtifacts` path.
         * @default the Action will not have any inputs
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.codepipeline.api.Artifact> getInputArtifacts() {
            return this.jsiiGet("inputArtifacts", java.util.List.class);
        }

        /**
         * The optional names of the output Artifacts of the Action.
         * A Lambda Action can have up to 5 outputs.
         * The outputs will appear in the event passed to the Lambda,
         * under the `'CodePipeline.job'.data.outputArtifacts` path.
         * It is the responsibility of the Lambda to upload ZIP files with the Artifact contents to the provided locations.
         * @default the Action will not have any outputs
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getOutputArtifactNames() {
            return this.jsiiGet("outputArtifactNames", java.util.List.class);
        }

        /**
         * String to be used in the event data parameter passed to the Lambda
         * function
         * 
         * See an example JSON event in the CodePipeline documentation.
         * 
         * https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getUserParameters() {
            return this.jsiiGet("userParameters", java.lang.Object.class);
        }

        /**
         * The physical, human-readable name of the Action.
         * Not that Action names must be unique within a single Stage.
         */
        @Override
        public java.lang.String getActionName() {
            return this.jsiiGet("actionName", java.lang.String.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }
    }
}
