package software.amazon.awscdk.services.lambda;

/**
 * Properties for a newly created singleton Lambda
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.919Z")
public interface SingletonFunctionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.FunctionProps {
    /**
     * A unique identifier to identify this lambda
     * 
     * The identifier should be unique across all custom resource providers.
     * We recommend generating a UUID per provider.
     */
    java.lang.String getUuid();
    /**
     * A descriptive name for the purpose of this Lambda.
     * 
     * If the Lambda does not have a physical name, this string will be
     * reflected its generated name. The combination of lambdaPurpose
     * and uuid must be unique.
     * @default SingletonLambda
     */
    java.lang.String getLambdaPurpose();

    /**
     * @return a {@link Builder} of {@link SingletonFunctionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SingletonFunctionProps}
     */
    final class Builder {
        private java.lang.String _uuid;
        @javax.annotation.Nullable
        private java.lang.String _lambdaPurpose;
        private software.amazon.awscdk.services.lambda.Code _code;
        private java.lang.String _handler;
        private software.amazon.awscdk.services.lambda.Runtime _runtime;
        @javax.annotation.Nullable
        private java.lang.Boolean _allowAllOutbound;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.sqs.IQueue _deadLetterQueue;
        @javax.annotation.Nullable
        private java.lang.Boolean _deadLetterQueueEnabled;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.Object> _environment;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.lambda.IEventSource> _events;
        @javax.annotation.Nullable
        private java.lang.String _functionName;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> _initialPolicy;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> _layers;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.logs.RetentionDays _logRetentionDays;
        @javax.annotation.Nullable
        private java.lang.Number _memorySize;
        @javax.annotation.Nullable
        private java.lang.Number _reservedConcurrentExecutions;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.IRole _role;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.ISecurityGroup _securityGroup;
        @javax.annotation.Nullable
        private java.lang.Number _timeout;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.lambda.Tracing _tracing;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.IVpcNetwork _vpc;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.SubnetSelection _vpcSubnets;

        /**
         * Sets the value of Uuid
         * @param value A unique identifier to identify this lambda

The identifier should be unique across all custom resource providers.
We recommend generating a UUID per provider.
         * @return {@code this}
         */
        public Builder withUuid(final java.lang.String value) {
            this._uuid = java.util.Objects.requireNonNull(value, "uuid is required");
            return this;
        }
        /**
         * Sets the value of LambdaPurpose
         * @param value A descriptive name for the purpose of this Lambda.

If the Lambda does not have a physical name, this string will be
reflected its generated name. The combination of lambdaPurpose
and uuid must be unique.
         * @return {@code this}
         */
        public Builder withLambdaPurpose(@javax.annotation.Nullable final java.lang.String value) {
            this._lambdaPurpose = value;
            return this;
        }
        /**
         * Sets the value of Code
         * @param value The source code of your Lambda function. You can point to a file in an
Amazon Simple Storage Service (Amazon S3) bucket or specify your source
code as inline text.
         * @return {@code this}
         */
        public Builder withCode(final software.amazon.awscdk.services.lambda.Code value) {
            this._code = java.util.Objects.requireNonNull(value, "code is required");
            return this;
        }
        /**
         * Sets the value of Handler
         * @param value The name of the function (within your source code) that Lambda calls to
start running your code. For more information, see the Handler property
in the AWS Lambda Developer Guide.

NOTE: If you specify your source code as inline text by specifying the
ZipFile property within the Code property, specify index.function_name as
the handler.
         * @return {@code this}
         */
        public Builder withHandler(final java.lang.String value) {
            this._handler = java.util.Objects.requireNonNull(value, "handler is required");
            return this;
        }
        /**
         * Sets the value of Runtime
         * @param value The runtime environment for the Lambda function that you are uploading.
For valid values, see the Runtime property in the AWS Lambda Developer
Guide.
         * @return {@code this}
         */
        public Builder withRuntime(final software.amazon.awscdk.services.lambda.Runtime value) {
            this._runtime = java.util.Objects.requireNonNull(value, "runtime is required");
            return this;
        }
        /**
         * Sets the value of AllowAllOutbound
         * @param value Whether to allow the Lambda to send all network traffic

If set to false, you must individually add traffic rules to allow the
Lambda to connect to network targets.
         * @return {@code this}
         */
        public Builder withAllowAllOutbound(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._allowAllOutbound = value;
            return this;
        }
        /**
         * Sets the value of DeadLetterQueue
         * @param value The SQS queue to use if DLQ is enabled.
         * @return {@code this}
         */
        public Builder withDeadLetterQueue(@javax.annotation.Nullable final software.amazon.awscdk.services.sqs.IQueue value) {
            this._deadLetterQueue = value;
            return this;
        }
        /**
         * Sets the value of DeadLetterQueueEnabled
         * @param value Enabled DLQ. If `deadLetterQueue` is undefined,
an SQS queue with default options will be defined for your Function.
         * @return {@code this}
         */
        public Builder withDeadLetterQueueEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._deadLetterQueueEnabled = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the function.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of Environment
         * @param value Key-value pairs that Lambda caches and makes available for your Lambda
functions. Use environment variables to apply configuration changes, such
as test and production environment configurations, without changing your
Lambda function source code.
         * @return {@code this}
         */
        public Builder withEnvironment(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._environment = value;
            return this;
        }
        /**
         * Sets the value of Events
         * @param value Event sources for this function.

You can also add event sources using `addEventSource`.
         * @return {@code this}
         */
        public Builder withEvents(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.lambda.IEventSource> value) {
            this._events = value;
            return this;
        }
        /**
         * Sets the value of FunctionName
         * @param value A name for the function. If you don't specify a name, AWS CloudFormation
generates a unique physical ID and uses that ID for the function's name.
For more information, see Name Type.
         * @return {@code this}
         */
        public Builder withFunctionName(@javax.annotation.Nullable final java.lang.String value) {
            this._functionName = value;
            return this;
        }
        /**
         * Sets the value of InitialPolicy
         * @param value Initial policy statements to add to the created Lambda Role.

You can call `addToRolePolicy` to the created lambda to add statements post creation.
         * @return {@code this}
         */
        public Builder withInitialPolicy(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> value) {
            this._initialPolicy = value;
            return this;
        }
        /**
         * Sets the value of Layers
         * @param value A list of layers to add to the function's execution environment. You can configure your Lambda function to pull in
additional code during initialization in the form of layers. Layers are packages of libraries or other dependencies
that can be used by mulitple functions.
         * @return {@code this}
         */
        public Builder withLayers(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> value) {
            this._layers = value;
            return this;
        }
        /**
         * Sets the value of LogRetentionDays
         * @param value The number of days log events are kept in CloudWatch Logs. When updating
this property, unsetting it doesn't remove the log retention policy. To
remove the retention policy, set the value to `Infinity`.
         * @return {@code this}
         */
        public Builder withLogRetentionDays(@javax.annotation.Nullable final software.amazon.awscdk.services.logs.RetentionDays value) {
            this._logRetentionDays = value;
            return this;
        }
        /**
         * Sets the value of MemorySize
         * @param value The amount of memory, in MB, that is allocated to your Lambda function.
Lambda uses this value to proportionally allocate the amount of CPU
power. For more information, see Resource Model in the AWS Lambda
Developer Guide.
         * @return {@code this}
         */
        public Builder withMemorySize(@javax.annotation.Nullable final java.lang.Number value) {
            this._memorySize = value;
            return this;
        }
        /**
         * Sets the value of ReservedConcurrentExecutions
         * @param value The maximum of concurrent executions you want to reserve for the function.
         * @return {@code this}
         */
        public Builder withReservedConcurrentExecutions(@javax.annotation.Nullable final java.lang.Number value) {
            this._reservedConcurrentExecutions = value;
            return this;
        }
        /**
         * Sets the value of Role
         * @param value Lambda execution role.

This is the role that will be assumed by the function upon execution.
It controls the permissions that the function will have. The Role must
be assumable by the 'lambda.amazonaws.com' service principal.
         * @return {@code this}
         */
        public Builder withRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IRole value) {
            this._role = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroup
         * @param value What security group to associate with the Lambda's network interfaces.

Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        public Builder withSecurityGroup(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.ISecurityGroup value) {
            this._securityGroup = value;
            return this;
        }
        /**
         * Sets the value of Timeout
         * @param value The function execution time (in seconds) after which Lambda terminates
the function. Because the execution time affects cost, set this value
based on the function's expected execution time.
         * @return {@code this}
         */
        public Builder withTimeout(@javax.annotation.Nullable final java.lang.Number value) {
            this._timeout = value;
            return this;
        }
        /**
         * Sets the value of Tracing
         * @param value Enable AWS X-Ray Tracing for Lambda Function.
         * @return {@code this}
         */
        public Builder withTracing(@javax.annotation.Nullable final software.amazon.awscdk.services.lambda.Tracing value) {
            this._tracing = value;
            return this;
        }
        /**
         * Sets the value of Vpc
         * @param value VPC network to place Lambda network interfaces

Specify this if the Lambda function needs to access resources in a VPC.
         * @return {@code this}
         */
        public Builder withVpc(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.IVpcNetwork value) {
            this._vpc = value;
            return this;
        }
        /**
         * Sets the value of VpcSubnets
         * @param value Where to place the network interfaces within the VPC.

Only used if 'vpc' is supplied. Note: internet access for Lambdas
requires a NAT gateway, so picking Public subnets is not allowed.
         * @return {@code this}
         */
        public Builder withVpcSubnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetSelection value) {
            this._vpcSubnets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SingletonFunctionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public SingletonFunctionProps build() {
            return new SingletonFunctionProps() {
                private final java.lang.String $uuid = java.util.Objects.requireNonNull(_uuid, "uuid is required");
                @javax.annotation.Nullable
                private final java.lang.String $lambdaPurpose = _lambdaPurpose;
                private final software.amazon.awscdk.services.lambda.Code $code = java.util.Objects.requireNonNull(_code, "code is required");
                private final java.lang.String $handler = java.util.Objects.requireNonNull(_handler, "handler is required");
                private final software.amazon.awscdk.services.lambda.Runtime $runtime = java.util.Objects.requireNonNull(_runtime, "runtime is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $allowAllOutbound = _allowAllOutbound;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.sqs.IQueue $deadLetterQueue = _deadLetterQueue;
                @javax.annotation.Nullable
                private final java.lang.Boolean $deadLetterQueueEnabled = _deadLetterQueueEnabled;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.Object> $environment = _environment;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.lambda.IEventSource> $events = _events;
                @javax.annotation.Nullable
                private final java.lang.String $functionName = _functionName;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> $initialPolicy = _initialPolicy;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> $layers = _layers;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.logs.RetentionDays $logRetentionDays = _logRetentionDays;
                @javax.annotation.Nullable
                private final java.lang.Number $memorySize = _memorySize;
                @javax.annotation.Nullable
                private final java.lang.Number $reservedConcurrentExecutions = _reservedConcurrentExecutions;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.iam.IRole $role = _role;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.ISecurityGroup $securityGroup = _securityGroup;
                @javax.annotation.Nullable
                private final java.lang.Number $timeout = _timeout;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.lambda.Tracing $tracing = _tracing;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.IVpcNetwork $vpc = _vpc;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.SubnetSelection $vpcSubnets = _vpcSubnets;

                @Override
                public java.lang.String getUuid() {
                    return this.$uuid;
                }

                @Override
                public java.lang.String getLambdaPurpose() {
                    return this.$lambdaPurpose;
                }

                @Override
                public software.amazon.awscdk.services.lambda.Code getCode() {
                    return this.$code;
                }

                @Override
                public java.lang.String getHandler() {
                    return this.$handler;
                }

                @Override
                public software.amazon.awscdk.services.lambda.Runtime getRuntime() {
                    return this.$runtime;
                }

                @Override
                public java.lang.Boolean getAllowAllOutbound() {
                    return this.$allowAllOutbound;
                }

                @Override
                public software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
                    return this.$deadLetterQueue;
                }

                @Override
                public java.lang.Boolean getDeadLetterQueueEnabled() {
                    return this.$deadLetterQueueEnabled;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.Object> getEnvironment() {
                    return this.$environment;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.lambda.IEventSource> getEvents() {
                    return this.$events;
                }

                @Override
                public java.lang.String getFunctionName() {
                    return this.$functionName;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getInitialPolicy() {
                    return this.$initialPolicy;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> getLayers() {
                    return this.$layers;
                }

                @Override
                public software.amazon.awscdk.services.logs.RetentionDays getLogRetentionDays() {
                    return this.$logRetentionDays;
                }

                @Override
                public java.lang.Number getMemorySize() {
                    return this.$memorySize;
                }

                @Override
                public java.lang.Number getReservedConcurrentExecutions() {
                    return this.$reservedConcurrentExecutions;
                }

                @Override
                public software.amazon.awscdk.services.iam.IRole getRole() {
                    return this.$role;
                }

                @Override
                public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
                    return this.$securityGroup;
                }

                @Override
                public java.lang.Number getTimeout() {
                    return this.$timeout;
                }

                @Override
                public software.amazon.awscdk.services.lambda.Tracing getTracing() {
                    return this.$tracing;
                }

                @Override
                public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
                    return this.$vpc;
                }

                @Override
                public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
                    return this.$vpcSubnets;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("uuid", om.valueToTree(this.getUuid()));
                    obj.set("lambdaPurpose", om.valueToTree(this.getLambdaPurpose()));
                    obj.set("code", om.valueToTree(this.getCode()));
                    obj.set("handler", om.valueToTree(this.getHandler()));
                    obj.set("runtime", om.valueToTree(this.getRuntime()));
                    obj.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
                    obj.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
                    obj.set("deadLetterQueueEnabled", om.valueToTree(this.getDeadLetterQueueEnabled()));
                    obj.set("description", om.valueToTree(this.getDescription()));
                    obj.set("environment", om.valueToTree(this.getEnvironment()));
                    obj.set("events", om.valueToTree(this.getEvents()));
                    obj.set("functionName", om.valueToTree(this.getFunctionName()));
                    obj.set("initialPolicy", om.valueToTree(this.getInitialPolicy()));
                    obj.set("layers", om.valueToTree(this.getLayers()));
                    obj.set("logRetentionDays", om.valueToTree(this.getLogRetentionDays()));
                    obj.set("memorySize", om.valueToTree(this.getMemorySize()));
                    obj.set("reservedConcurrentExecutions", om.valueToTree(this.getReservedConcurrentExecutions()));
                    obj.set("role", om.valueToTree(this.getRole()));
                    obj.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
                    obj.set("timeout", om.valueToTree(this.getTimeout()));
                    obj.set("tracing", om.valueToTree(this.getTracing()));
                    obj.set("vpc", om.valueToTree(this.getVpc()));
                    obj.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.SingletonFunctionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * A unique identifier to identify this lambda
         * 
         * The identifier should be unique across all custom resource providers.
         * We recommend generating a UUID per provider.
         */
        @Override
        public java.lang.String getUuid() {
            return this.jsiiGet("uuid", java.lang.String.class);
        }

        /**
         * A descriptive name for the purpose of this Lambda.
         * 
         * If the Lambda does not have a physical name, this string will be
         * reflected its generated name. The combination of lambdaPurpose
         * and uuid must be unique.
         * @default SingletonLambda
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getLambdaPurpose() {
            return this.jsiiGet("lambdaPurpose", java.lang.String.class);
        }

        /**
         * The source code of your Lambda function. You can point to a file in an
         * Amazon Simple Storage Service (Amazon S3) bucket or specify your source
         * code as inline text.
         */
        @Override
        public software.amazon.awscdk.services.lambda.Code getCode() {
            return this.jsiiGet("code", software.amazon.awscdk.services.lambda.Code.class);
        }

        /**
         * The name of the function (within your source code) that Lambda calls to
         * start running your code. For more information, see the Handler property
         * in the AWS Lambda Developer Guide.
         * 
         * NOTE: If you specify your source code as inline text by specifying the
         * ZipFile property within the Code property, specify index.function_name as
         * the handler.
         */
        @Override
        public java.lang.String getHandler() {
            return this.jsiiGet("handler", java.lang.String.class);
        }

        /**
         * The runtime environment for the Lambda function that you are uploading.
         * For valid values, see the Runtime property in the AWS Lambda Developer
         * Guide.
         */
        @Override
        public software.amazon.awscdk.services.lambda.Runtime getRuntime() {
            return this.jsiiGet("runtime", software.amazon.awscdk.services.lambda.Runtime.class);
        }

        /**
         * Whether to allow the Lambda to send all network traffic
         * 
         * If set to false, you must individually add traffic rules to allow the
         * Lambda to connect to network targets.
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getAllowAllOutbound() {
            return this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
        }

        /**
         * The SQS queue to use if DLQ is enabled.
         * @default SQS queue with 14 day retention period if `deadLetterQueueEnabled` is `true`
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.jsiiGet("deadLetterQueue", software.amazon.awscdk.services.sqs.IQueue.class);
        }

        /**
         * Enabled DLQ. If `deadLetterQueue` is undefined,
         * an SQS queue with default options will be defined for your Function.
         * @default false unless `deadLetterQueue` is set, which implies DLQ is enabled
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getDeadLetterQueueEnabled() {
            return this.jsiiGet("deadLetterQueueEnabled", java.lang.Boolean.class);
        }

        /**
         * A description of the function.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Key-value pairs that Lambda caches and makes available for your Lambda
         * functions. Use environment variables to apply configuration changes, such
         * as test and production environment configurations, without changing your
         * Lambda function source code.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Object> getEnvironment() {
            return this.jsiiGet("environment", java.util.Map.class);
        }

        /**
         * Event sources for this function.
         * 
         * You can also add event sources using `addEventSource`.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.lambda.IEventSource> getEvents() {
            return this.jsiiGet("events", java.util.List.class);
        }

        /**
         * A name for the function. If you don't specify a name, AWS CloudFormation
         * generates a unique physical ID and uses that ID for the function's name.
         * For more information, see Name Type.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getFunctionName() {
            return this.jsiiGet("functionName", java.lang.String.class);
        }

        /**
         * Initial policy statements to add to the created Lambda Role.
         * 
         * You can call `addToRolePolicy` to the created lambda to add statements post creation.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getInitialPolicy() {
            return this.jsiiGet("initialPolicy", java.util.List.class);
        }

        /**
         * A list of layers to add to the function's execution environment. You can configure your Lambda function to pull in
         * additional code during initialization in the form of layers. Layers are packages of libraries or other dependencies
         * that can be used by mulitple functions.
         * @default no layers
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> getLayers() {
            return this.jsiiGet("layers", java.util.List.class);
        }

        /**
         * The number of days log events are kept in CloudWatch Logs. When updating
         * this property, unsetting it doesn't remove the log retention policy. To
         * remove the retention policy, set the value to `Infinity`.
         * @default logs never expire
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.logs.RetentionDays getLogRetentionDays() {
            return this.jsiiGet("logRetentionDays", software.amazon.awscdk.services.logs.RetentionDays.class);
        }

        /**
         * The amount of memory, in MB, that is allocated to your Lambda function.
         * Lambda uses this value to proportionally allocate the amount of CPU
         * power. For more information, see Resource Model in the AWS Lambda
         * Developer Guide.
         * @default The default value is 128 MB
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getMemorySize() {
            return this.jsiiGet("memorySize", java.lang.Number.class);
        }

        /**
         * The maximum of concurrent executions you want to reserve for the function.
         * @default no specific limit - account limit
         * @see https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getReservedConcurrentExecutions() {
            return this.jsiiGet("reservedConcurrentExecutions", java.lang.Number.class);
        }

        /**
         * Lambda execution role.
         * 
         * This is the role that will be assumed by the function upon execution.
         * It controls the permissions that the function will have. The Role must
         * be assumable by the 'lambda.amazonaws.com' service principal.
         * @default a unique role will be generated for this lambda function. Both supplied and generated roles can always be changed by calling `addToRolePolicy`.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
        }

        /**
         * What security group to associate with the Lambda's network interfaces.
         * 
         * Only used if 'vpc' is supplied.
         * @default If the function is placed within a VPC and a security group is not specified, a dedicated security group will be created for this function.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
        }

        /**
         * The function execution time (in seconds) after which Lambda terminates
         * the function. Because the execution time affects cost, set this value
         * based on the function's expected execution time.
         * @default 3 seconds.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getTimeout() {
            return this.jsiiGet("timeout", java.lang.Number.class);
        }

        /**
         * Enable AWS X-Ray Tracing for Lambda Function.
         * @default undefined X-Ray tracing disabled
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.lambda.Tracing getTracing() {
            return this.jsiiGet("tracing", software.amazon.awscdk.services.lambda.Tracing.class);
        }

        /**
         * VPC network to place Lambda network interfaces
         * 
         * Specify this if the Lambda function needs to access resources in a VPC.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpcNetwork.class);
        }

        /**
         * Where to place the network interfaces within the VPC.
         * 
         * Only used if 'vpc' is supplied. Note: internet access for Lambdas
         * requires a NAT gateway, so picking Public subnets is not allowed.
         * @default All private subnets
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }
    }
}
