package software.amazon.awscdk.services.lambda;

/**
 * A Singleton Lambda Layer Version. The construct gurantees exactly one LayerVersion will be created in a given Stack
 * for the provided ``uuid``. It is recommended to use ``uuidgen`` to create a new ``uuid`` each time a new singleton
 * layer is created.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.921Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.SingletonLayerVersion")
public class SingletonLayerVersion extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.lambda.ILayerVersion {
    protected SingletonLayerVersion(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public SingletonLayerVersion(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.SingletonLayerVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Exports this layer for use in another Stack. The resulting object can be passed to the ``LayerVersion.import``
     * function to obtain an ``ILayerVersion`` in the user stack.
     */
    @Override
    public software.amazon.awscdk.services.lambda.LayerVersionImportProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.lambda.LayerVersionImportProps.class);
    }

    /**
     * Grants usage of this layer to specific entities. Usage within the same account where the layer is defined is always
     * allowed and does not require calling this method. Note that the principal that creates the Lambda function using
     * the layer (for example, a CloudFormation changeset execution role) also needs to have the
     * ``lambda:GetLayerVersion`` permission on the layer version.
     */
    @Override
    public software.amazon.awscdk.services.lambda.ILayerVersion grantUsage(final java.lang.String id, final software.amazon.awscdk.services.lambda.LayerVersionUsageGrantee grantee) {
        return this.jsiiCall("grantUsage", software.amazon.awscdk.services.lambda.ILayerVersion.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(grantee, "grantee is required"))).toArray());
    }

    /**
     * The ARN of the Lambda Layer version that this Layer defines.
     */
    @Override
    public java.lang.String getLayerVersionArn() {
        return this.jsiiGet("layerVersionArn", java.lang.String.class);
    }

    /**
     * The runtimes compatible with this Layer.
     */
    @Override
    @javax.annotation.Nullable
    public java.util.List<software.amazon.awscdk.services.lambda.Runtime> getCompatibleRuntimes() {
        return this.jsiiGet("compatibleRuntimes", java.util.List.class);
    }
}
