package software.amazon.awscdk.services.lambda;

/**
 * Properties of a Singleton Lambda Layer Version.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.921Z")
public interface SingletonLayerVersionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.LayerVersionProps {
    /**
     * A unique identifier to identify this lambda layer version.
     * 
     * The identifier should be unique across all layer providers.
     * We recommend generating a UUID per provider.
     */
    java.lang.String getUuid();

    /**
     * @return a {@link Builder} of {@link SingletonLayerVersionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SingletonLayerVersionProps}
     */
    final class Builder {
        private java.lang.String _uuid;
        private software.amazon.awscdk.services.lambda.Code _code;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.lambda.Runtime> _compatibleRuntimes;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.String _license;
        @javax.annotation.Nullable
        private java.lang.String _name;

        /**
         * Sets the value of Uuid
         * @param value A unique identifier to identify this lambda layer version.

The identifier should be unique across all layer providers.
We recommend generating a UUID per provider.
         * @return {@code this}
         */
        public Builder withUuid(final java.lang.String value) {
            this._uuid = java.util.Objects.requireNonNull(value, "uuid is required");
            return this;
        }
        /**
         * Sets the value of Code
         * @param value The content of this Layer. Using *inline* (per ``code.isInline``) code is not permitted.
         * @return {@code this}
         */
        public Builder withCode(final software.amazon.awscdk.services.lambda.Code value) {
            this._code = java.util.Objects.requireNonNull(value, "code is required");
            return this;
        }
        /**
         * Sets the value of CompatibleRuntimes
         * @param value The runtimes that this layer is compatible with.
         * @return {@code this}
         */
        public Builder withCompatibleRuntimes(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.lambda.Runtime> value) {
            this._compatibleRuntimes = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value The description the this Lambda Layer.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of License
         * @param value The SPDX licence identifier or URL to the license file for this layer.
         * @return {@code this}
         */
        public Builder withLicense(@javax.annotation.Nullable final java.lang.String value) {
            this._license = value;
            return this;
        }
        /**
         * Sets the value of Name
         * @param value The name of the layer.
         * @return {@code this}
         */
        public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
            this._name = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SingletonLayerVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public SingletonLayerVersionProps build() {
            return new SingletonLayerVersionProps() {
                private final java.lang.String $uuid = java.util.Objects.requireNonNull(_uuid, "uuid is required");
                private final software.amazon.awscdk.services.lambda.Code $code = java.util.Objects.requireNonNull(_code, "code is required");
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.lambda.Runtime> $compatibleRuntimes = _compatibleRuntimes;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.lang.String $license = _license;
                @javax.annotation.Nullable
                private final java.lang.String $name = _name;

                @Override
                public java.lang.String getUuid() {
                    return this.$uuid;
                }

                @Override
                public software.amazon.awscdk.services.lambda.Code getCode() {
                    return this.$code;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.lambda.Runtime> getCompatibleRuntimes() {
                    return this.$compatibleRuntimes;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.lang.String getLicense() {
                    return this.$license;
                }

                @Override
                public java.lang.String getName() {
                    return this.$name;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("uuid", om.valueToTree(this.getUuid()));
                    obj.set("code", om.valueToTree(this.getCode()));
                    obj.set("compatibleRuntimes", om.valueToTree(this.getCompatibleRuntimes()));
                    obj.set("description", om.valueToTree(this.getDescription()));
                    obj.set("license", om.valueToTree(this.getLicense()));
                    obj.set("name", om.valueToTree(this.getName()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.SingletonLayerVersionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * A unique identifier to identify this lambda layer version.
         * 
         * The identifier should be unique across all layer providers.
         * We recommend generating a UUID per provider.
         */
        @Override
        public java.lang.String getUuid() {
            return this.jsiiGet("uuid", java.lang.String.class);
        }

        /**
         * The content of this Layer. Using *inline* (per ``code.isInline``) code is not permitted.
         */
        @Override
        public software.amazon.awscdk.services.lambda.Code getCode() {
            return this.jsiiGet("code", software.amazon.awscdk.services.lambda.Code.class);
        }

        /**
         * The runtimes that this layer is compatible with.
         * @default All runtimes are supported
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.lambda.Runtime> getCompatibleRuntimes() {
            return this.jsiiGet("compatibleRuntimes", java.util.List.class);
        }

        /**
         * The description the this Lambda Layer.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * The SPDX licence identifier or URL to the license file for this layer.
         * @default no license information will be recorded.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getLicense() {
            return this.jsiiGet("license", java.lang.String.class);
        }

        /**
         * The name of the layer.
         * @default a name will be generated.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }
    }
}
