package software.amazon.awscdk.services.lambda;

/**
 * A single newly-deployed version of a Lambda function.
 * 
 * This object exists to--at deploy time--query the "then-current" version of
 * the Lambda function that it refers to. This Version object can then be
 * used in `Alias` to refer to a particular deployment of a Lambda.
 * 
 * This means that for every new update you deploy to your Lambda (using the
 * CDK and Aliases), you must always create a new Version object. In
 * particular, it must have a different name, so that a new resource is
 * created.
 * 
 * If you want to ensure that you're associating the right version with
 * the right deployment, specify the `codeSha256` property while
 * creating the `Version.
 *  *
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.921Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.Version")
public class Version extends software.amazon.awscdk.Construct {
    protected Version(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Version(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.VersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * The most recently deployed version of this function.
     */
    public java.lang.String getFunctionVersion() {
        return this.jsiiGet("functionVersion", java.lang.String.class);
    }

    /**
     * Lambda object this version is associated with
     */
    public software.amazon.awscdk.services.lambda.IFunction getLambda() {
        return this.jsiiGet("lambda", software.amazon.awscdk.services.lambda.IFunction.class);
    }
}
