package software.amazon.awscdk.services.lambda;

/**
 * Properties for a new Lambda version
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.921Z")
public interface VersionProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Function to get the value of
     */
    software.amazon.awscdk.services.lambda.IFunction getLambda();
    /**
     * SHA256 of the version of the Lambda source code
     * 
     * Specify to validate that you're deploying the right version.
     * @default No validation is performed
     */
    java.lang.String getCodeSha256();
    /**
     * Description of the version
     * @default Description of the Lambda
     */
    java.lang.String getDescription();

    /**
     * @return a {@link Builder} of {@link VersionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VersionProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.lambda.IFunction _lambda;
        @javax.annotation.Nullable
        private java.lang.String _codeSha256;
        @javax.annotation.Nullable
        private java.lang.String _description;

        /**
         * Sets the value of Lambda
         * @param value Function to get the value of
         * @return {@code this}
         */
        public Builder withLambda(final software.amazon.awscdk.services.lambda.IFunction value) {
            this._lambda = java.util.Objects.requireNonNull(value, "lambda is required");
            return this;
        }
        /**
         * Sets the value of CodeSha256
         * @param value SHA256 of the version of the Lambda source code

Specify to validate that you're deploying the right version.
         * @return {@code this}
         */
        public Builder withCodeSha256(@javax.annotation.Nullable final java.lang.String value) {
            this._codeSha256 = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value Description of the version
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public VersionProps build() {
            return new VersionProps() {
                private final software.amazon.awscdk.services.lambda.IFunction $lambda = java.util.Objects.requireNonNull(_lambda, "lambda is required");
                @javax.annotation.Nullable
                private final java.lang.String $codeSha256 = _codeSha256;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;

                @Override
                public software.amazon.awscdk.services.lambda.IFunction getLambda() {
                    return this.$lambda;
                }

                @Override
                public java.lang.String getCodeSha256() {
                    return this.$codeSha256;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("lambda", om.valueToTree(this.getLambda()));
                    obj.set("codeSha256", om.valueToTree(this.getCodeSha256()));
                    obj.set("description", om.valueToTree(this.getDescription()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.VersionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Function to get the value of
         */
        @Override
        public software.amazon.awscdk.services.lambda.IFunction getLambda() {
            return this.jsiiGet("lambda", software.amazon.awscdk.services.lambda.IFunction.class);
        }

        /**
         * SHA256 of the version of the Lambda source code
         * 
         * Specify to validate that you're deploying the right version.
         * @default No validation is performed
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getCodeSha256() {
            return this.jsiiGet("codeSha256", java.lang.String.class);
        }

        /**
         * Description of the version
         * @default Description of the Lambda
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }
    }
}
