package software.amazon.awscdk.services.lambda;

/**
 * A version/weight pair for routing traffic to Lambda functions
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:38:03.922Z")
public interface VersionWeight extends software.amazon.jsii.JsiiSerializable {
    /**
     * The version to route traffic to
     */
    software.amazon.awscdk.services.lambda.Version getVersion();
    /**
     * How much weight to assign to this version (0..1)
     */
    java.lang.Number getWeight();

    /**
     * @return a {@link Builder} of {@link VersionWeight}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VersionWeight}
     */
    final class Builder {
        private software.amazon.awscdk.services.lambda.Version _version;
        private java.lang.Number _weight;

        /**
         * Sets the value of Version
         * @param value The version to route traffic to
         * @return {@code this}
         */
        public Builder withVersion(final software.amazon.awscdk.services.lambda.Version value) {
            this._version = java.util.Objects.requireNonNull(value, "version is required");
            return this;
        }
        /**
         * Sets the value of Weight
         * @param value How much weight to assign to this version (0..1)
         * @return {@code this}
         */
        public Builder withWeight(final java.lang.Number value) {
            this._weight = java.util.Objects.requireNonNull(value, "weight is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VersionWeight}
         * @throws NullPointerException if any required attribute was not provided
         */
        public VersionWeight build() {
            return new VersionWeight() {
                private final software.amazon.awscdk.services.lambda.Version $version = java.util.Objects.requireNonNull(_version, "version is required");
                private final java.lang.Number $weight = java.util.Objects.requireNonNull(_weight, "weight is required");

                @Override
                public software.amazon.awscdk.services.lambda.Version getVersion() {
                    return this.$version;
                }

                @Override
                public java.lang.Number getWeight() {
                    return this.$weight;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("version", om.valueToTree(this.getVersion()));
                    obj.set("weight", om.valueToTree(this.getWeight()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.VersionWeight {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The version to route traffic to
         */
        @Override
        public software.amazon.awscdk.services.lambda.Version getVersion() {
            return this.jsiiGet("version", software.amazon.awscdk.services.lambda.Version.class);
        }

        /**
         * How much weight to assign to this version (0..1)
         */
        @Override
        public java.lang.Number getWeight() {
            return this.jsiiGet("weight", java.lang.Number.class);
        }
    }
}
