package software.amazon.awscdk.services.lambda;

/**
 * Properties for a new Lambda alias.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:32:56.821Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AliasProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Name of this alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getAliasName();
    /**
     * Function version this alias refers to.
     * 
     * Use lambda.addVersion() to obtain a new lambda version to refer to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.lambda.IVersion getVersion();
    /**
     * Additional versions with individual weights this alias points to.
     * 
     * Individual additional version weights specified here should add up to
     * (less than) one. All remaining weight is routed to the default
     * version.
     * 
     * For example, the config is
     * 
     *     version: "1"
     *     additionalVersions: [{ version: "2", weight: 0.05 }]
     * 
     * Then 5% of traffic will be routed to function version 2, while
     * the remaining 95% of traffic will be routed to function version 1.
     * 
     * Default: No additional versions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> getAdditionalVersions();
    /**
     * Description for the alias.
     * 
     * Default: No description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDescription();

    /**
     * @return a {@link Builder} of {@link AliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _aliasName;
        private software.amazon.awscdk.services.lambda.IVersion _version;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> _additionalVersions;
        @javax.annotation.Nullable
        private java.lang.String _description;

        /**
         * Sets the value of AliasName
         * @param value Name of this alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAliasName(final java.lang.String value) {
            this._aliasName = java.util.Objects.requireNonNull(value, "aliasName is required");
            return this;
        }
        /**
         * Sets the value of Version
         * @param value Function version this alias refers to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVersion(final software.amazon.awscdk.services.lambda.IVersion value) {
            this._version = java.util.Objects.requireNonNull(value, "version is required");
            return this;
        }
        /**
         * Sets the value of AdditionalVersions
         * @param value Additional versions with individual weights this alias points to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAdditionalVersions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> value) {
            this._additionalVersions = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value Description for the alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AliasProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AliasProps build() {
            return new AliasProps() {
                private final java.lang.String $aliasName = java.util.Objects.requireNonNull(_aliasName, "aliasName is required");
                private final software.amazon.awscdk.services.lambda.IVersion $version = java.util.Objects.requireNonNull(_version, "version is required");
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> $additionalVersions = _additionalVersions;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;

                @Override
                public java.lang.String getAliasName() {
                    return this.$aliasName;
                }

                @Override
                public software.amazon.awscdk.services.lambda.IVersion getVersion() {
                    return this.$version;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> getAdditionalVersions() {
                    return this.$additionalVersions;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("aliasName", om.valueToTree(this.getAliasName()));
                    obj.set("version", om.valueToTree(this.getVersion()));
                    if (this.getAdditionalVersions() != null) {
                        obj.set("additionalVersions", om.valueToTree(this.getAdditionalVersions()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.AliasProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Name of this alias.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getAliasName() {
            return this.jsiiGet("aliasName", java.lang.String.class);
        }

        /**
         * Function version this alias refers to.
         * 
         * Use lambda.addVersion() to obtain a new lambda version to refer to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.lambda.IVersion getVersion() {
            return this.jsiiGet("version", software.amazon.awscdk.services.lambda.IVersion.class);
        }

        /**
         * Additional versions with individual weights this alias points to.
         * 
         * Individual additional version weights specified here should add up to
         * (less than) one. All remaining weight is routed to the default
         * version.
         * 
         * For example, the config is
         * 
         *     version: "1"
         *     additionalVersions: [{ version: "2", weight: 0.05 }]
         * 
         * Then 5% of traffic will be routed to function version 2, while
         * the remaining 95% of traffic will be routed to function version 1.
         * 
         * Default: No additional versions
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> getAdditionalVersions() {
            return this.jsiiGet("additionalVersions", java.util.List.class);
        }

        /**
         * Description for the alias.
         * 
         * Default: No description
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }
    }
}
