package software.amazon.awscdk.services.lambda;

/**
 * Lambda code defined using 2 CloudFormation parameters. Useful when you don't have access to the code of your Lambda from your CDK code, so you can't use Assets, and you want to deploy the Lambda in a CodePipeline, using CloudFormation Actions - you can fill the parameters using the {@link #assign} method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:32:56.833Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnParametersCode")
public class CfnParametersCode extends software.amazon.awscdk.services.lambda.Code {
    protected CfnParametersCode(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnParametersCode(@javax.annotation.Nullable final software.amazon.awscdk.services.lambda.CfnParametersCodeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnParametersCode() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Create a parameters map from this instance's CloudFormation parameters.
     * 
     * It returns a map with 2 keys that correspond to the names of the parameters defined in this Lambda code,
     * and as values it contains the appropriate expressions pointing at the provided S3 location
     * (most likely, obtained from a CodePipeline Artifact by calling the `artifact.s3Location` method).
     * The result should be provided to the CloudFormation Action
     * that is deploying the Stack that the Lambda with this code is part of,
     * in the `parameterOverrides` property.
     * 
     * @param location the location of the object in S3 that represents the Lambda code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.Map<java.lang.String, java.lang.Object> assign(final software.amazon.awscdk.services.s3.Location location) {
        return this.jsiiCall("assign", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(location, "location is required") });
    }

    /**
     * Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final software.amazon.awscdk.core.Construct construct) {
        this.jsiiCall("bind", Void.class, new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getBucketNameParam() {
        return this.jsiiGet("bucketNameParam", java.lang.String.class);
    }

    /**
     * Determines whether this Code is inline code or not.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Boolean getIsInline() {
        return this.jsiiGet("isInline", java.lang.Boolean.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getObjectKeyParam() {
        return this.jsiiGet("objectKeyParam", java.lang.String.class);
    }
}
