package software.amazon.awscdk.services.lambda;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:32:56.837Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventSourceMappingProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.EventSourceMappingOptions {
    /**
     * The target AWS Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.lambda.IFunction getTarget();

    /**
     * @return a {@link Builder} of {@link EventSourceMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link EventSourceMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.lambda.IFunction _target;
        private java.lang.String _eventSourceArn;
        @javax.annotation.Nullable
        private java.lang.Number _batchSize;
        @javax.annotation.Nullable
        private java.lang.Boolean _enabled;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.lambda.StartingPosition _startingPosition;

        /**
         * Sets the value of Target
         * @param value The target AWS Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTarget(final software.amazon.awscdk.services.lambda.IFunction value) {
            this._target = java.util.Objects.requireNonNull(value, "target is required");
            return this;
        }
        /**
         * Sets the value of EventSourceArn
         * @param value The Amazon Resource Name (ARN) of the event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withEventSourceArn(final java.lang.String value) {
            this._eventSourceArn = java.util.Objects.requireNonNull(value, "eventSourceArn is required");
            return this;
        }
        /**
         * Sets the value of BatchSize
         * @param value The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBatchSize(@javax.annotation.Nullable final java.lang.Number value) {
            this._batchSize = value;
            return this;
        }
        /**
         * Sets the value of Enabled
         * @param value Set to false to disable the event source upon creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._enabled = value;
            return this;
        }
        /**
         * Sets the value of StartingPosition
         * @param value The position in the DynamoDB or Kinesis stream where AWS Lambda should start reading.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withStartingPosition(@javax.annotation.Nullable final software.amazon.awscdk.services.lambda.StartingPosition value) {
            this._startingPosition = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventSourceMappingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public EventSourceMappingProps build() {
            return new EventSourceMappingProps() {
                private final software.amazon.awscdk.services.lambda.IFunction $target = java.util.Objects.requireNonNull(_target, "target is required");
                private final java.lang.String $eventSourceArn = java.util.Objects.requireNonNull(_eventSourceArn, "eventSourceArn is required");
                @javax.annotation.Nullable
                private final java.lang.Number $batchSize = _batchSize;
                @javax.annotation.Nullable
                private final java.lang.Boolean $enabled = _enabled;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.lambda.StartingPosition $startingPosition = _startingPosition;

                @Override
                public software.amazon.awscdk.services.lambda.IFunction getTarget() {
                    return this.$target;
                }

                @Override
                public java.lang.String getEventSourceArn() {
                    return this.$eventSourceArn;
                }

                @Override
                public java.lang.Number getBatchSize() {
                    return this.$batchSize;
                }

                @Override
                public java.lang.Boolean getEnabled() {
                    return this.$enabled;
                }

                @Override
                public software.amazon.awscdk.services.lambda.StartingPosition getStartingPosition() {
                    return this.$startingPosition;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("target", om.valueToTree(this.getTarget()));
                    obj.set("eventSourceArn", om.valueToTree(this.getEventSourceArn()));
                    if (this.getBatchSize() != null) {
                        obj.set("batchSize", om.valueToTree(this.getBatchSize()));
                    }
                    if (this.getEnabled() != null) {
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                    }
                    if (this.getStartingPosition() != null) {
                        obj.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.EventSourceMappingProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The target AWS Lambda function.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.lambda.IFunction getTarget() {
            return this.jsiiGet("target", software.amazon.awscdk.services.lambda.IFunction.class);
        }

        /**
         * The Amazon Resource Name (ARN) of the event source.
         * 
         * Any record added to
         * this stream can invoke the Lambda function.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getEventSourceArn() {
            return this.jsiiGet("eventSourceArn", java.lang.String.class);
        }

        /**
         * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         * 
         * Your function receives an
         * event with all the retrieved records.
         * 
         * Valid Range: Minimum value of 1. Maximum value of 10000.
         * 
         * Default: - Amazon Kinesis and Amazon DynamoDB is 100 records.
         * Both the default and maximum for Amazon SQS are 10 messages.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getBatchSize() {
            return this.jsiiGet("batchSize", java.lang.Number.class);
        }

        /**
         * Set to false to disable the event source upon creation.
         * 
         * Default: true
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getEnabled() {
            return this.jsiiGet("enabled", java.lang.Boolean.class);
        }

        /**
         * The position in the DynamoDB or Kinesis stream where AWS Lambda should start reading.
         * 
         * Default: - Required for Amazon Kinesis and Amazon DynamoDB Streams sources.
         * 
         * @see https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.lambda.StartingPosition getStartingPosition() {
            return this.jsiiGet("startingPosition", software.amazon.awscdk.services.lambda.StartingPosition.class);
        }
    }
}
