package software.amazon.awscdk.services.lambda;

/**
 * Deploys a file from from inside the construct library as a function.
 * 
 * The supplied file is subject to the 4096 bytes limit of being embedded in a
 * CloudFormation template.
 * 
 * The construct includes an associated role with the lambda.
 * 
 * This construct does not yet reproduce all features from the underlying resource
 * library.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:32:56.840Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.Function")
public class Function extends software.amazon.awscdk.services.lambda.FunctionBase {
    protected Function(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Function(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.FunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.lambda.IFunction fromFunctionArn(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String functionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "fromFunctionArn", software.amazon.awscdk.services.lambda.IFunction.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(functionArn, "functionArn is required") });
    }

    /**
     * Creates a Lambda function object which represents a function not defined within this stack.
     * 
     * Lambda.import(this, 'MyImportedFunction', { lambdaArn: new LambdaArn('arn:aws:...') });
     * 
     * @param scope The parent construct.
     * @param id The name of the lambda construct.
     * @param attrs the attributes of the function to import.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.lambda.IFunction fromFunctionAttributes(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.FunctionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "fromFunctionAttributes", software.amazon.awscdk.services.lambda.IFunction.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Return the given named metric for this Lambda.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAll(final java.lang.String metricName, @javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAll", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Lambda.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAll(final java.lang.String metricName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAll", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Metric for the number of concurrent executions across all Lambdas.
     * 
     * Default: max over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllConcurrentExecutions(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllConcurrentExecutions", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of concurrent executions across all Lambdas.
     * 
     * Default: max over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllConcurrentExecutions() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllConcurrentExecutions", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the Duration executing all Lambdas.
     * 
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllDuration(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllDuration", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the Duration executing all Lambdas.
     * 
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllDuration() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllDuration", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of Errors executing all Lambdas.
     * 
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllErrors(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllErrors", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of Errors executing all Lambdas.
     * 
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllErrors() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllErrors", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of invocations of all Lambdas.
     * 
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllInvocations(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllInvocations", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of invocations of all Lambdas.
     * 
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllInvocations() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllInvocations", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of throttled invocations of all Lambdas.
     * 
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllThrottles(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllThrottles", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of throttled invocations of all Lambdas.
     * 
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllThrottles() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllThrottles", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of unreserved concurrent executions across all Lambdas.
     * 
     * Default: max over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllUnreservedConcurrentExecutions(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllUnreservedConcurrentExecutions", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of unreserved concurrent executions across all Lambdas.
     * 
     * Default: max over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllUnreservedConcurrentExecutions() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllUnreservedConcurrentExecutions", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Adds an environment variable to this Lambda function. If this is a ref to a Lambda function, this operation results in a no-op.
     * 
     * @param key The environment variable key.
     * @param value The environment variable's value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.lambda.Function addEnvironment(final java.lang.String key, @javax.annotation.Nullable final java.lang.Object value) {
        return this.jsiiCall("addEnvironment", software.amazon.awscdk.services.lambda.Function.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * Adds one or more Lambda Layers to this Lambda function.
     * 
     * @param layers the layers to be added.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLayers(final software.amazon.awscdk.services.lambda.ILayerVersion... layers) {
        this.jsiiCall("addLayers", Void.class, java.util.Arrays.<Object>stream(layers).toArray(Object[]::new));
    }

    /**
     * Add a new version for this Lambda.
     * 
     * If you want to deploy through CloudFormation and use aliases, you need to
     * add a new version (with a new name) to your Lambda every time you want
     * to deploy an update. An alias can then refer to the newly created Version.
     * 
     * All versions should have distinct names, and you should not delete versions
     * as long as your Alias needs to refer to them.
     * 
     * @return A new Version object.
     * @param name A unique name for this version.
     * @param codeSha256 The SHA-256 hash of the most recently deployed Lambda source code, or omit to skip validation.
     * @param description A description for this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.lambda.Version addVersion(final java.lang.String name, @javax.annotation.Nullable final java.lang.String codeSha256, @javax.annotation.Nullable final java.lang.String description) {
        return this.jsiiCall("addVersion", software.amazon.awscdk.services.lambda.Version.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), codeSha256, description });
    }

    /**
     * Add a new version for this Lambda.
     * 
     * If you want to deploy through CloudFormation and use aliases, you need to
     * add a new version (with a new name) to your Lambda every time you want
     * to deploy an update. An alias can then refer to the newly created Version.
     * 
     * All versions should have distinct names, and you should not delete versions
     * as long as your Alias needs to refer to them.
     * 
     * @return A new Version object.
     * @param name A unique name for this version.
     * @param codeSha256 The SHA-256 hash of the most recently deployed Lambda source code, or omit to skip validation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.lambda.Version addVersion(final java.lang.String name, @javax.annotation.Nullable final java.lang.String codeSha256) {
        return this.jsiiCall("addVersion", software.amazon.awscdk.services.lambda.Version.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), codeSha256 });
    }

    /**
     * Add a new version for this Lambda.
     * 
     * If you want to deploy through CloudFormation and use aliases, you need to
     * add a new version (with a new name) to your Lambda every time you want
     * to deploy an update. An alias can then refer to the newly created Version.
     * 
     * All versions should have distinct names, and you should not delete versions
     * as long as your Alias needs to refer to them.
     * 
     * @return A new Version object.
     * @param name A unique name for this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.lambda.Version addVersion(final java.lang.String name) {
        return this.jsiiCall("addVersion", software.amazon.awscdk.services.lambda.Version.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Whether the addPermission() call adds any permissions.
     * 
     * True for new Lambdas, false for imported Lambdas (they might live in different accounts).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.lang.Boolean getCanCreatePermissions() {
        return this.jsiiGet("canCreatePermissions", java.lang.Boolean.class);
    }

    /**
     * ARN of this function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getFunctionArn() {
        return this.jsiiGet("functionArn", java.lang.String.class);
    }

    /**
     * Name of this function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getFunctionName() {
        return this.jsiiGet("functionName", java.lang.String.class);
    }

    /**
     * The principal this Lambda Function is running as.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * The runtime configured for this lambda.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.lambda.Runtime getRuntime() {
        return this.jsiiGet("runtime", software.amazon.awscdk.services.lambda.Runtime.class);
    }

    /**
     * Execution role associated with this function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.iam.IRole getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
    }
}
