package software.amazon.awscdk.services.lambda;

/**
 * Construction properties for a LogRetention.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:32:56.854Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogRetentionProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The log group name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getLogGroupName();
    /**
     * The number of days log events are kept in CloudWatch Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.logs.RetentionDays getRetention();

    /**
     * @return a {@link Builder} of {@link LogRetentionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LogRetentionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _logGroupName;
        private software.amazon.awscdk.services.logs.RetentionDays _retention;

        /**
         * Sets the value of LogGroupName
         * @param value The log group name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withLogGroupName(final java.lang.String value) {
            this._logGroupName = java.util.Objects.requireNonNull(value, "logGroupName is required");
            return this;
        }
        /**
         * Sets the value of Retention
         * @param value The number of days log events are kept in CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRetention(final software.amazon.awscdk.services.logs.RetentionDays value) {
            this._retention = java.util.Objects.requireNonNull(value, "retention is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogRetentionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public LogRetentionProps build() {
            return new LogRetentionProps() {
                private final java.lang.String $logGroupName = java.util.Objects.requireNonNull(_logGroupName, "logGroupName is required");
                private final software.amazon.awscdk.services.logs.RetentionDays $retention = java.util.Objects.requireNonNull(_retention, "retention is required");

                @Override
                public java.lang.String getLogGroupName() {
                    return this.$logGroupName;
                }

                @Override
                public software.amazon.awscdk.services.logs.RetentionDays getRetention() {
                    return this.$retention;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("logGroupName", om.valueToTree(this.getLogGroupName()));
                    obj.set("retention", om.valueToTree(this.getRetention()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.LogRetentionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The log group name.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getLogGroupName() {
            return this.jsiiGet("logGroupName", java.lang.String.class);
        }

        /**
         * The number of days log events are kept in CloudWatch Logs.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.logs.RetentionDays getRetention() {
            return this.jsiiGet("retention", software.amazon.awscdk.services.logs.RetentionDays.class);
        }
    }
}
