package software.amazon.awscdk.services.lambda;

/**
 * Properties for a newly created singleton Lambda.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:32:56.857Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SingletonFunctionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.FunctionProps {
    /**
     * A unique identifier to identify this lambda.
     * 
     * The identifier should be unique across all custom resource providers.
     * We recommend generating a UUID per provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getUuid();
    /**
     * A descriptive name for the purpose of this Lambda.
     * 
     * If the Lambda does not have a physical name, this string will be
     * reflected its generated name. The combination of lambdaPurpose
     * and uuid must be unique.
     * 
     * Default: SingletonLambda
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getLambdaPurpose();

    /**
     * @return a {@link Builder} of {@link SingletonFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SingletonFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _uuid;
        @javax.annotation.Nullable
        private java.lang.String _lambdaPurpose;
        private software.amazon.awscdk.services.lambda.Code _code;
        private java.lang.String _handler;
        private software.amazon.awscdk.services.lambda.Runtime _runtime;
        @javax.annotation.Nullable
        private java.lang.Boolean _allowAllOutbound;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.sqs.IQueue _deadLetterQueue;
        @javax.annotation.Nullable
        private java.lang.Boolean _deadLetterQueueEnabled;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.Object> _environment;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.lambda.IEventSource> _events;
        @javax.annotation.Nullable
        private java.lang.String _functionName;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> _initialPolicy;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> _layers;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.logs.RetentionDays _logRetention;
        @javax.annotation.Nullable
        private java.lang.Number _memorySize;
        @javax.annotation.Nullable
        private java.lang.Number _reservedConcurrentExecutions;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.IRole _role;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.ISecurityGroup _securityGroup;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _timeout;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.lambda.Tracing _tracing;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.IVpc _vpc;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.SubnetSelection _vpcSubnets;

        /**
         * Sets the value of Uuid
         * @param value A unique identifier to identify this lambda.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withUuid(final java.lang.String value) {
            this._uuid = java.util.Objects.requireNonNull(value, "uuid is required");
            return this;
        }
        /**
         * Sets the value of LambdaPurpose
         * @param value A descriptive name for the purpose of this Lambda.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withLambdaPurpose(@javax.annotation.Nullable final java.lang.String value) {
            this._lambdaPurpose = value;
            return this;
        }
        /**
         * Sets the value of Code
         * @param value The source code of your Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCode(final software.amazon.awscdk.services.lambda.Code value) {
            this._code = java.util.Objects.requireNonNull(value, "code is required");
            return this;
        }
        /**
         * Sets the value of Handler
         * @param value The name of the function (within your source code) that Lambda calls to start running your code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHandler(final java.lang.String value) {
            this._handler = java.util.Objects.requireNonNull(value, "handler is required");
            return this;
        }
        /**
         * Sets the value of Runtime
         * @param value The runtime environment for the Lambda function that you are uploading. For valid values, see the Runtime property in the AWS Lambda Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRuntime(final software.amazon.awscdk.services.lambda.Runtime value) {
            this._runtime = java.util.Objects.requireNonNull(value, "runtime is required");
            return this;
        }
        /**
         * Sets the value of AllowAllOutbound
         * @param value Whether to allow the Lambda to send all network traffic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAllowAllOutbound(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._allowAllOutbound = value;
            return this;
        }
        /**
         * Sets the value of DeadLetterQueue
         * @param value The SQS queue to use if DLQ is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDeadLetterQueue(@javax.annotation.Nullable final software.amazon.awscdk.services.sqs.IQueue value) {
            this._deadLetterQueue = value;
            return this;
        }
        /**
         * Sets the value of DeadLetterQueueEnabled
         * @param value Enabled DLQ.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDeadLetterQueueEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._deadLetterQueueEnabled = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of Environment
         * @param value Key-value pairs that Lambda caches and makes available for your Lambda functions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withEnvironment(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._environment = value;
            return this;
        }
        /**
         * Sets the value of Events
         * @param value Event sources for this function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withEvents(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.lambda.IEventSource> value) {
            this._events = value;
            return this;
        }
        /**
         * Sets the value of FunctionName
         * @param value A name for the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withFunctionName(@javax.annotation.Nullable final java.lang.String value) {
            this._functionName = value;
            return this;
        }
        /**
         * Sets the value of InitialPolicy
         * @param value Initial policy statements to add to the created Lambda Role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withInitialPolicy(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> value) {
            this._initialPolicy = value;
            return this;
        }
        /**
         * Sets the value of Layers
         * @param value A list of layers to add to the function's execution environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withLayers(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> value) {
            this._layers = value;
            return this;
        }
        /**
         * Sets the value of LogRetention
         * @param value The number of days log events are kept in CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withLogRetention(@javax.annotation.Nullable final software.amazon.awscdk.services.logs.RetentionDays value) {
            this._logRetention = value;
            return this;
        }
        /**
         * Sets the value of MemorySize
         * @param value The amount of memory, in MB, that is allocated to your Lambda function. Lambda uses this value to proportionally allocate the amount of CPU power. For more information, see Resource Model in the AWS Lambda Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withMemorySize(@javax.annotation.Nullable final java.lang.Number value) {
            this._memorySize = value;
            return this;
        }
        /**
         * Sets the value of ReservedConcurrentExecutions
         * @param value The maximum of concurrent executions you want to reserve for the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withReservedConcurrentExecutions(@javax.annotation.Nullable final java.lang.Number value) {
            this._reservedConcurrentExecutions = value;
            return this;
        }
        /**
         * Sets the value of Role
         * @param value Lambda execution role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IRole value) {
            this._role = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroup
         * @param value What security group to associate with the Lambda's network interfaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSecurityGroup(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.ISecurityGroup value) {
            this._securityGroup = value;
            return this;
        }
        /**
         * Sets the value of Timeout
         * @param value The function execution time (in seconds) after which Lambda terminates the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTimeout(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._timeout = value;
            return this;
        }
        /**
         * Sets the value of Tracing
         * @param value Enable AWS X-Ray Tracing for Lambda Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTracing(@javax.annotation.Nullable final software.amazon.awscdk.services.lambda.Tracing value) {
            this._tracing = value;
            return this;
        }
        /**
         * Sets the value of Vpc
         * @param value VPC network to place Lambda network interfaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVpc(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.IVpc value) {
            this._vpc = value;
            return this;
        }
        /**
         * Sets the value of VpcSubnets
         * @param value Where to place the network interfaces within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVpcSubnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetSelection value) {
            this._vpcSubnets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SingletonFunctionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public SingletonFunctionProps build() {
            return new SingletonFunctionProps() {
                private final java.lang.String $uuid = java.util.Objects.requireNonNull(_uuid, "uuid is required");
                @javax.annotation.Nullable
                private final java.lang.String $lambdaPurpose = _lambdaPurpose;
                private final software.amazon.awscdk.services.lambda.Code $code = java.util.Objects.requireNonNull(_code, "code is required");
                private final java.lang.String $handler = java.util.Objects.requireNonNull(_handler, "handler is required");
                private final software.amazon.awscdk.services.lambda.Runtime $runtime = java.util.Objects.requireNonNull(_runtime, "runtime is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $allowAllOutbound = _allowAllOutbound;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.sqs.IQueue $deadLetterQueue = _deadLetterQueue;
                @javax.annotation.Nullable
                private final java.lang.Boolean $deadLetterQueueEnabled = _deadLetterQueueEnabled;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.Object> $environment = _environment;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.lambda.IEventSource> $events = _events;
                @javax.annotation.Nullable
                private final java.lang.String $functionName = _functionName;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> $initialPolicy = _initialPolicy;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> $layers = _layers;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.logs.RetentionDays $logRetention = _logRetention;
                @javax.annotation.Nullable
                private final java.lang.Number $memorySize = _memorySize;
                @javax.annotation.Nullable
                private final java.lang.Number $reservedConcurrentExecutions = _reservedConcurrentExecutions;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.iam.IRole $role = _role;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.ISecurityGroup $securityGroup = _securityGroup;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $timeout = _timeout;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.lambda.Tracing $tracing = _tracing;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.IVpc $vpc = _vpc;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.SubnetSelection $vpcSubnets = _vpcSubnets;

                @Override
                public java.lang.String getUuid() {
                    return this.$uuid;
                }

                @Override
                public java.lang.String getLambdaPurpose() {
                    return this.$lambdaPurpose;
                }

                @Override
                public software.amazon.awscdk.services.lambda.Code getCode() {
                    return this.$code;
                }

                @Override
                public java.lang.String getHandler() {
                    return this.$handler;
                }

                @Override
                public software.amazon.awscdk.services.lambda.Runtime getRuntime() {
                    return this.$runtime;
                }

                @Override
                public java.lang.Boolean getAllowAllOutbound() {
                    return this.$allowAllOutbound;
                }

                @Override
                public software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
                    return this.$deadLetterQueue;
                }

                @Override
                public java.lang.Boolean getDeadLetterQueueEnabled() {
                    return this.$deadLetterQueueEnabled;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.Object> getEnvironment() {
                    return this.$environment;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.lambda.IEventSource> getEvents() {
                    return this.$events;
                }

                @Override
                public java.lang.String getFunctionName() {
                    return this.$functionName;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getInitialPolicy() {
                    return this.$initialPolicy;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> getLayers() {
                    return this.$layers;
                }

                @Override
                public software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
                    return this.$logRetention;
                }

                @Override
                public java.lang.Number getMemorySize() {
                    return this.$memorySize;
                }

                @Override
                public java.lang.Number getReservedConcurrentExecutions() {
                    return this.$reservedConcurrentExecutions;
                }

                @Override
                public software.amazon.awscdk.services.iam.IRole getRole() {
                    return this.$role;
                }

                @Override
                public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
                    return this.$securityGroup;
                }

                @Override
                public software.amazon.awscdk.core.Duration getTimeout() {
                    return this.$timeout;
                }

                @Override
                public software.amazon.awscdk.services.lambda.Tracing getTracing() {
                    return this.$tracing;
                }

                @Override
                public software.amazon.awscdk.services.ec2.IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
                    return this.$vpcSubnets;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("uuid", om.valueToTree(this.getUuid()));
                    if (this.getLambdaPurpose() != null) {
                        obj.set("lambdaPurpose", om.valueToTree(this.getLambdaPurpose()));
                    }
                    obj.set("code", om.valueToTree(this.getCode()));
                    obj.set("handler", om.valueToTree(this.getHandler()));
                    obj.set("runtime", om.valueToTree(this.getRuntime()));
                    if (this.getAllowAllOutbound() != null) {
                        obj.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
                    }
                    if (this.getDeadLetterQueue() != null) {
                        obj.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
                    }
                    if (this.getDeadLetterQueueEnabled() != null) {
                        obj.set("deadLetterQueueEnabled", om.valueToTree(this.getDeadLetterQueueEnabled()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    if (this.getEnvironment() != null) {
                        obj.set("environment", om.valueToTree(this.getEnvironment()));
                    }
                    if (this.getEvents() != null) {
                        obj.set("events", om.valueToTree(this.getEvents()));
                    }
                    if (this.getFunctionName() != null) {
                        obj.set("functionName", om.valueToTree(this.getFunctionName()));
                    }
                    if (this.getInitialPolicy() != null) {
                        obj.set("initialPolicy", om.valueToTree(this.getInitialPolicy()));
                    }
                    if (this.getLayers() != null) {
                        obj.set("layers", om.valueToTree(this.getLayers()));
                    }
                    if (this.getLogRetention() != null) {
                        obj.set("logRetention", om.valueToTree(this.getLogRetention()));
                    }
                    if (this.getMemorySize() != null) {
                        obj.set("memorySize", om.valueToTree(this.getMemorySize()));
                    }
                    if (this.getReservedConcurrentExecutions() != null) {
                        obj.set("reservedConcurrentExecutions", om.valueToTree(this.getReservedConcurrentExecutions()));
                    }
                    if (this.getRole() != null) {
                        obj.set("role", om.valueToTree(this.getRole()));
                    }
                    if (this.getSecurityGroup() != null) {
                        obj.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
                    }
                    if (this.getTimeout() != null) {
                        obj.set("timeout", om.valueToTree(this.getTimeout()));
                    }
                    if (this.getTracing() != null) {
                        obj.set("tracing", om.valueToTree(this.getTracing()));
                    }
                    if (this.getVpc() != null) {
                        obj.set("vpc", om.valueToTree(this.getVpc()));
                    }
                    if (this.getVpcSubnets() != null) {
                        obj.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.SingletonFunctionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * A unique identifier to identify this lambda.
         * 
         * The identifier should be unique across all custom resource providers.
         * We recommend generating a UUID per provider.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getUuid() {
            return this.jsiiGet("uuid", java.lang.String.class);
        }

        /**
         * A descriptive name for the purpose of this Lambda.
         * 
         * If the Lambda does not have a physical name, this string will be
         * reflected its generated name. The combination of lambdaPurpose
         * and uuid must be unique.
         * 
         * Default: SingletonLambda
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getLambdaPurpose() {
            return this.jsiiGet("lambdaPurpose", java.lang.String.class);
        }

        /**
         * The source code of your Lambda function.
         * 
         * You can point to a file in an
         * Amazon Simple Storage Service (Amazon S3) bucket or specify your source
         * code as inline text.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.lambda.Code getCode() {
            return this.jsiiGet("code", software.amazon.awscdk.services.lambda.Code.class);
        }

        /**
         * The name of the function (within your source code) that Lambda calls to start running your code.
         * 
         * For more information, see the Handler property
         * in the AWS Lambda Developer Guide.
         * 
         * NOTE: If you specify your source code as inline text by specifying the
         * ZipFile property within the Code property, specify index.function_name as
         * the handler.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getHandler() {
            return this.jsiiGet("handler", java.lang.String.class);
        }

        /**
         * The runtime environment for the Lambda function that you are uploading. For valid values, see the Runtime property in the AWS Lambda Developer Guide.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.lambda.Runtime getRuntime() {
            return this.jsiiGet("runtime", software.amazon.awscdk.services.lambda.Runtime.class);
        }

        /**
         * Whether to allow the Lambda to send all network traffic.
         * 
         * If set to false, you must individually add traffic rules to allow the
         * Lambda to connect to network targets.
         * 
         * Default: true
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getAllowAllOutbound() {
            return this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
        }

        /**
         * The SQS queue to use if DLQ is enabled.
         * 
         * Default: - SQS queue with 14 day retention period if `deadLetterQueueEnabled` is `true`
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.jsiiGet("deadLetterQueue", software.amazon.awscdk.services.sqs.IQueue.class);
        }

        /**
         * Enabled DLQ.
         * 
         * If `deadLetterQueue` is undefined,
         * an SQS queue with default options will be defined for your Function.
         * 
         * Default: - false unless `deadLetterQueue` is set, which implies DLQ is enabled.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getDeadLetterQueueEnabled() {
            return this.jsiiGet("deadLetterQueueEnabled", java.lang.Boolean.class);
        }

        /**
         * A description of the function.
         * 
         * Default: - No description.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Key-value pairs that Lambda caches and makes available for your Lambda functions.
         * 
         * Use environment variables to apply configuration changes, such
         * as test and production environment configurations, without changing your
         * Lambda function source code.
         * 
         * Default: - No environment variables.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Object> getEnvironment() {
            return this.jsiiGet("environment", java.util.Map.class);
        }

        /**
         * Event sources for this function.
         * 
         * You can also add event sources using `addEventSource`.
         * 
         * Default: - No event sources.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.lambda.IEventSource> getEvents() {
            return this.jsiiGet("events", java.util.List.class);
        }

        /**
         * A name for the function.
         * 
         * Default: - AWS CloudFormation generates a unique physical ID and uses that
         * ID for the function's name. For more information, see Name Type.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getFunctionName() {
            return this.jsiiGet("functionName", java.lang.String.class);
        }

        /**
         * Initial policy statements to add to the created Lambda Role.
         * 
         * You can call `addToRolePolicy` to the created lambda to add statements post creation.
         * 
         * Default: - No policy statements are added to the created Lambda role.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getInitialPolicy() {
            return this.jsiiGet("initialPolicy", java.util.List.class);
        }

        /**
         * A list of layers to add to the function's execution environment.
         * 
         * You can configure your Lambda function to pull in
         * additional code during initialization in the form of layers. Layers are packages of libraries or other dependencies
         * that can be used by mulitple functions.
         * 
         * Default: - No layers.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> getLayers() {
            return this.jsiiGet("layers", java.util.List.class);
        }

        /**
         * The number of days log events are kept in CloudWatch Logs.
         * 
         * When updating
         * this property, unsetting it doesn't remove the log retention policy. To
         * remove the retention policy, set the value to `Infinity`.
         * 
         * Default: - Logs never expire.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.jsiiGet("logRetention", software.amazon.awscdk.services.logs.RetentionDays.class);
        }

        /**
         * The amount of memory, in MB, that is allocated to your Lambda function. Lambda uses this value to proportionally allocate the amount of CPU power. For more information, see Resource Model in the AWS Lambda Developer Guide.
         * 
         * Default: 128
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getMemorySize() {
            return this.jsiiGet("memorySize", java.lang.Number.class);
        }

        /**
         * The maximum of concurrent executions you want to reserve for the function.
         * 
         * Default: - No specific limit - account limit.
         * 
         * @see https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getReservedConcurrentExecutions() {
            return this.jsiiGet("reservedConcurrentExecutions", java.lang.Number.class);
        }

        /**
         * Lambda execution role.
         * 
         * This is the role that will be assumed by the function upon execution.
         * It controls the permissions that the function will have. The Role must
         * be assumable by the 'lambda.amazonaws.com' service principal.
         * 
         * Default: - A unique role will be generated for this lambda function.
         * Both supplied and generated roles can always be changed by calling `addToRolePolicy`.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
        }

        /**
         * What security group to associate with the Lambda's network interfaces.
         * 
         * Only used if 'vpc' is supplied.
         * 
         * Default: - If the function is placed within a VPC and a security group is
         * not specified, a dedicated security group will be created for this
         * function.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
        }

        /**
         * The function execution time (in seconds) after which Lambda terminates the function.
         * 
         * Because the execution time affects cost, set this value
         * based on the function's expected execution time.
         * 
         * Default: Duration.seconds(3)
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getTimeout() {
            return this.jsiiGet("timeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Enable AWS X-Ray Tracing for Lambda Function.
         * 
         * Default: Tracing.Disabled
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.lambda.Tracing getTracing() {
            return this.jsiiGet("tracing", software.amazon.awscdk.services.lambda.Tracing.class);
        }

        /**
         * VPC network to place Lambda network interfaces.
         * 
         * Specify this if the Lambda function needs to access resources in a VPC.
         * 
         * Default: - Function is not placed within a VPC.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * Where to place the network interfaces within the VPC.
         * 
         * Only used if 'vpc' is supplied. Note: internet access for Lambdas
         * requires a NAT gateway, so picking Public subnets is not allowed.
         * 
         * Default: - Private subnets.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }
    }
}
