package software.amazon.awscdk.services.lambda;

/**
 * Properties for a new Lambda version.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:32:56.860Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VersionProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Function to get the value of.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.lambda.IFunction getLambda();
    /**
     * SHA256 of the version of the Lambda source code.
     * 
     * Specify to validate that you're deploying the right version.
     * 
     * Default: No validation is performed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getCodeSha256();
    /**
     * Description of the version.
     * 
     * Default: Description of the Lambda
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDescription();

    /**
     * @return a {@link Builder} of {@link VersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.lambda.IFunction _lambda;
        @javax.annotation.Nullable
        private java.lang.String _codeSha256;
        @javax.annotation.Nullable
        private java.lang.String _description;

        /**
         * Sets the value of Lambda
         * @param value Function to get the value of.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withLambda(final software.amazon.awscdk.services.lambda.IFunction value) {
            this._lambda = java.util.Objects.requireNonNull(value, "lambda is required");
            return this;
        }
        /**
         * Sets the value of CodeSha256
         * @param value SHA256 of the version of the Lambda source code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCodeSha256(@javax.annotation.Nullable final java.lang.String value) {
            this._codeSha256 = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value Description of the version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public VersionProps build() {
            return new VersionProps() {
                private final software.amazon.awscdk.services.lambda.IFunction $lambda = java.util.Objects.requireNonNull(_lambda, "lambda is required");
                @javax.annotation.Nullable
                private final java.lang.String $codeSha256 = _codeSha256;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;

                @Override
                public software.amazon.awscdk.services.lambda.IFunction getLambda() {
                    return this.$lambda;
                }

                @Override
                public java.lang.String getCodeSha256() {
                    return this.$codeSha256;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("lambda", om.valueToTree(this.getLambda()));
                    if (this.getCodeSha256() != null) {
                        obj.set("codeSha256", om.valueToTree(this.getCodeSha256()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.VersionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Function to get the value of.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.lambda.IFunction getLambda() {
            return this.jsiiGet("lambda", software.amazon.awscdk.services.lambda.IFunction.class);
        }

        /**
         * SHA256 of the version of the Lambda source code.
         * 
         * Specify to validate that you're deploying the right version.
         * 
         * Default: No validation is performed
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getCodeSha256() {
            return this.jsiiGet("codeSha256", java.lang.String.class);
        }

        /**
         * Description of the version.
         * 
         * Default: Description of the Lambda
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }
    }
}
