package software.amazon.awscdk.services.lambda;

/**
 * A version/weight pair for routing traffic to Lambda functions.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:32:56.860Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VersionWeight extends software.amazon.jsii.JsiiSerializable {
    /**
     * The version to route traffic to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.lambda.IVersion getVersion();
    /**
     * How much weight to assign to this version (0..1).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getWeight();

    /**
     * @return a {@link Builder} of {@link VersionWeight}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VersionWeight}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.lambda.IVersion _version;
        private java.lang.Number _weight;

        /**
         * Sets the value of Version
         * @param value The version to route traffic to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVersion(final software.amazon.awscdk.services.lambda.IVersion value) {
            this._version = java.util.Objects.requireNonNull(value, "version is required");
            return this;
        }
        /**
         * Sets the value of Weight
         * @param value How much weight to assign to this version (0..1).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withWeight(final java.lang.Number value) {
            this._weight = java.util.Objects.requireNonNull(value, "weight is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VersionWeight}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public VersionWeight build() {
            return new VersionWeight() {
                private final software.amazon.awscdk.services.lambda.IVersion $version = java.util.Objects.requireNonNull(_version, "version is required");
                private final java.lang.Number $weight = java.util.Objects.requireNonNull(_weight, "weight is required");

                @Override
                public software.amazon.awscdk.services.lambda.IVersion getVersion() {
                    return this.$version;
                }

                @Override
                public java.lang.Number getWeight() {
                    return this.$weight;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("version", om.valueToTree(this.getVersion()));
                    obj.set("weight", om.valueToTree(this.getWeight()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.VersionWeight {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The version to route traffic to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.lambda.IVersion getVersion() {
            return this.jsiiGet("version", software.amazon.awscdk.services.lambda.IVersion.class);
        }

        /**
         * How much weight to assign to this version (0..1).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.Number getWeight() {
            return this.jsiiGet("weight", java.lang.Number.class);
        }
    }
}
