package software.amazon.awscdk.services.lambda;

/**
 * Defines a Lambda EventSourceMapping resource.
 * <p>
 * Usually, you won't need to define the mapping yourself. This will usually be done by
 * event sources. For example, to add an SQS event source to a function:
 * <p>
 * <blockquote><pre>
 * import { SqsEventSource } from '&#64;aws-cdk/aws-lambda-event-sources';
 * lambda.addEventSource(new SqsEventSource(sqs));
 * </pre></blockquote>
 * <p>
 * The <code>SqsEventSource</code> class will automatically create the mapping, and will also
 * modify the Lambda's execution role so it can consume messages from the queue.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-11T15:14:48.029Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.EventSourceMapping")
public class EventSourceMapping extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.lambda.IEventSourceMapping {

    protected EventSourceMapping(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventSourceMapping(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EventSourceMapping(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventSourceMappingProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an event source into this stack from its event source id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param eventSourceMappingId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IEventSourceMapping fromEventSourceMappingId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String eventSourceMappingId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.EventSourceMapping.class, "fromEventSourceMappingId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IEventSourceMapping.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(eventSourceMappingId, "eventSourceMappingId is required") });
    }

    /**
     * The identifier for this EventSourceMapping.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventSourceMappingId() {
        return software.amazon.jsii.Kernel.get(this, "eventSourceMappingId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.EventSourceMapping}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.EventSourceMapping> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.EventSourceMappingProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.EventSourceMappingProps.Builder();
        }

        /**
         * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         * <p>
         * Your function receives an
         * event with all the retrieved records.
         * <p>
         * Valid Range: Minimum value of 1. Maximum value of 10000.
         * <p>
         * Default: - Amazon Kinesis, Amazon DynamoDB, and Amazon MSK is 100 records.
         * Both the default and maximum for Amazon SQS are 10 messages.
         * <p>
         * @return {@code this}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(final java.lang.Number batchSize) {
            this.props.batchSize(batchSize);
            return this;
        }

        /**
         * If the function returns an error, split the batch in two and retry.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param bisectBatchOnError If the function returns an error, split the batch in two and retry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bisectBatchOnError(final java.lang.Boolean bisectBatchOnError) {
            this.props.bisectBatchOnError(bisectBatchOnError);
            return this;
        }

        /**
         * Set to false to disable the event source upon creation.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Set to false to disable the event source upon creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the event source.
         * <p>
         * Any record added to
         * this stream can invoke the Lambda function.
         * <p>
         * Default: - not set if using a self managed Kafka cluster, throws an error otherwise
         * <p>
         * @return {@code this}
         * @param eventSourceArn The Amazon Resource Name (ARN) of the event source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceArn(final java.lang.String eventSourceArn) {
            this.props.eventSourceArn(eventSourceArn);
            return this;
        }

        /**
         * A list of host and port pairs that are the addresses of the Kafka brokers in a self managed "bootstrap" Kafka cluster that a Kafka client connects to initially to bootstrap itself.
         * <p>
         * They are in the format <code>abc.example.com:9096</code>.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param kafkaBootstrapServers A list of host and port pairs that are the addresses of the Kafka brokers in a self managed "bootstrap" Kafka cluster that a Kafka client connects to initially to bootstrap itself. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaBootstrapServers(final java.util.List<java.lang.String> kafkaBootstrapServers) {
            this.props.kafkaBootstrapServers(kafkaBootstrapServers);
            return this;
        }

        /**
         * The name of the Kafka topic.
         * <p>
         * Default: - no topic
         * <p>
         * @return {@code this}
         * @param kafkaTopic The name of the Kafka topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaTopic(final java.lang.String kafkaTopic) {
            this.props.kafkaTopic(kafkaTopic);
            return this;
        }

        /**
         * The maximum amount of time to gather records before invoking the function.
         * <p>
         * Maximum of Duration.minutes(5)
         * <p>
         * Default: Duration.seconds(0)
         * <p>
         * @return {@code this}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(final software.amazon.awscdk.core.Duration maxBatchingWindow) {
            this.props.maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        /**
         * The maximum age of a record that Lambda sends to a function for processing.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 60 seconds</li>
         * <li>Maximum value of 7 days</li>
         * </ul>
         * <p>
         * Default: - infinite or until the record expires.
         * <p>
         * @return {@code this}
         * @param maxRecordAge The maximum age of a record that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRecordAge(final software.amazon.awscdk.core.Duration maxRecordAge) {
            this.props.maxRecordAge(maxRecordAge);
            return this;
        }

        /**
         * An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * <p>
         * Default: discarded records are ignored
         * <p>
         * @return {@code this}
         * @param onFailure An Amazon SQS queue or Amazon SNS topic destination for discarded records. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        /**
         * The number of batches to process from each shard concurrently.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 1</li>
         * <li>Maximum value of 10</li>
         * </ul>
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param parallelizationFactor The number of batches to process from each shard concurrently. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parallelizationFactor(final java.lang.Number parallelizationFactor) {
            this.props.parallelizationFactor(parallelizationFactor);
            return this;
        }

        /**
         * The maximum number of times to retry when the function returns an error.
         * <p>
         * Set to <code>undefined</code> if you want lambda to keep retrying infinitely or until
         * the record expires.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 0</li>
         * <li>Maximum value of 10000</li>
         * </ul>
         * <p>
         * Default: - infinite or until the record expires.
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * Specific settings like the authentication protocol or the VPC components to secure access to your event source.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-sourceaccessconfiguration.html
         * @param sourceAccessConfigurations Specific settings like the authentication protocol or the VPC components to secure access to your event source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAccessConfigurations(final java.util.List<? extends software.amazon.awscdk.services.lambda.SourceAccessConfiguration> sourceAccessConfigurations) {
            this.props.sourceAccessConfigurations(sourceAccessConfigurations);
            return this;
        }

        /**
         * The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start reading.
         * <p>
         * Default: - Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK Streams sources.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType
         * @param startingPosition The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start reading. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(final software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.props.startingPosition(startingPosition);
            return this;
        }

        /**
         * The size of the tumbling windows to group records sent to DynamoDB or Kinesis.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-windows
         * Valid Range: 0 - 15 minutes
         * @param tumblingWindow The size of the tumbling windows to group records sent to DynamoDB or Kinesis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tumblingWindow(final software.amazon.awscdk.core.Duration tumblingWindow) {
            this.props.tumblingWindow(tumblingWindow);
            return this;
        }

        /**
         * The target AWS Lambda function.
         * <p>
         * @return {@code this}
         * @param target The target AWS Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final software.amazon.awscdk.services.lambda.IFunction target) {
            this.props.target(target);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.EventSourceMapping}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.EventSourceMapping build() {
            return new software.amazon.awscdk.services.lambda.EventSourceMapping(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
