package software.amazon.awscdk.services.lambda;

/**
 * Properties to initialize a new AssetImage.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-29T20:30:48.390Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.AssetImageCodeProps")
@software.amazon.jsii.Jsii.Proxy(AssetImageCodeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssetImageCodeProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecr.assets.DockerImageAssetOptions {

    /**
     * Specify or override the CMD on the specified Docker image or Dockerfile.
     * <p>
     * This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
     * <p>
     * Default: - use the CMD specified in the docker image or Dockerfile.
     * <p>
     * @see https://docs.docker.com/engine/reference/builder/#cmd
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCmd() {
        return null;
    }

    /**
     * Specify or override the ENTRYPOINT on the specified Docker image or Dockerfile.
     * <p>
     * An ENTRYPOINT allows you to configure a container that will run as an executable.
     * This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
     * <p>
     * Default: - use the ENTRYPOINT in the docker image or Dockerfile.
     * <p>
     * @see https://docs.docker.com/engine/reference/builder/#entrypoint
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEntrypoint() {
        return null;
    }

    /**
     * Specify or override the WORKDIR on the specified Docker image or Dockerfile.
     * <p>
     * A WORKDIR allows you to configure the working directory the container will use.
     * <p>
     * Default: - use the WORKDIR in the docker image or Dockerfile.
     * <p>
     * @see https://docs.docker.com/engine/reference/builder/#workdir
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDirectory() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AssetImageCodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssetImageCodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssetImageCodeProps> {
        private java.util.List<java.lang.String> cmd;
        private java.util.List<java.lang.String> entrypoint;
        private java.lang.String workingDirectory;
        private java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private java.lang.String file;
        private java.lang.String repositoryName;
        private java.lang.String target;
        private java.lang.String extraHash;
        private java.util.List<java.lang.String> exclude;
        private software.amazon.awscdk.assets.FollowMode follow;
        private software.amazon.awscdk.core.IgnoreMode ignoreMode;
        private software.amazon.awscdk.core.SymlinkFollowMode followSymlinks;

        /**
         * Sets the value of {@link AssetImageCodeProps#getCmd}
         * @param cmd Specify or override the CMD on the specified Docker image or Dockerfile.
         *            This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmd(java.util.List<java.lang.String> cmd) {
            this.cmd = cmd;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageCodeProps#getEntrypoint}
         * @param entrypoint Specify or override the ENTRYPOINT on the specified Docker image or Dockerfile.
         *                   An ENTRYPOINT allows you to configure a container that will run as an executable.
         *                   This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entrypoint(java.util.List<java.lang.String> entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageCodeProps#getWorkingDirectory}
         * @param workingDirectory Specify or override the WORKDIR on the specified Docker image or Dockerfile.
         *                         A WORKDIR allows you to configure the working directory the container will use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(java.lang.String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageCodeProps#getBuildArgs}
         * @param buildArgs Build args to pass to the `docker build` command.
         *                  Since Docker build arguments are resolved before deployment, keys and
         *                  values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
         *                  <code>queue.queueUrl</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildArgs(java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageCodeProps#getFile}
         * @param file Path to the Dockerfile (relative to the directory).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder file(java.lang.String file) {
            this.file = file;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageCodeProps#getRepositoryName}
         * @param repositoryName ECR repository name.
         *                       Specify this property if you need to statically address the image, e.g.
         *                       from a Kubernetes Pod. Note, this is only the repository name, without the
         *                       registry and the tag parts.
         * @return {@code this}
         * @deprecated to control the location of docker image assets, please override
`Stack.addDockerImageAsset`. this feature will be removed in future
releases.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageCodeProps#getTarget}
         * @param target Docker target to build to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageCodeProps#getExtraHash}
         * @param extraHash Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraHash(java.lang.String extraHash) {
            this.extraHash = extraHash;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageCodeProps#getExclude}
         * @param exclude Glob patterns to exclude from the copy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageCodeProps#getFollow}
         * @param follow A strategy for how to handle symlinks.
         * @return {@code this}
         * @deprecated use `followSymlinks` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder follow(software.amazon.awscdk.assets.FollowMode follow) {
            this.follow = follow;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageCodeProps#getIgnoreMode}
         * @param ignoreMode The ignore behavior to use for exclude patterns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMode(software.amazon.awscdk.core.IgnoreMode ignoreMode) {
            this.ignoreMode = ignoreMode;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageCodeProps#getFollowSymlinks}
         * @param followSymlinks A strategy for how to handle symlinks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder followSymlinks(software.amazon.awscdk.core.SymlinkFollowMode followSymlinks) {
            this.followSymlinks = followSymlinks;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssetImageCodeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssetImageCodeProps build() {
            return new Jsii$Proxy(cmd, entrypoint, workingDirectory, buildArgs, file, repositoryName, target, extraHash, exclude, follow, ignoreMode, followSymlinks);
        }
    }

    /**
     * An implementation for {@link AssetImageCodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetImageCodeProps {
        private final java.util.List<java.lang.String> cmd;
        private final java.util.List<java.lang.String> entrypoint;
        private final java.lang.String workingDirectory;
        private final java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private final java.lang.String file;
        private final java.lang.String repositoryName;
        private final java.lang.String target;
        private final java.lang.String extraHash;
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.assets.FollowMode follow;
        private final software.amazon.awscdk.core.IgnoreMode ignoreMode;
        private final software.amazon.awscdk.core.SymlinkFollowMode followSymlinks;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cmd = software.amazon.jsii.Kernel.get(this, "cmd", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.entrypoint = software.amazon.jsii.Kernel.get(this, "entrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.buildArgs = software.amazon.jsii.Kernel.get(this, "buildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extraHash = software.amazon.jsii.Kernel.get(this, "extraHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.follow = software.amazon.jsii.Kernel.get(this, "follow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assets.FollowMode.class));
            this.ignoreMode = software.amazon.jsii.Kernel.get(this, "ignoreMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IgnoreMode.class));
            this.followSymlinks = software.amazon.jsii.Kernel.get(this, "followSymlinks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SymlinkFollowMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.util.List<java.lang.String> cmd, final java.util.List<java.lang.String> entrypoint, final java.lang.String workingDirectory, final java.util.Map<java.lang.String, java.lang.String> buildArgs, final java.lang.String file, final java.lang.String repositoryName, final java.lang.String target, final java.lang.String extraHash, final java.util.List<java.lang.String> exclude, final software.amazon.awscdk.assets.FollowMode follow, final software.amazon.awscdk.core.IgnoreMode ignoreMode, final software.amazon.awscdk.core.SymlinkFollowMode followSymlinks) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cmd = cmd;
            this.entrypoint = entrypoint;
            this.workingDirectory = workingDirectory;
            this.buildArgs = buildArgs;
            this.file = file;
            this.repositoryName = repositoryName;
            this.target = target;
            this.extraHash = extraHash;
            this.exclude = exclude;
            this.follow = follow;
            this.ignoreMode = ignoreMode;
            this.followSymlinks = followSymlinks;
        }

        @Override
        public final java.util.List<java.lang.String> getCmd() {
            return this.cmd;
        }

        @Override
        public final java.util.List<java.lang.String> getEntrypoint() {
            return this.entrypoint;
        }

        @Override
        public final java.lang.String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
            return this.buildArgs;
        }

        @Override
        public final java.lang.String getFile() {
            return this.file;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getExtraHash() {
            return this.extraHash;
        }

        @Override
        public final java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public final software.amazon.awscdk.assets.FollowMode getFollow() {
            return this.follow;
        }

        @Override
        public final software.amazon.awscdk.core.IgnoreMode getIgnoreMode() {
            return this.ignoreMode;
        }

        @Override
        public final software.amazon.awscdk.core.SymlinkFollowMode getFollowSymlinks() {
            return this.followSymlinks;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCmd() != null) {
                data.set("cmd", om.valueToTree(this.getCmd()));
            }
            if (this.getEntrypoint() != null) {
                data.set("entrypoint", om.valueToTree(this.getEntrypoint()));
            }
            if (this.getWorkingDirectory() != null) {
                data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
            }
            if (this.getBuildArgs() != null) {
                data.set("buildArgs", om.valueToTree(this.getBuildArgs()));
            }
            if (this.getFile() != null) {
                data.set("file", om.valueToTree(this.getFile()));
            }
            if (this.getRepositoryName() != null) {
                data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            }
            if (this.getTarget() != null) {
                data.set("target", om.valueToTree(this.getTarget()));
            }
            if (this.getExtraHash() != null) {
                data.set("extraHash", om.valueToTree(this.getExtraHash()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getFollow() != null) {
                data.set("follow", om.valueToTree(this.getFollow()));
            }
            if (this.getIgnoreMode() != null) {
                data.set("ignoreMode", om.valueToTree(this.getIgnoreMode()));
            }
            if (this.getFollowSymlinks() != null) {
                data.set("followSymlinks", om.valueToTree(this.getFollowSymlinks()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.AssetImageCodeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssetImageCodeProps.Jsii$Proxy that = (AssetImageCodeProps.Jsii$Proxy) o;

            if (this.cmd != null ? !this.cmd.equals(that.cmd) : that.cmd != null) return false;
            if (this.entrypoint != null ? !this.entrypoint.equals(that.entrypoint) : that.entrypoint != null) return false;
            if (this.workingDirectory != null ? !this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory != null) return false;
            if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) return false;
            if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
            if (this.repositoryName != null ? !this.repositoryName.equals(that.repositoryName) : that.repositoryName != null) return false;
            if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
            if (this.extraHash != null ? !this.extraHash.equals(that.extraHash) : that.extraHash != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.follow != null ? !this.follow.equals(that.follow) : that.follow != null) return false;
            if (this.ignoreMode != null ? !this.ignoreMode.equals(that.ignoreMode) : that.ignoreMode != null) return false;
            return this.followSymlinks != null ? this.followSymlinks.equals(that.followSymlinks) : that.followSymlinks == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cmd != null ? this.cmd.hashCode() : 0;
            result = 31 * result + (this.entrypoint != null ? this.entrypoint.hashCode() : 0);
            result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
            result = 31 * result + (this.buildArgs != null ? this.buildArgs.hashCode() : 0);
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + (this.repositoryName != null ? this.repositoryName.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            result = 31 * result + (this.extraHash != null ? this.extraHash.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.follow != null ? this.follow.hashCode() : 0);
            result = 31 * result + (this.ignoreMode != null ? this.ignoreMode.hashCode() : 0);
            result = 31 * result + (this.followSymlinks != null ? this.followSymlinks.hashCode() : 0);
            return result;
        }
    }
}
